/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.backup.impl;

import java.io.File;
import java.io.IOException;
import org.apache.jackrabbit.oak.backup.FileStoreRestore;
import org.apache.jackrabbit.oak.commons.time.Stopwatch;
import org.apache.jackrabbit.oak.segment.ClassicCompactor;
import org.apache.jackrabbit.oak.segment.DefaultSegmentWriter;
import org.apache.jackrabbit.oak.segment.Revisions;
import org.apache.jackrabbit.oak.segment.SegmentBufferWriter;
import org.apache.jackrabbit.oak.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.segment.WriterCacheManager;
import org.apache.jackrabbit.oak.segment.file.CompactedNodeState;
import org.apache.jackrabbit.oak.segment.file.CompactionWriter;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.file.FileStoreBuilder;
import org.apache.jackrabbit.oak.segment.file.GCNodeWriteMonitor;
import org.apache.jackrabbit.oak.segment.file.InvalidFileStoreVersionException;
import org.apache.jackrabbit.oak.segment.file.ReadOnlyFileStore;
import org.apache.jackrabbit.oak.segment.file.cancel.Canceller;
import org.apache.jackrabbit.oak.segment.file.tar.GCGeneration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStoreRestoreImpl
implements FileStoreRestore {
    private static final Logger log = LoggerFactory.getLogger(FileStoreRestoreImpl.class);
    private static final String JOURNAL_FILE_NAME = "journal.log";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restore(File source, File destination) throws IOException, InvalidFileStoreVersionException {
        if (!FileStoreRestoreImpl.validFileStore(source)) {
            throw new IOException("Folder " + String.valueOf(source) + " is not a valid FileStore directory");
        }
        ReadOnlyFileStore restore = FileStoreBuilder.fileStoreBuilder(source).buildReadOnly();
        Stopwatch watch = Stopwatch.createStarted();
        FileStore store = FileStoreBuilder.fileStoreBuilder(destination).withStrictVersionCheck(true).build();
        SegmentNodeState current = store.getHead();
        try {
            SegmentNodeState head = restore.getHead();
            GCGeneration gen = head.getRecordId().getSegmentId().getGcGeneration();
            SegmentBufferWriter bufferWriter = new SegmentBufferWriter(store.getSegmentIdProvider(), "r", gen);
            DefaultSegmentWriter writer = new DefaultSegmentWriter(store, store.getReader(), store.getSegmentIdProvider(), store.getBlobStore(), new WriterCacheManager.Default(), bufferWriter, store.getBinariesInlineThreshold());
            CompactionWriter compactionWriter = new CompactionWriter(store.getReader(), store.getBlobStore(), gen, writer);
            ClassicCompactor compactor = new ClassicCompactor(compactionWriter, GCNodeWriteMonitor.EMPTY);
            CompactedNodeState after = compactor.compactUp(current, head, Canceller.newCanceller());
            compactionWriter.flush();
            store.getRevisions().setHead(current.getRecordId(), after.getRecordId(), new Revisions.Option[0]);
        }
        finally {
            restore.close();
            store.close();
        }
        watch.stop();
        log.info("Restore finished in {}.", (Object)watch);
    }

    @Override
    public void restore(File source) {
        log.warn("Restore not available as an online operation.");
    }

    private static boolean validFileStore(File source) {
        if (source == null || !source.isDirectory()) {
            return false;
        }
        String[] children = source.list();
        if (children == null) {
            return false;
        }
        for (String f : children) {
            if (!JOURNAL_FILE_NAME.equals(f)) continue;
            return true;
        }
        return false;
    }
}

