/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.plugins.blob.BlobStoreBlob;
import org.apache.jackrabbit.oak.segment.LoggingHook;
import org.apache.jackrabbit.oak.segment.Revisions;
import org.apache.jackrabbit.oak.segment.SegmentBlob;
import org.apache.jackrabbit.oak.segment.SegmentNodeBuilder;
import org.apache.jackrabbit.oak.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.segment.SegmentNodeStoreStats;
import org.apache.jackrabbit.oak.segment.SegmentReader;
import org.apache.jackrabbit.oak.segment.SegmentWriter;
import org.apache.jackrabbit.oak.segment.scheduler.Commit;
import org.apache.jackrabbit.oak.segment.scheduler.LockBasedScheduler;
import org.apache.jackrabbit.oak.segment.scheduler.Scheduler;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.CompositeHook;
import org.apache.jackrabbit.oak.spi.commit.Observable;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.state.ConflictAnnotatingRebaseDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentNodeStore
implements NodeStore,
Observable {
    static final String ROOT = "root";
    public static final String CHECKPOINTS = "checkpoints";
    @NotNull
    private final SegmentWriter writer;
    @NotNull
    private final Scheduler scheduler;
    @Nullable
    private final BlobStore blobStore;
    private final SegmentNodeStoreStats stats;
    private final LoggingHook loggingHook;

    @NotNull
    public static SegmentNodeStoreBuilder builder(@NotNull Revisions revisions, @NotNull SegmentReader reader, @NotNull SegmentWriter writer, @Nullable BlobStore blobStore) {
        return new SegmentNodeStoreBuilder(Objects.requireNonNull(revisions), Objects.requireNonNull(reader), Objects.requireNonNull(writer), blobStore);
    }

    private SegmentNodeStore(SegmentNodeStoreBuilder builder) {
        this.writer = builder.writer;
        this.blobStore = builder.blobStore;
        this.stats = new SegmentNodeStoreStats(builder.statsProvider);
        this.scheduler = LockBasedScheduler.builder(builder.revisions, builder.reader, this.stats).dispatchChanges(builder.dispatchChanges).build();
        this.loggingHook = builder.loggingHook;
    }

    public Closeable addObserver(Observer observer) {
        if (this.scheduler instanceof Observable) {
            return ((Observable)this.scheduler).addObserver(observer);
        }
        return () -> {};
    }

    @NotNull
    public NodeState getRoot() {
        return this.scheduler.getHeadNodeState().getChildNode(ROOT);
    }

    @NotNull
    public NodeState merge(@NotNull NodeBuilder builder, @NotNull CommitHook commitHook, @NotNull CommitInfo info) throws CommitFailedException {
        Validate.checkArgument((boolean)(builder instanceof SegmentNodeBuilder));
        Validate.checkArgument((boolean)((SegmentNodeBuilder)builder).isRootBuilder());
        if (this.loggingHook != null) {
            commitHook = new CompositeHook(new CommitHook[]{commitHook, this.loggingHook});
        }
        return this.scheduler.schedule(new Commit(builder, commitHook, info), new Scheduler.SchedulerOption[0]);
    }

    @NotNull
    public NodeState rebase(@NotNull NodeBuilder builder) {
        Validate.checkArgument((boolean)(builder instanceof SegmentNodeBuilder));
        SegmentNodeBuilder snb = (SegmentNodeBuilder)builder;
        NodeState root = this.getRoot();
        NodeState before = snb.getBaseState();
        if (!SegmentNodeState.fastEquals(before, root)) {
            SegmentNodeState after = snb.getNodeState();
            snb.reset(root);
            after.compareAgainstBaseState(before, (NodeStateDiff)new ConflictAnnotatingRebaseDiff((NodeBuilder)snb));
        }
        return snb.getNodeState();
    }

    @NotNull
    public NodeState reset(@NotNull NodeBuilder builder) {
        Validate.checkArgument((boolean)(builder instanceof SegmentNodeBuilder));
        SegmentNodeBuilder snb = (SegmentNodeBuilder)builder;
        NodeState root = this.getRoot();
        snb.reset(root);
        return root;
    }

    @NotNull
    public Blob createBlob(InputStream stream) throws IOException {
        return new SegmentBlob(this.blobStore, this.writer.writeStream(stream));
    }

    public Blob getBlob(@NotNull String reference) {
        if (this.blobStore != null) {
            String blobId = this.blobStore.getBlobId(reference);
            if (blobId != null) {
                return new BlobStoreBlob(this.blobStore, blobId);
            }
            return null;
        }
        throw new IllegalStateException("Attempt to read external blob with blobId [" + reference + "] without specifying BlobStore");
    }

    @NotNull
    public String checkpoint(long lifetime, @NotNull Map<String, String> properties) {
        return this.scheduler.checkpoint(lifetime, properties);
    }

    @NotNull
    public synchronized String checkpoint(long lifetime) {
        return this.checkpoint(lifetime, Collections.emptyMap());
    }

    @NotNull
    public Map<String, String> checkpointInfo(@NotNull String checkpoint) {
        HashMap<String, String> properties = new HashMap<String, String>();
        Objects.requireNonNull(checkpoint);
        NodeState cp = this.scheduler.getHeadNodeState().getChildNode(CHECKPOINTS).getChildNode(checkpoint).getChildNode("properties");
        for (PropertyState prop : cp.getProperties()) {
            properties.put(prop.getName(), (String)prop.getValue(Type.STRING));
        }
        return properties;
    }

    @NotNull
    public Iterable<String> checkpoints() {
        return this.getCheckpoints().getChildNodeNames();
    }

    @Nullable
    public NodeState retrieve(@NotNull String checkpoint) {
        Objects.requireNonNull(checkpoint);
        NodeState cp = this.scheduler.getHeadNodeState().getChildNode(CHECKPOINTS).getChildNode(checkpoint).getChildNode(ROOT);
        if (cp.exists()) {
            return cp;
        }
        return null;
    }

    public boolean release(@NotNull String checkpoint) {
        return this.scheduler.removeCheckpoint(checkpoint);
    }

    NodeState getCheckpoints() {
        return this.scheduler.getHeadNodeState().getChildNode(CHECKPOINTS);
    }

    public SegmentNodeStoreStats getStats() {
        return this.stats;
    }

    public static class SegmentNodeStoreBuilder {
        private static final Logger LOG = LoggerFactory.getLogger(SegmentNodeStoreBuilder.class);
        @NotNull
        private final Revisions revisions;
        @NotNull
        private final SegmentReader reader;
        @NotNull
        private final SegmentWriter writer;
        @Nullable
        private final BlobStore blobStore;
        private boolean isCreated;
        private boolean dispatchChanges = true;
        @NotNull
        private StatisticsProvider statsProvider = StatisticsProvider.NOOP;
        private LoggingHook loggingHook;

        private SegmentNodeStoreBuilder(@NotNull Revisions revisions, @NotNull SegmentReader reader, @NotNull SegmentWriter writer, @Nullable BlobStore blobStore) {
            this.revisions = revisions;
            this.reader = reader;
            this.writer = writer;
            this.blobStore = blobStore;
        }

        @NotNull
        public SegmentNodeStoreBuilder dispatchChanges(boolean dispatchChanges) {
            this.dispatchChanges = dispatchChanges;
            return this;
        }

        @NotNull
        public SegmentNodeStoreBuilder withStatisticsProvider(@NotNull StatisticsProvider statisticsProvider) {
            this.statsProvider = Objects.requireNonNull(statisticsProvider);
            return this;
        }

        @NotNull
        public SegmentNodeStoreBuilder withLoggingHook(Consumer<String> writer) {
            this.loggingHook = LoggingHook.newLoggingHook(writer);
            return this;
        }

        @NotNull
        public SegmentNodeStore build() {
            Validate.checkState((!this.isCreated ? 1 : 0) != 0);
            this.isCreated = true;
            LOG.info("Creating segment node store {}", (Object)this);
            return new SegmentNodeStore(this);
        }

        @NotNull
        private static String getString(@Nullable BlobStore blobStore) {
            return "blobStore=" + String.valueOf(blobStore == null ? "inline" : blobStore);
        }

        public String toString() {
            return "SegmentNodeStoreBuilder{" + SegmentNodeStoreBuilder.getString(this.blobStore) + "}";
        }
    }
}

