/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import java.util.Comparator;
import java.util.Objects;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.StringUtils;
import org.jetbrains.annotations.NotNull;

public class PropertyTemplate
implements Comparable<PropertyTemplate> {
    private final int index;
    private final String name;
    private final Type<?> type;

    PropertyTemplate(int index, String name, Type<?> type) {
        this.index = index;
        this.name = Objects.requireNonNull(name);
        this.type = Objects.requireNonNull(type);
    }

    PropertyTemplate(PropertyState state) {
        Objects.requireNonNull(state);
        this.index = 0;
        this.name = state.getName();
        this.type = state.getType();
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public Type<?> getType() {
        return this.type;
    }

    @Override
    public int compareTo(@NotNull PropertyTemplate template) {
        Objects.requireNonNull(template);
        return Comparator.comparingInt(PropertyTemplate::hashCode).thenComparing(PropertyTemplate::getName).thenComparing(PropertyTemplate::getType).compare(this, template);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof PropertyTemplate) {
            PropertyTemplate that = (PropertyTemplate)object;
            return this.name.equals(that.name) && this.type.equals(that.type);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name + "(" + String.valueOf(this.type) + ")";
    }

    public int estimateMemoryUsage() {
        return 28 + StringUtils.estimateMemoryUsage((String)this.name);
    }
}

