/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.MemoryChildNodeEntry;
import org.apache.jackrabbit.oak.segment.ClassicCompactor;
import org.apache.jackrabbit.oak.segment.Compactor;
import org.apache.jackrabbit.oak.segment.CompactorUtils;
import org.apache.jackrabbit.oak.segment.file.CompactedNodeState;
import org.apache.jackrabbit.oak.segment.file.CompactionWriter;
import org.apache.jackrabbit.oak.segment.file.GCNodeWriteMonitor;
import org.apache.jackrabbit.oak.segment.file.cancel.Canceller;
import org.apache.jackrabbit.oak.spi.gc.GCMonitor;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.DefaultNodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CheckpointCompactor
extends Compactor {
    @NotNull
    protected final GCMonitor gcListener;
    @NotNull
    private final Map<NodeState, CompactedNodeState> cpCache = new HashMap<NodeState, CompactedNodeState>();
    @NotNull
    protected final ClassicCompactor compactor;

    public CheckpointCompactor(@NotNull GCMonitor gcListener, @NotNull CompactionWriter writer, @NotNull GCNodeWriteMonitor compactionMonitor) {
        this.gcListener = gcListener;
        this.compactor = new ClassicCompactor(writer, compactionMonitor);
    }

    @Override
    @Nullable
    public CompactedNodeState compactDown(@NotNull NodeState before, @NotNull NodeState after, @NotNull Canceller hardCanceller, @NotNull Canceller softCanceller) throws IOException {
        Iterator<Map.Entry<String, NodeState>> iterator = this.collectRoots(before, after).entrySet().iterator();
        Map.Entry<String, NodeState> entry = iterator.next();
        String path = entry.getKey();
        CompactedNodeState compacted = this.cpCache.get(entry.getValue());
        this.gcListener.info("compacting {}.", new Object[]{path});
        if (compacted == null && (compacted = this.compactDownWithDelegate(CheckpointCompactor.getRoot(before), entry.getValue(), hardCanceller, softCanceller)) == null) {
            return null;
        }
        NodeBuilder builder = after.builder();
        Buffer stableIdBytes = Objects.requireNonNull(CompactorUtils.getStableIdBytes(after));
        CheckpointCompactor.getChild(builder, PathUtils.getParentPath((String)path)).setChildNode(PathUtils.getName((String)path), (NodeState)compacted);
        if (!compacted.isComplete()) {
            return this.compactor.writeNodeState(builder.getNodeState(), stableIdBytes, false);
        }
        this.cpCache.put(entry.getValue(), compacted);
        before = entry.getValue();
        while (iterator.hasNext()) {
            entry = iterator.next();
            path = entry.getKey();
            this.gcListener.info("compacting {}.", new Object[]{path});
            compacted = this.compactWithCache(before, entry.getValue(), compacted, hardCanceller);
            if (compacted == null) {
                return null;
            }
            before = entry.getValue();
            Validate.checkState((boolean)compacted.isComplete());
            CheckpointCompactor.getChild(builder, PathUtils.getParentPath((String)path)).setChildNode(PathUtils.getName((String)path), (NodeState)compacted);
            if (!softCanceller.check().isCancelled()) continue;
            return this.compactor.writeNodeState(builder.getNodeState(), stableIdBytes, false);
        }
        return this.compactor.writeNodeState(builder.getNodeState(), stableIdBytes, true);
    }

    @Override
    @Nullable
    public CompactedNodeState compact(@NotNull NodeState before, @NotNull NodeState after, @NotNull NodeState onto, @NotNull Canceller canceller) throws IOException {
        LinkedHashMap<String, NodeState> roots = this.collectRoots(before, after);
        NodeBuilder builder = after.builder();
        Buffer stableIdBytes = Objects.requireNonNull(CompactorUtils.getStableIdBytes(after));
        before = CheckpointCompactor.getRoot(before);
        onto = CheckpointCompactor.getRoot(onto);
        for (Map.Entry<String, NodeState> entry : roots.entrySet()) {
            String path = entry.getKey();
            after = entry.getValue();
            CompactedNodeState compacted = this.compactWithCache(before, after, onto, canceller);
            if (compacted == null) {
                return null;
            }
            Validate.checkState((boolean)compacted.isComplete());
            CheckpointCompactor.getChild(builder, PathUtils.getParentPath((String)path)).setChildNode(PathUtils.getName((String)path), (NodeState)compacted);
            before = after;
            onto = compacted;
        }
        return this.compactor.writeNodeState(builder.getNodeState(), stableIdBytes, true);
    }

    @Nullable
    private CompactedNodeState compactWithCache(@NotNull NodeState before, @NotNull NodeState after, @NotNull NodeState onto, @NotNull Canceller canceller) throws IOException {
        CompactedNodeState compacted = this.cpCache.get(after);
        if (compacted == null) {
            compacted = this.compactWithDelegate(before, after, onto, canceller);
            if (compacted != null) {
                this.cpCache.put(after, compacted);
            }
        } else {
            this.gcListener.info("found checkpoint in cache.", new Object[0]);
        }
        return compacted;
    }

    @NotNull
    private LinkedHashMap<String, NodeState> collectRoots(@NotNull NodeState superRootBefore, @NotNull NodeState superRootAfter) {
        final ArrayList checkpoints = new ArrayList();
        superRootAfter.getChildNode("checkpoints").compareAgainstBaseState(superRootBefore.getChildNode("checkpoints"), (NodeStateDiff)new DefaultNodeStateDiff(){

            public boolean childNodeAdded(String name, NodeState after) {
                checkpoints.add(new MemoryChildNodeEntry(name, after));
                return true;
            }
        });
        checkpoints.sort((cne1, cne2) -> {
            long c1 = cne1.getNodeState().getLong("created");
            long c2 = cne2.getNodeState().getLong("created");
            return Long.compare(c1, c2);
        });
        LinkedHashMap<String, NodeState> roots = new LinkedHashMap<String, NodeState>();
        for (ChildNodeEntry checkpoint : checkpoints) {
            String name = checkpoint.getName();
            NodeState node = checkpoint.getNodeState();
            this.gcListener.info("found checkpoint {} created on {}.", new Object[]{name, new Date(node.getLong("created"))});
            roots.put("checkpoints/" + name + "/root", node.getChildNode("root"));
        }
        roots.put("root", superRootAfter.getChildNode("root"));
        return roots;
    }

    @NotNull
    private static NodeState getRoot(@NotNull NodeState node) {
        return node.hasChildNode("root") ? node.getChildNode("root") : EmptyNodeState.EMPTY_NODE;
    }

    @NotNull
    private static NodeBuilder getChild(NodeBuilder builder, String path) {
        for (String name : PathUtils.elements((String)path)) {
            builder = builder.getChildNode(name);
        }
        return builder;
    }

    @Nullable
    protected CompactedNodeState compactDownWithDelegate(@NotNull NodeState before, @NotNull NodeState after, @NotNull Canceller hardCanceller, @NotNull Canceller softCanceller) throws IOException {
        return this.compactor.compactDown(before, after, hardCanceller, softCanceller);
    }

    @Nullable
    protected CompactedNodeState compactWithDelegate(@NotNull NodeState before, @NotNull NodeState after, @NotNull NodeState onto, @NotNull Canceller canceller) throws IOException {
        return this.compactor.compact(before, after, onto, canceller);
    }
}

