/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.tool.iotrace;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.segment.tool.iotrace.Trace;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;

public class BreadthFirstTrace
implements Trace {
    @NotNull
    public static final String CONTEXT_SPEC = "depth,count";
    private final int depth;
    @NotNull
    private final String path;
    @NotNull
    private final Consumer<List<String>> context;
    @NotNull
    private final AtomicInteger nodeCount = new AtomicInteger();

    public BreadthFirstTrace(int depth, @NotNull String path, @NotNull Consumer<List<String>> context) {
        Validate.checkArgument((depth >= 0 ? 1 : 0) != 0);
        this.depth = depth;
        this.path = path;
        this.context = context;
    }

    @Override
    public void run(@NotNull NodeState node) {
        BreadthFirstTrace.updateContext(this.context, 0, this.nodeCount.incrementAndGet());
        this.traverse(new LinkedList<NodeState>(Collections.singleton(BreadthFirstTrace.getNode(node, this.path))), 0);
    }

    @NotNull
    private static NodeState getNode(@NotNull NodeState root, @NotNull String path) {
        NodeState node = root;
        for (String name : PathUtils.elements((String)path)) {
            node = node.getChildNode(name);
        }
        return node;
    }

    private void traverse(@NotNull Queue<NodeState> nodes, int depth) {
        if (!nodes.isEmpty()) {
            LinkedList<NodeState> children = new LinkedList<NodeState>();
            while (!nodes.isEmpty()) {
                NodeState head = nodes.poll();
                assert (head != null);
                if (depth >= this.depth) continue;
                head.getChildNodeEntries().forEach(cse -> {
                    BreadthFirstTrace.updateContext(this.context, depth + 1, this.nodeCount.incrementAndGet());
                    NodeState child = cse.getNodeState();
                    if (depth + 1 < this.depth) {
                        children.offer(child);
                    }
                });
            }
            this.traverse(children, depth + 1);
        }
    }

    private static void updateContext(@NotNull Consumer<List<String>> context, int depth, int count) {
        context.accept(List.of(String.valueOf(depth), String.valueOf(count)));
    }
}

