/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.server;

import java.util.ArrayList;
import java.util.UUID;
import org.apache.jackrabbit.oak.segment.Segment;
import org.apache.jackrabbit.oak.segment.SegmentId;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.standby.server.StandbyReferencesReader;

class DefaultStandbyReferencesReader
implements StandbyReferencesReader {
    private final FileStore store;

    DefaultStandbyReferencesReader(FileStore store) {
        this.store = store;
    }

    @Override
    public Iterable<String> readReferences(String id) {
        UUID uuid = UUID.fromString(id);
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        SegmentId segmentId = this.store.getSegmentIdProvider().newSegmentId(msb, lsb);
        if (this.store.containsSegment(segmentId)) {
            Segment segment = this.store.readSegment(segmentId);
            ArrayList<String> references = new ArrayList<String>();
            for (int i = 0; i < segment.getReferencedSegmentIdCount(); ++i) {
                references.add(segment.getReferencedSegmentId(i).toString());
            }
            return references;
        }
        return null;
    }
}

