/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.file.tar.GCGeneration;
import org.apache.jackrabbit.oak.segment.spi.persistence.GCJournalFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCJournal {
    private static final Logger LOG = LoggerFactory.getLogger(GCJournal.class);
    private final GCJournalFile journalFile;
    private GCJournalEntry latest;

    public GCJournal(@NotNull GCJournalFile journalFile) {
        this.journalFile = journalFile;
    }

    public synchronized void persist(long reclaimedSize, long repoSize, @NotNull GCGeneration gcGeneration, long nodes, @NotNull RecordId root) {
        GCJournalEntry current = this.read();
        if (root.equals(RecordId.NULL) || root.toString10().equals(current.root)) {
            return;
        }
        this.latest = new GCJournalEntry(repoSize, reclaimedSize, System.currentTimeMillis(), gcGeneration, nodes, root.toString10());
        try {
            this.journalFile.writeLine(this.latest.toString());
        }
        catch (IOException e) {
            LOG.error("Error writing gc journal", (Throwable)e);
        }
    }

    public synchronized GCJournalEntry read() {
        if (this.latest == null) {
            List<String> all = this.readLines();
            if (all.isEmpty()) {
                this.latest = GCJournalEntry.EMPTY;
            } else {
                String info = all.get(all.size() - 1);
                this.latest = GCJournalEntry.fromString(info);
            }
        }
        return this.latest;
    }

    public synchronized Collection<GCJournalEntry> readAll() {
        ArrayList<GCJournalEntry> all = new ArrayList<GCJournalEntry>();
        for (String l : this.readLines()) {
            all.add(GCJournalEntry.fromString(l));
        }
        return all;
    }

    private List<String> readLines() {
        try {
            return this.journalFile.readLines();
        }
        catch (IOException e) {
            LOG.error("Error reading gc journal", (Throwable)e);
            return new ArrayList<String>();
        }
    }

    public static class GCJournalEntry {
        static final GCJournalEntry EMPTY = new GCJournalEntry(-1L, -1L, -1L, GCGeneration.NULL, -1L, RecordId.NULL.toString10());
        private final long repoSize;
        private final long reclaimedSize;
        private final long ts;
        @NotNull
        private final GCGeneration gcGeneration;
        private final long nodes;
        @NotNull
        private final String root;

        public GCJournalEntry(long repoSize, long reclaimedSize, long ts, @NotNull GCGeneration gcGeneration, long nodes, @NotNull String root) {
            this.repoSize = repoSize;
            this.reclaimedSize = reclaimedSize;
            this.ts = ts;
            this.gcGeneration = gcGeneration;
            this.nodes = nodes;
            this.root = root;
        }

        public String toString() {
            return String.join((CharSequence)",", Long.toString(this.repoSize), Long.toString(this.reclaimedSize), Long.toString(this.ts), Integer.toString(this.gcGeneration.getGeneration()), Integer.toString(this.gcGeneration.getFullGeneration()), Long.toString(this.nodes), this.root);
        }

        static GCJournalEntry fromString(String in) {
            String[] items = in.split(",");
            int index = 0;
            long repoSize = GCJournalEntry.parseLong(items, index++);
            long reclaimedSize = GCJournalEntry.parseLong(items, index++);
            long ts = GCJournalEntry.parseLong(items, index++);
            int generation = GCJournalEntry.parseInt(items, index++);
            int fullGeneration = items.length == 7 ? GCJournalEntry.parseInt(items, index++) : generation;
            long nodes = GCJournalEntry.parseLong(items, index++);
            String root = GCJournalEntry.parseString(items, index);
            if (root == null) {
                root = RecordId.NULL.toString10();
            }
            return new GCJournalEntry(repoSize, reclaimedSize, ts, GCGeneration.newGCGeneration(generation, fullGeneration, false), nodes, root);
        }

        @Nullable
        private static String parseString(String[] items, int index) {
            if (index >= items.length) {
                return null;
            }
            return items[index];
        }

        private static long parseLong(String[] items, int index) {
            String in = GCJournalEntry.parseString(items, index);
            if (in != null) {
                try {
                    return Long.parseLong(in);
                }
                catch (NumberFormatException ex) {
                    LOG.warn("Unable to parse {} as long value.", (Object)in, (Object)ex);
                }
            }
            return -1L;
        }

        private static int parseInt(String[] items, int index) {
            String in = GCJournalEntry.parseString(items, index);
            if (in != null) {
                try {
                    return Integer.parseInt(in);
                }
                catch (NumberFormatException e) {
                    LOG.warn("Unable to parse {} as an integer value.", (Object)in, (Object)e);
                }
            }
            return -1;
        }

        public long getRepoSize() {
            return this.repoSize;
        }

        public long getReclaimedSize() {
            return this.reclaimedSize;
        }

        public long getTs() {
            return this.ts;
        }

        @NotNull
        public GCGeneration getGcGeneration() {
            return this.gcGeneration;
        }

        public long getNodes() {
            return this.nodes;
        }

        @NotNull
        public String getRoot() {
            return this.root;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.gcGeneration.hashCode();
            result = 31 * result + this.root.hashCode();
            result = 31 * result + Long.hashCode(this.nodes);
            result = 31 * result + Long.hashCode(this.reclaimedSize);
            result = 31 * result + Long.hashCode(this.repoSize);
            result = 31 * result + Long.hashCode(this.ts);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GCJournalEntry other = (GCJournalEntry)obj;
            if (!this.gcGeneration.equals(other.gcGeneration)) {
                return false;
            }
            if (this.nodes != other.nodes) {
                return false;
            }
            if (this.reclaimedSize != other.reclaimedSize) {
                return false;
            }
            if (this.repoSize != other.repoSize) {
                return false;
            }
            if (this.ts != other.ts) {
                return false;
            }
            return this.root.equals(other.root);
        }
    }
}

