/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import java.io.IOException;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.Revisions;
import org.apache.jackrabbit.oak.segment.SegmentCache;
import org.apache.jackrabbit.oak.segment.SegmentReader;
import org.apache.jackrabbit.oak.segment.SegmentTracker;
import org.apache.jackrabbit.oak.segment.SegmentWriterFactory;
import org.apache.jackrabbit.oak.segment.compaction.SegmentGCOptions;
import org.apache.jackrabbit.oak.segment.compaction.SegmentGCStatus;
import org.apache.jackrabbit.oak.segment.file.CleanupStrategy;
import org.apache.jackrabbit.oak.segment.file.CompactionResult;
import org.apache.jackrabbit.oak.segment.file.CompactionStrategy;
import org.apache.jackrabbit.oak.segment.file.DefaultCleanupStrategy;
import org.apache.jackrabbit.oak.segment.file.EstimationResult;
import org.apache.jackrabbit.oak.segment.file.EstimationStrategy;
import org.apache.jackrabbit.oak.segment.file.FallbackCompactionStrategy;
import org.apache.jackrabbit.oak.segment.file.FileStoreStats;
import org.apache.jackrabbit.oak.segment.file.Flusher;
import org.apache.jackrabbit.oak.segment.file.FullCompactionStrategy;
import org.apache.jackrabbit.oak.segment.file.FullSizeDeltaEstimationStrategy;
import org.apache.jackrabbit.oak.segment.file.GCJournal;
import org.apache.jackrabbit.oak.segment.file.GCListener;
import org.apache.jackrabbit.oak.segment.file.GCMemoryBarrier;
import org.apache.jackrabbit.oak.segment.file.GCNodeWriteMonitor;
import org.apache.jackrabbit.oak.segment.file.GarbageCollectionStrategy;
import org.apache.jackrabbit.oak.segment.file.PrintableStopwatch;
import org.apache.jackrabbit.oak.segment.file.SuccessfulCompactionListener;
import org.apache.jackrabbit.oak.segment.file.TailCompactionStrategy;
import org.apache.jackrabbit.oak.segment.file.TailSizeDeltaEstimationStrategy;
import org.apache.jackrabbit.oak.segment.file.cancel.Canceller;
import org.apache.jackrabbit.oak.segment.file.tar.GCGeneration;
import org.apache.jackrabbit.oak.segment.file.tar.TarFiles;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;

class DefaultGarbageCollectionStrategy
implements GarbageCollectionStrategy {
    DefaultGarbageCollectionStrategy() {
    }

    EstimationStrategy getFullEstimationStrategy() {
        return new FullSizeDeltaEstimationStrategy();
    }

    EstimationStrategy getTailEstimationStrategy() {
        return new TailSizeDeltaEstimationStrategy();
    }

    CompactionStrategy getFullCompactionStrategy(GarbageCollectionStrategy.Context context) {
        return new FullCompactionStrategy();
    }

    CompactionStrategy getTailCompactionStrategy(GarbageCollectionStrategy.Context context) {
        return new FallbackCompactionStrategy(new TailCompactionStrategy(), new FullCompactionStrategy());
    }

    CleanupStrategy getCleanupStrategy() {
        return new DefaultCleanupStrategy();
    }

    @Override
    public void collectGarbage(GarbageCollectionStrategy.Context context) throws IOException {
        switch (context.getGCOptions().getGCType()) {
            case FULL: {
                this.collectFullGarbage(context);
                break;
            }
            case TAIL: {
                this.collectTailGarbage(context);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid GC type");
            }
        }
    }

    @Override
    public void collectFullGarbage(GarbageCollectionStrategy.Context context) throws IOException {
        this.run(context, this.getFullEstimationStrategy(), this.getFullCompactionStrategy(context));
    }

    @Override
    public void collectTailGarbage(GarbageCollectionStrategy.Context context) throws IOException {
        this.run(context, this.getTailEstimationStrategy(), this.getTailCompactionStrategy(context));
    }

    @Override
    public CompactionResult compactFull(GarbageCollectionStrategy.Context context) throws IOException {
        return this.getFullCompactionStrategy(context).compact(DefaultGarbageCollectionStrategy.newCompactionStrategyContext(context));
    }

    @Override
    public CompactionResult compactTail(GarbageCollectionStrategy.Context context) throws IOException {
        return this.getTailCompactionStrategy(context).compact(DefaultGarbageCollectionStrategy.newCompactionStrategyContext(context));
    }

    @Override
    public List<String> cleanup(GarbageCollectionStrategy.Context context) throws IOException {
        return this.cleanup(context, CompactionResult.skipped(context.getLastCompactionType(), context.getRevisions().getHead().getSegmentId().getGcGeneration(), context.getGCOptions(), context.getRevisions().getHead(), context.getGCCount()));
    }

    public List<String> cleanup(GarbageCollectionStrategy.Context context, CompactionResult compactionResult) throws IOException {
        return this.getCleanupStrategy().cleanup(this.newCleanupStrategyContext(context, compactionResult));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(GarbageCollectionStrategy.Context context, EstimationStrategy estimationStrategy, CompactionStrategy compactionStrategy) throws IOException {
        block22: {
            try {
                context.getGCListener().info("started", new Object[0]);
                long dt = System.currentTimeMillis() - context.getLastSuccessfulGC();
                if (dt < context.getGCBackOff()) {
                    context.getGCListener().skipped("skipping garbage collection as it already ran less than {} hours ago ({} s).", new Object[]{context.getGCBackOff() / 3600000L, dt / 1000L});
                    return;
                }
                boolean sufficientEstimatedGain = true;
                if (context.getGCOptions().isEstimationDisabled()) {
                    context.getGCListener().info("estimation skipped because it was explicitly disabled", new Object[0]);
                } else if (context.getGCOptions().isPaused()) {
                    context.getGCListener().info("estimation skipped because compaction is paused", new Object[0]);
                } else {
                    context.getGCListener().info("estimation started", new Object[0]);
                    context.getGCListener().updateStatus(SegmentGCStatus.ESTIMATION.message());
                    PrintableStopwatch watch = PrintableStopwatch.createStarted();
                    EstimationResult estimation = estimationStrategy.estimate(this.newEstimationStrategyContext(context));
                    sufficientEstimatedGain = estimation.isGcNeeded();
                    String gcLog = estimation.getGcLog();
                    if (sufficientEstimatedGain) {
                        context.getGCListener().info("estimation completed in {}. {}", new Object[]{watch, gcLog});
                    } else {
                        context.getGCListener().skipped("estimation completed in {}. {}", new Object[]{watch, gcLog});
                    }
                }
                if (!sufficientEstimatedGain) break block22;
                try (GCMemoryBarrier ignored = new GCMemoryBarrier(context.getSufficientMemory(), context.getGCListener(), context.getGCOptions());){
                    if (context.getGCOptions().isPaused()) {
                        context.getGCListener().skipped("compaction paused", new Object[0]);
                    } else if (!context.getSufficientMemory().get()) {
                        context.getGCListener().skipped("compaction skipped. Not enough memory", new Object[0]);
                    } else {
                        CompactionResult compactionResult = compactionStrategy.compact(DefaultGarbageCollectionStrategy.newCompactionStrategyContext(context));
                        if (compactionResult.isSuccess()) {
                            context.getSuccessfulGarbageCollectionListener().onSuccessfulGarbageCollection();
                        } else {
                            context.getGCListener().info("cleaning up after failed compaction", new Object[0]);
                        }
                        context.getFileReaper().add(this.cleanup(context, compactionResult));
                    }
                }
            }
            finally {
                context.getCompactionMonitor().finished();
                context.getGCListener().updateStatus(SegmentGCStatus.IDLE.message());
            }
        }
    }

    private EstimationStrategy.Context newEstimationStrategyContext(final GarbageCollectionStrategy.Context context) {
        return new EstimationStrategy.Context(){

            @Override
            public long getSizeDelta() {
                return context.getGCOptions().getGcSizeDeltaEstimation();
            }

            @Override
            public long getCurrentSize() {
                return context.getTarFiles().size();
            }

            @Override
            public GCJournal getGCJournal() {
                return context.getGCJournal();
            }
        };
    }

    private static CompactionStrategy.Context newCompactionStrategyContext(final GarbageCollectionStrategy.Context context) {
        return new CompactionStrategy.Context(){

            @Override
            public SegmentTracker getSegmentTracker() {
                return context.getSegmentTracker();
            }

            @Override
            public GCListener getGCListener() {
                return context.getGCListener();
            }

            @Override
            public GCJournal getGCJournal() {
                return context.getGCJournal();
            }

            @Override
            public SegmentGCOptions getGCOptions() {
                return context.getGCOptions();
            }

            @Override
            public GCNodeWriteMonitor getCompactionMonitor() {
                return context.getCompactionMonitor();
            }

            @Override
            public SegmentReader getSegmentReader() {
                return context.getSegmentReader();
            }

            @Override
            public SegmentWriterFactory getSegmentWriterFactory() {
                return context.getSegmentWriterFactory();
            }

            @Override
            public Revisions getRevisions() {
                return context.getRevisions();
            }

            @Override
            public TarFiles getTarFiles() {
                return context.getTarFiles();
            }

            @Override
            public BlobStore getBlobStore() {
                return context.getBlobStore();
            }

            @Override
            public Canceller getHardCanceller() {
                return context.getCanceller();
            }

            @Override
            public Canceller getSoftCanceller() {
                return Canceller.newCanceller();
            }

            @Override
            public Supplier<Canceller> getStateSaveTriggerSupplier() {
                return Canceller::newCanceller;
            }

            @Override
            public int getGCCount() {
                return context.getGCCount();
            }

            @Override
            public SuccessfulCompactionListener getSuccessfulCompactionListener() {
                return context.getSuccessfulCompactionListener();
            }

            @Override
            public Flusher getFlusher() {
                return context.getFlusher();
            }
        };
    }

    private CleanupStrategy.Context newCleanupStrategyContext(final GarbageCollectionStrategy.Context context, final CompactionResult compactionResult) {
        return new CleanupStrategy.Context(){

            @Override
            public GCListener getGCListener() {
                return context.getGCListener();
            }

            @Override
            public SegmentCache getSegmentCache() {
                return context.getSegmentCache();
            }

            @Override
            public SegmentTracker getSegmentTracker() {
                return context.getSegmentTracker();
            }

            @Override
            public FileStoreStats getFileStoreStats() {
                return context.getFileStoreStats();
            }

            @Override
            public GCNodeWriteMonitor getCompactionMonitor() {
                return context.getCompactionMonitor();
            }

            @Override
            public GCJournal getGCJournal() {
                return context.getGCJournal();
            }

            @Override
            public Predicate<GCGeneration> getReclaimer() {
                return compactionResult.reclaimer();
            }

            @Override
            public TarFiles getTarFiles() {
                return context.getTarFiles();
            }

            @Override
            public Revisions getRevisions() {
                return context.getRevisions();
            }

            @Override
            public RecordId getCompactedRootId() {
                return compactionResult.getCompactedRootId();
            }

            @Override
            public String getSegmentEvictionReason() {
                return compactionResult.gcInfo();
            }
        };
    }
}

