/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import java.io.IOException;
import java.util.List;
import org.apache.jackrabbit.oak.segment.compaction.SegmentGCStatus;
import org.apache.jackrabbit.oak.segment.file.CleanupStrategy;
import org.apache.jackrabbit.oak.segment.file.DefaultCleanupContext;
import org.apache.jackrabbit.oak.segment.file.GCJournal;
import org.apache.jackrabbit.oak.segment.file.PrintableBytes;
import org.apache.jackrabbit.oak.segment.file.PrintableStopwatch;
import org.apache.jackrabbit.oak.segment.file.tar.CleanupContext;
import org.apache.jackrabbit.oak.segment.file.tar.GCGeneration;
import org.apache.jackrabbit.oak.segment.file.tar.TarFiles;
import org.jetbrains.annotations.NotNull;

class DefaultCleanupStrategy
implements CleanupStrategy {
    DefaultCleanupStrategy() {
    }

    @Override
    public List<String> cleanup(CleanupStrategy.Context context) throws IOException {
        PrintableStopwatch watch = PrintableStopwatch.createStarted();
        context.getGCListener().info("cleanup started using reclaimer {}", new Object[]{context.getReclaimer()});
        context.getGCListener().updateStatus(SegmentGCStatus.CLEANUP.message());
        context.getSegmentCache().clear();
        System.gc();
        TarFiles.CleanupResult cleanupResult = context.getTarFiles().cleanup(DefaultCleanupStrategy.newCleanupContext(context));
        if (cleanupResult.isInterrupted()) {
            context.getGCListener().info("cleanup interrupted", new Object[0]);
        }
        context.getSegmentTracker().clearSegmentIdTables(cleanupResult.getReclaimedSegmentIds(), context.getSegmentEvictionReason());
        context.getGCListener().info("cleanup marking files for deletion: {}", new Object[]{DefaultCleanupStrategy.toFileNames(cleanupResult.getRemovableFiles())});
        long finalSize = context.getTarFiles().size();
        long reclaimedSize = cleanupResult.getReclaimedSize();
        context.getFileStoreStats().reclaimed(reclaimedSize);
        GCJournal gcJournal = context.getGCJournal();
        if (gcJournal != null) {
            gcJournal.persist(reclaimedSize, finalSize, DefaultCleanupStrategy.getGcGeneration(context), context.getCompactionMonitor().getCompactedNodes(), context.getCompactedRootId());
        } else {
            context.getGCListener().warn("gc journal not available, unable to persist new entry.", new Object[0]);
        }
        context.getGCListener().cleaned(reclaimedSize, finalSize);
        context.getGCListener().info("cleanup completed in {}. Post cleanup size is {} and space reclaimed {}.", new Object[]{watch, PrintableBytes.newPrintableBytes(finalSize), PrintableBytes.newPrintableBytes(reclaimedSize)});
        return cleanupResult.getRemovableFiles();
    }

    private static CleanupContext newCleanupContext(CleanupStrategy.Context context) {
        return new DefaultCleanupContext(context.getSegmentTracker(), context.getReclaimer(), context.getCompactedRootId());
    }

    private static String toFileNames(@NotNull List<String> files) {
        if (files.isEmpty()) {
            return "none";
        }
        return String.join((CharSequence)",", files);
    }

    private static GCGeneration getGcGeneration(CleanupStrategy.Context context) {
        return context.getRevisions().getHead().getSegmentId().getGcGeneration();
    }
}

