/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import java.io.IOException;
import java.util.List;
import org.apache.jackrabbit.guava.common.base.Joiner;
import org.apache.jackrabbit.oak.segment.compaction.SegmentGCStatus;
import org.apache.jackrabbit.oak.segment.file.CompactionResult;
import org.apache.jackrabbit.oak.segment.file.CompactionStrategy;
import org.apache.jackrabbit.oak.segment.file.DefaultCleanupContext;
import org.apache.jackrabbit.oak.segment.file.GarbageCollectionStrategy;
import org.apache.jackrabbit.oak.segment.file.PrintableBytes;
import org.apache.jackrabbit.oak.segment.file.PrintableStopwatch;
import org.apache.jackrabbit.oak.segment.file.tar.CleanupContext;
import org.apache.jackrabbit.oak.segment.file.tar.GCGeneration;
import org.apache.jackrabbit.oak.segment.file.tar.TarFiles;
import org.jetbrains.annotations.NotNull;

class CleanupFirstCompactionStrategy
implements CompactionStrategy {
    private final GarbageCollectionStrategy.Context parentContext;
    private final CompactionStrategy strategy;

    CleanupFirstCompactionStrategy(GarbageCollectionStrategy.Context parentContext, CompactionStrategy strategy) {
        this.parentContext = parentContext;
        this.strategy = strategy;
    }

    @Override
    public CompactionResult compact(CompactionStrategy.Context context) throws IOException {
        PrintableStopwatch watch = PrintableStopwatch.createStarted();
        context.getGCListener().info("pre-compaction cleanup started", new Object[0]);
        context.getGCListener().updateStatus(SegmentGCStatus.CLEANUP.message());
        System.gc();
        TarFiles.CleanupResult cleanupResult = context.getTarFiles().cleanup(CleanupFirstCompactionStrategy.newCleanupContext(context));
        if (cleanupResult.isInterrupted()) {
            context.getGCListener().info("cleanup interrupted", new Object[0]);
        }
        context.getSegmentTracker().clearSegmentIdTables(cleanupResult.getReclaimedSegmentIds(), "[pre-compaction cleanup]");
        context.getGCListener().info("cleanup marking files for deletion: {}", new Object[]{CleanupFirstCompactionStrategy.toFileNames(cleanupResult.getRemovableFiles())});
        long finalSize = context.getTarFiles().size();
        long reclaimedSize = cleanupResult.getReclaimedSize();
        this.parentContext.getFileStoreStats().reclaimed(reclaimedSize);
        context.getGCListener().cleaned(reclaimedSize, finalSize);
        context.getGCListener().info("pre-compaction cleanup completed in {}. Post cleanup size is {} and space reclaimed {}.", new Object[]{watch, PrintableBytes.newPrintableBytes(finalSize), PrintableBytes.newPrintableBytes(reclaimedSize)});
        this.parentContext.getFileReaper().add(cleanupResult.getRemovableFiles());
        return this.strategy.compact(context);
    }

    private static CleanupContext newCleanupContext(CompactionStrategy.Context context) {
        GCGeneration currentGeneration = context.getRevisions().getHead().getSegmentId().getGcGeneration();
        String compactedRoot = context.getGCJournal().read().getRoot();
        switch (context.getGCOptions().getGCType()) {
            case FULL: {
                return new DefaultCleanupContext(context.getSegmentTracker(), generation -> {
                    if (generation == null) {
                        return false;
                    }
                    if (generation.getFullGeneration() < currentGeneration.getFullGeneration()) {
                        return true;
                    }
                    return generation.getGeneration() < currentGeneration.getGeneration() && !generation.isCompacted();
                }, compactedRoot);
            }
            case TAIL: {
                return new DefaultCleanupContext(context.getSegmentTracker(), generation -> {
                    if (generation == null) {
                        return false;
                    }
                    if (generation.getFullGeneration() < currentGeneration.getFullGeneration() - 1) {
                        return true;
                    }
                    if (generation.getFullGeneration() == currentGeneration.getFullGeneration() - 1) {
                        return !generation.isCompacted();
                    }
                    return generation.getGeneration() < currentGeneration.getGeneration() && !generation.isCompacted();
                }, compactedRoot);
            }
        }
        throw new IllegalArgumentException("invalid garbage collection type");
    }

    private static String toFileNames(@NotNull List<String> files) {
        if (files.isEmpty()) {
            return "none";
        }
        return Joiner.on((String)",").join(files);
    }
}

