/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.jackrabbit.guava.common.base.Function;
import org.apache.jackrabbit.oak.segment.CheckpointCompactor;
import org.apache.jackrabbit.oak.segment.ClassicCompactor;
import org.apache.jackrabbit.oak.segment.Compactor;
import org.apache.jackrabbit.oak.segment.ParallelCompactor;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.segment.compaction.SegmentGCOptions;
import org.apache.jackrabbit.oak.segment.compaction.SegmentGCStatus;
import org.apache.jackrabbit.oak.segment.file.CompactedNodeState;
import org.apache.jackrabbit.oak.segment.file.CompactionResult;
import org.apache.jackrabbit.oak.segment.file.CompactionStrategy;
import org.apache.jackrabbit.oak.segment.file.CompactionWriter;
import org.apache.jackrabbit.oak.segment.file.Flusher;
import org.apache.jackrabbit.oak.segment.file.GCIncrement;
import org.apache.jackrabbit.oak.segment.file.GCJournal;
import org.apache.jackrabbit.oak.segment.file.PrintableStopwatch;
import org.apache.jackrabbit.oak.segment.file.TarRevisions;
import org.apache.jackrabbit.oak.segment.file.cancel.Cancellation;
import org.apache.jackrabbit.oak.segment.file.cancel.Canceller;
import org.apache.jackrabbit.oak.segment.file.tar.GCGeneration;
import org.apache.jackrabbit.oak.spi.state.NodeState;

abstract class AbstractCompactionStrategy
implements CompactionStrategy {
    AbstractCompactionStrategy() {
    }

    abstract SegmentGCOptions.GCType getCompactionType();

    abstract GCGeneration partialGeneration(GCGeneration var1);

    abstract GCGeneration targetGeneration(GCGeneration var1);

    private CompactionResult compactionSucceeded(CompactionStrategy.Context context, GCGeneration generation, RecordId compactedRootId) {
        context.getGCListener().compactionSucceeded(generation);
        return CompactionResult.succeeded(this.getCompactionType(), generation, context.getGCOptions(), compactedRootId, context.getGCCount());
    }

    private CompactionResult compactionPartiallySucceeded(CompactionStrategy.Context context, GCGeneration generation, RecordId compactedRootId) {
        context.getGCListener().compactionSucceeded(generation);
        return CompactionResult.partiallySucceeded(generation, compactedRootId, context.getGCCount());
    }

    private static CompactionResult compactionAborted(CompactionStrategy.Context context, GCGeneration generation) {
        context.getGCListener().compactionFailed(generation);
        return CompactionResult.aborted(AbstractCompactionStrategy.getGcGeneration(context), context.getGCCount());
    }

    private static GCGeneration getGcGeneration(CompactionStrategy.Context context) {
        return context.getRevisions().getHead().getSegmentId().getGcGeneration();
    }

    private static SegmentNodeState getHead(CompactionStrategy.Context context) {
        return context.getSegmentReader().readHeadState(context.getRevisions());
    }

    private static long size(CompactionStrategy.Context context) {
        return context.getTarFiles().size();
    }

    private static CompactedNodeState forceCompact(CompactionStrategy.Context context, NodeState base, NodeState onto, Compactor compactor, Canceller canceller) throws InterruptedException {
        AtomicReference compacted = new AtomicReference();
        context.getRevisions().setHead((Function<RecordId, RecordId>)((Function)headId -> {
            try {
                PrintableStopwatch t = PrintableStopwatch.createStarted();
                SegmentNodeState currentHead = context.getSegmentReader().readNode((RecordId)headId);
                CompactedNodeState after = compactor.compact(base, currentHead, onto, canceller);
                if (after != null) {
                    compacted.set(after);
                    return after.getRecordId();
                }
                context.getGCListener().info("compaction cancelled after {}", new Object[]{t});
                return null;
            }
            catch (IOException e) {
                context.getGCListener().error("error during forced compaction.", e);
                return null;
            }
        }), TarRevisions.timeout(context.getGCOptions().getForceTimeout(), TimeUnit.SECONDS));
        return (CompactedNodeState)compacted.get();
    }

    private static String formatCompactionType(SegmentGCOptions.GCType compactionType) {
        switch (compactionType) {
            case FULL: {
                return "full";
            }
            case TAIL: {
                return "tail";
            }
        }
        throw new IllegalStateException("unsupported compaction type: " + compactionType);
    }

    private boolean setHead(CompactionStrategy.Context context, SegmentNodeState previous, SegmentNodeState head) {
        return context.getRevisions().setHead(previous.getRecordId(), head.getRecordId(), TarRevisions.EXPEDITE_OPTION);
    }

    final CompactionResult compact(CompactionStrategy.Context context, NodeState base) {
        context.getGCListener().info("running {} compaction", new Object[]{AbstractCompactionStrategy.formatCompactionType(this.getCompactionType())});
        GCGeneration baseGeneration = AbstractCompactionStrategy.getGcGeneration(context);
        GCGeneration partialGeneration = this.partialGeneration(baseGeneration);
        GCGeneration targetGeneration = this.targetGeneration(baseGeneration);
        GCIncrement gcIncrement = new GCIncrement(baseGeneration, partialGeneration, targetGeneration);
        try {
            int cycles;
            SegmentNodeState head;
            boolean success;
            PrintableStopwatch watch = PrintableStopwatch.createStarted();
            context.getGCListener().info("compaction started, gc options={},\n{}", new Object[]{context.getGCOptions(), gcIncrement});
            context.getGCListener().updateStatus(SegmentGCStatus.COMPACTION.message());
            GCJournal.GCJournalEntry gcEntry = context.getGCJournal().read();
            long initialSize = AbstractCompactionStrategy.size(context);
            CompactionWriter writer = new CompactionWriter(context.getSegmentReader(), context.getBlobStore(), gcIncrement, context.getSegmentWriterFactory());
            context.getCompactionMonitor().init(gcEntry.getRepoSize(), gcEntry.getNodes(), initialSize);
            Canceller hardCanceller = context.getHardCanceller().withShortCircuit();
            Canceller softCanceller = context.getSoftCanceller().withShortCircuit();
            Compactor compactor = this.newCompactor(context, writer);
            CompactedNodeState compacted = null;
            int retryCount = Math.max(0, context.getGCOptions().getRetryCount());
            Flusher flusher = () -> {
                writer.flush();
                context.getFlusher().flush();
            };
            do {
                head = AbstractCompactionStrategy.getHead(context);
                SegmentNodeState after = compacted == null ? head : compacted;
                Canceller stateSaveTrigger = context.getStateSaveTriggerSupplier().get().withShortCircuit();
                if (stateSaveTrigger.isCancelable()) {
                    context.getGCListener().info("intermediate state save enabled.", new Object[0]);
                    Canceller saveStateCanceller = softCanceller.withCondition("save intermediate compaction state", () -> stateSaveTrigger.check().isCancelled());
                    compacted = compactor.compactDown(base, after, hardCanceller, saveStateCanceller);
                } else if (softCanceller.isCancelable()) {
                    context.getGCListener().info("soft cancellation enabled.", new Object[0]);
                    compacted = compactor.compactDown(base, after, hardCanceller, softCanceller);
                } else {
                    compacted = compactor.compactUp(base, after, hardCanceller);
                }
                if (compacted == null) {
                    context.getGCListener().warn("compaction cancelled: {}.", new Object[]{hardCanceller.check().getReason().orElse("unknown reason")});
                    return AbstractCompactionStrategy.compactionAborted(context, targetGeneration);
                }
                context.getGCListener().info("compaction cycle 0 completed in {}. Compacted {} to {}", new Object[]{watch, head.getRecordId(), compacted.getRecordId()});
                cycles = 0;
                while (!(success = this.setHead(context, head, compacted)) && cycles < retryCount) {
                    context.getGCListener().info("compaction detected concurrent commits while compacting. Compacting these commits. Cycle {} of {}", new Object[]{++cycles, retryCount});
                    context.getGCListener().updateStatus(SegmentGCStatus.COMPACTION_RETRY.message() + cycles);
                    PrintableStopwatch cycleWatch = PrintableStopwatch.createStarted();
                    SegmentNodeState newHead = AbstractCompactionStrategy.getHead(context);
                    compacted = compactor.compact(head, newHead, compacted, hardCanceller);
                    if (compacted == null) {
                        context.getGCListener().warn("compaction cancelled: {}.", new Object[]{hardCanceller.check().getReason().orElse("unknown reason")});
                        return AbstractCompactionStrategy.compactionAborted(context, targetGeneration);
                    }
                    context.getGCListener().info("compaction cycle {} completed in {}. Compacted {} against {} to {}", new Object[]{cycles, cycleWatch, head.getRecordId(), newHead.getRecordId(), compacted.getRecordId()});
                    head = newHead;
                }
                if (!success) continue;
                flusher.flush();
            } while (success && !compacted.isComplete() && !softCanceller.check().isCancelled());
            if (!success) {
                context.getGCListener().info("compaction gave up compacting concurrent commits after {} cycles.", new Object[]{cycles});
                int forceTimeout = context.getGCOptions().getForceTimeout();
                if (forceTimeout > 0) {
                    context.getGCListener().info("trying to force compact remaining commits for {} seconds. Concurrent commits to the store will be blocked.", new Object[]{forceTimeout});
                    context.getGCListener().updateStatus(SegmentGCStatus.COMPACTION_FORCE_COMPACT.message());
                    PrintableStopwatch forceWatch = PrintableStopwatch.createStarted();
                    ++cycles;
                    Canceller forcedCompactionCanceller = hardCanceller.withTimeout("forced compaction timeout exceeded", forceTimeout, TimeUnit.SECONDS).withShortCircuit();
                    compacted = AbstractCompactionStrategy.forceCompact(context, head, compacted, compactor, forcedCompactionCanceller);
                    if (compacted != null) {
                        success = true;
                        flusher.flush();
                        context.getGCListener().info("compaction succeeded to force compact remaining commits after {}.", new Object[]{forceWatch});
                    } else {
                        Cancellation cancellation = forcedCompactionCanceller.check();
                        if (cancellation.isCancelled()) {
                            context.getGCListener().warn("compaction failed to force compact remaining commits after {}. Compaction was cancelled: {}.", new Object[]{forceWatch, cancellation.getReason().orElse("unknown reason")});
                        } else {
                            context.getGCListener().warn("compaction failed to force compact remaining commits. after {}. Could not acquire exclusive access to the node store.", new Object[]{forceWatch});
                        }
                    }
                }
            }
            if (success) {
                context.getSuccessfulCompactionListener().onSuccessfulCompaction(this.getCompactionType());
                context.getCompactionMonitor().finished();
                if (compacted.isComplete()) {
                    context.getGCListener().info("compaction succeeded in {}, after {} cycles", new Object[]{watch, cycles});
                    return this.compactionSucceeded(context, targetGeneration, compacted.getRecordId());
                }
                context.getGCListener().info("compaction partially succeeded in {}: {}.", new Object[]{watch, softCanceller.check().getReason().orElse("unknown reason")});
                return this.compactionPartiallySucceeded(context, partialGeneration, compacted.getRecordId());
            }
            context.getGCListener().info("compaction failed after {}, and {} cycles", new Object[]{watch, cycles});
            return AbstractCompactionStrategy.compactionAborted(context, targetGeneration);
        }
        catch (InterruptedException e) {
            context.getGCListener().error("compaction interrupted", e);
            Thread.currentThread().interrupt();
            return AbstractCompactionStrategy.compactionAborted(context, targetGeneration);
        }
        catch (Throwable e) {
            context.getGCListener().error("compaction encountered an error", e instanceof Exception ? (Exception)e : new Exception(e));
            return AbstractCompactionStrategy.compactionAborted(context, targetGeneration);
        }
    }

    private Compactor newCompactor(CompactionStrategy.Context context, CompactionWriter writer) {
        SegmentGCOptions.CompactorType compactorType = context.getGCOptions().getCompactorType();
        switch (compactorType) {
            case PARALLEL_COMPACTOR: {
                return new ParallelCompactor(context.getGCListener(), writer, context.getCompactionMonitor(), context.getGCOptions().getConcurrency());
            }
            case CHECKPOINT_COMPACTOR: {
                return new CheckpointCompactor(context.getGCListener(), writer, context.getCompactionMonitor());
            }
            case CLASSIC_COMPACTOR: {
                return new ClassicCompactor(writer, context.getCompactionMonitor());
            }
        }
        throw new IllegalArgumentException("Unknown compactor type: " + compactorType);
    }
}

