/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.base.Supplier;
import org.apache.jackrabbit.oak.segment.DefaultSegmentWriter;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.SegmentBufferWriter;
import org.apache.jackrabbit.oak.segment.SegmentBufferWriterPool;
import org.apache.jackrabbit.oak.segment.SegmentIdProvider;
import org.apache.jackrabbit.oak.segment.SegmentReader;
import org.apache.jackrabbit.oak.segment.SegmentStore;
import org.apache.jackrabbit.oak.segment.WriteOperationHandler;
import org.apache.jackrabbit.oak.segment.WriterCacheManager;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.file.ReadOnlyFileStore;
import org.apache.jackrabbit.oak.segment.file.tar.GCGeneration;
import org.apache.jackrabbit.oak.segment.memory.MemoryStore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefaultSegmentWriterBuilder {
    @NotNull
    private final String name;
    @NotNull
    private Supplier<GCGeneration> generation = () -> GCGeneration.NULL;
    private SegmentBufferWriterPool.PoolType poolType = null;
    @NotNull
    private WriterCacheManager cacheManager = new WriterCacheManager.Default();

    private DefaultSegmentWriterBuilder(@NotNull String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
    }

    @NotNull
    public static DefaultSegmentWriterBuilder defaultSegmentWriterBuilder(@NotNull String name) {
        return new DefaultSegmentWriterBuilder(name);
    }

    @NotNull
    public DefaultSegmentWriterBuilder withGeneration(@NotNull Supplier<GCGeneration> generation) {
        this.generation = (Supplier)Preconditions.checkNotNull(generation);
        return this;
    }

    @NotNull
    public DefaultSegmentWriterBuilder withGeneration(@NotNull GCGeneration generation) {
        this.generation = () -> (GCGeneration)Preconditions.checkNotNull((Object)generation);
        return this;
    }

    @NotNull
    public DefaultSegmentWriterBuilder withWriterPool() {
        return this.withWriterPool(SegmentBufferWriterPool.PoolType.GLOBAL);
    }

    @NotNull
    public DefaultSegmentWriterBuilder withWriterPool(SegmentBufferWriterPool.PoolType writerType) {
        this.poolType = writerType;
        return this;
    }

    @NotNull
    public DefaultSegmentWriterBuilder withoutWriterPool() {
        this.poolType = null;
        return this;
    }

    @NotNull
    public DefaultSegmentWriterBuilder with(WriterCacheManager cacheManager) {
        this.cacheManager = (WriterCacheManager)Preconditions.checkNotNull((Object)cacheManager);
        return this;
    }

    @NotNull
    public DefaultSegmentWriterBuilder withoutCache() {
        this.cacheManager = WriterCacheManager.Empty.INSTANCE;
        return this;
    }

    @NotNull
    public DefaultSegmentWriter build(@NotNull FileStore store) {
        return new DefaultSegmentWriter((SegmentStore)Preconditions.checkNotNull((Object)store), store.getReader(), store.getSegmentIdProvider(), store.getBlobStore(), this.cacheManager, this.createWriter(store, this.poolType), store.getBinariesInlineThreshold());
    }

    @NotNull
    public DefaultSegmentWriter build(@NotNull ReadOnlyFileStore store) {
        return new DefaultSegmentWriter((SegmentStore)Preconditions.checkNotNull((Object)store), store.getReader(), store.getSegmentIdProvider(), store.getBlobStore(), this.cacheManager, new WriteOperationHandler(){

            @Override
            @NotNull
            public GCGeneration getGCGeneration() {
                throw new UnsupportedOperationException("Cannot write to read-only store");
            }

            @Override
            @NotNull
            public RecordId execute(@NotNull GCGeneration gcGeneration, @NotNull WriteOperationHandler.WriteOperation writeOperation) {
                throw new UnsupportedOperationException("Cannot write to read-only store");
            }

            @Override
            public void flush(@NotNull SegmentStore store) {
                throw new UnsupportedOperationException("Cannot write to read-only store");
            }
        }, store.getBinariesInlineThreshold());
    }

    @NotNull
    public DefaultSegmentWriter build(@NotNull MemoryStore store) {
        return new DefaultSegmentWriter((SegmentStore)Preconditions.checkNotNull((Object)store), store.getReader(), store.getSegmentIdProvider(), store.getBlobStore(), this.cacheManager, this.createWriter(store, this.poolType), 16512);
    }

    @NotNull
    private WriteOperationHandler createWriter(@NotNull FileStore store, @Nullable SegmentBufferWriterPool.PoolType poolType) {
        return this.createWriter(store.getSegmentIdProvider(), store.getReader(), poolType);
    }

    @NotNull
    private WriteOperationHandler createWriter(@NotNull MemoryStore store, @Nullable SegmentBufferWriterPool.PoolType poolType) {
        return this.createWriter(store.getSegmentIdProvider(), store.getReader(), poolType);
    }

    @NotNull
    private WriteOperationHandler createWriter(@NotNull SegmentIdProvider idProvider, @NotNull SegmentReader reader, @Nullable SegmentBufferWriterPool.PoolType poolType) {
        if (poolType == null) {
            return new SegmentBufferWriter(idProvider, reader, this.name, (GCGeneration)this.generation.get());
        }
        return SegmentBufferWriterPool.factory(idProvider, reader, this.name, this.generation).newPool(poolType);
    }
}

