/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import org.apache.jackrabbit.oak.segment.file.EstimationResult;
import org.apache.jackrabbit.oak.segment.file.EstimationStrategy;
import org.apache.jackrabbit.oak.segment.file.PrintableBytes;

class TailSizeDeltaEstimationStrategy
implements EstimationStrategy {
    TailSizeDeltaEstimationStrategy() {
    }

    @Override
    public EstimationResult estimate(EstimationStrategy.Context context) {
        if (context.getSizeDelta() == 0L) {
            return new EstimationResult(true, "Estimation skipped because the size delta value equals 0");
        }
        long previousSize = this.readPreviousSize(context);
        if (previousSize < 0L) {
            return new EstimationResult(true, "Estimation skipped because of missing gc journal data (expected on first run)");
        }
        long gain = context.getCurrentSize() - previousSize;
        boolean gcNeeded = gain > context.getSizeDelta();
        String gcInfo = String.format("Segmentstore size has increased since the last tail garbage collection from %s to %s, an increase of %s or %s%%. ", PrintableBytes.newPrintableBytes(previousSize), PrintableBytes.newPrintableBytes(context.getCurrentSize()), PrintableBytes.newPrintableBytes(gain), 100L * gain / previousSize);
        gcInfo = gcNeeded ? gcInfo + String.format("This is greater than sizeDeltaEstimation=%s, so running garbage collection", PrintableBytes.newPrintableBytes(context.getSizeDelta())) : gcInfo + String.format("This is less than sizeDeltaEstimation=%s, so skipping garbage collection", PrintableBytes.newPrintableBytes(context.getSizeDelta()));
        return new EstimationResult(gcNeeded, gcInfo);
    }

    private long readPreviousSize(EstimationStrategy.Context context) {
        return context.getGCJournal().read().getRepoSize();
    }
}

