/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.tool;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.escape.Escapers;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.SegmentBlob;
import org.apache.jackrabbit.oak.segment.SegmentId;
import org.apache.jackrabbit.oak.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.segment.SegmentNodeStateHelper;
import org.apache.jackrabbit.oak.segment.SegmentPropertyState;
import org.apache.jackrabbit.oak.segment.file.ReadOnlyFileStore;
import org.apache.jackrabbit.oak.segment.tool.Utils;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class DebugTars {
    private final File path;
    private final List<String> tars;
    private final int maxCharDisplay;

    public static Builder builder() {
        return new Builder();
    }

    private DebugTars(Builder builder) {
        this.path = builder.path;
        this.tars = new ArrayList<String>(builder.tars);
        this.maxCharDisplay = builder.maxCharDisplay;
    }

    public int run() {
        ReadOnlyFileStore store = Utils.openReadOnlyFileStore(this.path);
        try {
            this.debugTarFiles(store);
            int n = 0;
            if (store != null) {
                store.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (store != null) {
                    try {
                        store.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                return 1;
            }
        }
    }

    private void debugTarFiles(ReadOnlyFileStore store) {
        for (String tar : this.tars) {
            this.debugTarFile(store, tar);
        }
    }

    private void debugTarFile(ReadOnlyFileStore store, String t) {
        File tar = new File(this.path, t);
        if (!tar.exists()) {
            System.out.println("file doesn't exist, skipping " + t);
            return;
        }
        System.out.println("Debug file " + tar + "(" + tar.length() + ")");
        HashSet<UUID> uuids = new HashSet();
        boolean hasRefs = false;
        for (Map.Entry<String, Set<UUID>> e : store.getTarReaderIndex().entrySet()) {
            if (!e.getKey().endsWith(t)) continue;
            hasRefs = true;
            uuids = e.getValue();
        }
        if (hasRefs) {
            System.out.println("SegmentNodeState references to " + t);
            ArrayList<String> paths = new ArrayList<String>();
            this.filterNodeStates(uuids, paths, store.getHead(), "/");
            for (String string : paths) {
                System.out.println("  " + string);
            }
        } else {
            System.out.println("No references to " + t);
        }
        try {
            Map<UUID, Set<UUID>> graph = store.getTarGraph(t);
            System.out.println();
            System.out.println("Tar graph:");
            for (Map.Entry entry : graph.entrySet()) {
                System.out.println("" + entry.getKey() + '=' + entry.getValue());
            }
        }
        catch (IOException e) {
            System.err.println("Error getting tar graph:");
            e.printStackTrace(System.err);
        }
    }

    private void filterNodeStates(Set<UUID> uuids, List<String> paths, SegmentNodeState state, String path) {
        RecordId templateId;
        TreeSet localPaths = Sets.newTreeSet();
        for (PropertyState ps : state.getProperties()) {
            if (!(ps instanceof SegmentPropertyState)) continue;
            SegmentPropertyState sps = (SegmentPropertyState)ps;
            RecordId recordId = sps.getRecordId();
            UUID id = recordId.getSegmentId().asUUID();
            if (uuids.contains(id)) {
                if (ps.getType().tag() == 1) {
                    String val = "";
                    if (ps.count() > 0) {
                        val = this.displayString((String)ps.getValue(Type.STRING, 0));
                    }
                    localPaths.add(DebugTars.getLocalPath(path, ps, val, recordId));
                } else {
                    localPaths.add(DebugTars.getLocalPath(path, ps, recordId));
                }
            }
            if (ps.getType().tag() != 2) continue;
            for (int i = 0; i < ps.count(); ++i) {
                Blob b = (Blob)ps.getValue(Type.BINARY, i);
                for (SegmentId sbid : SegmentBlob.getBulkSegmentIds(b)) {
                    UUID bid = sbid.asUUID();
                    if (bid.equals(id) || !uuids.contains(bid)) continue;
                    localPaths.add(DebugTars.getLocalPath(path, ps, recordId));
                }
            }
        }
        RecordId stateId = state.getRecordId();
        if (uuids.contains(stateId.getSegmentId().asUUID())) {
            localPaths.add(path + " [SegmentNodeState@" + stateId + "]");
        }
        if (uuids.contains((templateId = SegmentNodeStateHelper.getTemplateId(state)).getSegmentId().asUUID())) {
            localPaths.add(path + "[Template@" + templateId + "]");
        }
        paths.addAll(localPaths);
        for (ChildNodeEntry childNodeEntry : state.getChildNodeEntries()) {
            NodeState c = childNodeEntry.getNodeState();
            if (!(c instanceof SegmentNodeState)) continue;
            this.filterNodeStates(uuids, paths, (SegmentNodeState)c, path + childNodeEntry.getName() + "/");
        }
    }

    private static String getLocalPath(String path, PropertyState ps, String value, RecordId id) {
        return path + ps.getName() + " = " + value + " [SegmentPropertyState<" + ps.getType() + ">@" + id + "]";
    }

    private static String getLocalPath(String path, PropertyState ps, RecordId id) {
        return path + ps + " [SegmentPropertyState<" + ps.getType() + ">@" + id + "]";
    }

    private String displayString(String value) {
        if (this.maxCharDisplay > 0 && value.length() > this.maxCharDisplay) {
            value = value.substring(0, this.maxCharDisplay) + "... (" + value.length() + " chars)";
        }
        String escaped = Escapers.builder().setSafeRange(' ', '~').addEscape('\"', "\\\"").addEscape('\\', "\\\\").build().escape(value);
        return '\"' + escaped + '\"';
    }

    public static class Builder {
        private File path;
        private final List<String> tars = new ArrayList<String>();
        private final int maxCharDisplay = Integer.getInteger("max.char.display", 60);

        private Builder() {
        }

        public Builder withPath(File path) {
            this.path = (File)Preconditions.checkNotNull((Object)path);
            return this;
        }

        public Builder withTar(String tar) {
            Preconditions.checkArgument((boolean)tar.endsWith(".tar"));
            this.tars.add(tar);
            return this;
        }

        public DebugTars build() {
            Preconditions.checkNotNull((Object)this.path);
            Preconditions.checkArgument((!this.tars.isEmpty() ? 1 : 0) != 0);
            return new DebugTars(this);
        }
    }
}

