/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.spi.monitor;

import org.apache.jackrabbit.api.stats.RepositoryStatistics;
import org.apache.jackrabbit.api.stats.TimeSeries;
import org.apache.jackrabbit.oak.stats.CounterStats;
import org.apache.jackrabbit.oak.stats.HistogramStats;
import org.apache.jackrabbit.oak.stats.MeterStats;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.apache.jackrabbit.oak.stats.TimerStats;

public class RoleStatisticsProvider
implements StatisticsProvider {
    private final StatisticsProvider delegate;
    private final String role;
    private final RepositoryStatistics repositoryStatistics;

    public RoleStatisticsProvider(final StatisticsProvider delegate, final String role) {
        this.delegate = delegate;
        this.role = role;
        this.repositoryStatistics = new RepositoryStatistics(){

            public TimeSeries getTimeSeries(RepositoryStatistics.Type type) {
                return this.getTimeSeries(type.name(), type.isResetValueEachSecond());
            }

            public TimeSeries getTimeSeries(String type, boolean resetValueEachSecond) {
                return delegate.getStats().getTimeSeries(RoleStatisticsProvider.addRoleToName(type, role), resetValueEachSecond);
            }
        };
    }

    public RepositoryStatistics getStats() {
        return this.repositoryStatistics;
    }

    public MeterStats getMeter(String name, StatsOptions options) {
        return this.delegate.getMeter(RoleStatisticsProvider.addRoleToName(name, this.role), options);
    }

    public CounterStats getCounterStats(String name, StatsOptions options) {
        return this.delegate.getCounterStats(RoleStatisticsProvider.addRoleToName(name, this.role), options);
    }

    public TimerStats getTimer(String name, StatsOptions options) {
        return this.delegate.getTimer(RoleStatisticsProvider.addRoleToName(name, this.role), options);
    }

    public HistogramStats getHistogram(String name, StatsOptions options) {
        return this.delegate.getHistogram(RoleStatisticsProvider.addRoleToName(name, this.role), options);
    }

    private static String addRoleToName(String name, String role) {
        return role + '.' + name;
    }
}

