/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.scheduler;

import com.google.common.base.Preconditions;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.segment.SegmentNodeBuilder;
import org.apache.jackrabbit.oak.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.segment.file.tar.GCGeneration;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.state.ConflictAnnotatingRebaseDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Commit {
    static final String ROOT = "root";
    private final SegmentNodeBuilder changes;
    private final CommitHook hook;
    private final CommitInfo info;
    private volatile GCGeneration gcGeneration;

    public Commit(@NotNull NodeBuilder changes, @NotNull CommitHook hook, @NotNull CommitInfo info) {
        Preconditions.checkNotNull((Object)changes);
        Preconditions.checkArgument((boolean)(changes instanceof SegmentNodeBuilder));
        this.changes = (SegmentNodeBuilder)changes;
        this.hook = (CommitHook)Preconditions.checkNotNull((Object)hook);
        this.info = (CommitInfo)Preconditions.checkNotNull((Object)info);
    }

    @Nullable
    public GCGeneration getGCGeneration() {
        return this.gcGeneration;
    }

    @NotNull
    private NodeState getBeforeState() {
        return this.changes.getBaseState();
    }

    @NotNull
    private SegmentNodeState getAfterState() {
        SegmentNodeState after = this.changes.getNodeState();
        this.gcGeneration = after.getGcGeneration();
        return after;
    }

    public SegmentNodeState apply(SegmentNodeState base) throws CommitFailedException {
        SegmentNodeBuilder builder = base.builder();
        if (SegmentNodeState.fastEquals(this.getBeforeState(), base.getChildNode(ROOT))) {
            NodeState before = this.getBeforeState();
            SegmentNodeState after = this.getAfterState();
            builder.setChildNode(ROOT, this.hook.processCommit(before, (NodeState)after, this.info));
        } else {
            ConflictAnnotatingRebaseDiff diff = new ConflictAnnotatingRebaseDiff(builder.child(ROOT));
            this.getAfterState().compareAgainstBaseState(this.getBeforeState(), (NodeStateDiff)diff);
            builder.setChildNode(ROOT, this.hook.processCommit(builder.getBaseState().getChildNode(ROOT), builder.getNodeState().getChildNode(ROOT), this.info));
        }
        return builder.getNodeState();
    }

    public void applied(SegmentNodeState merged) {
        this.changes.reset(merged);
    }

    public boolean hasChanges() {
        return !SegmentNodeState.fastEquals(this.getBeforeState(), this.getAfterState());
    }

    public CommitInfo info() {
        return this.info;
    }
}

