/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.compression.SnappyFrameDecoder;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.CharsetUtil;
import java.io.File;
import java.io.InputStream;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.segment.standby.client.ExceptionHandler;
import org.apache.jackrabbit.oak.segment.standby.client.GetBlobResponseHandler;
import org.apache.jackrabbit.oak.segment.standby.client.GetHeadResponseHandler;
import org.apache.jackrabbit.oak.segment.standby.client.GetReferencesResponseHandler;
import org.apache.jackrabbit.oak.segment.standby.client.GetSegmentResponseHandler;
import org.apache.jackrabbit.oak.segment.standby.codec.GetBlobRequest;
import org.apache.jackrabbit.oak.segment.standby.codec.GetBlobRequestEncoder;
import org.apache.jackrabbit.oak.segment.standby.codec.GetBlobResponse;
import org.apache.jackrabbit.oak.segment.standby.codec.GetHeadRequest;
import org.apache.jackrabbit.oak.segment.standby.codec.GetHeadRequestEncoder;
import org.apache.jackrabbit.oak.segment.standby.codec.GetHeadResponse;
import org.apache.jackrabbit.oak.segment.standby.codec.GetReferencesRequest;
import org.apache.jackrabbit.oak.segment.standby.codec.GetReferencesRequestEncoder;
import org.apache.jackrabbit.oak.segment.standby.codec.GetReferencesResponse;
import org.apache.jackrabbit.oak.segment.standby.codec.GetSegmentRequest;
import org.apache.jackrabbit.oak.segment.standby.codec.GetSegmentRequestEncoder;
import org.apache.jackrabbit.oak.segment.standby.codec.GetSegmentResponse;
import org.apache.jackrabbit.oak.segment.standby.codec.ResponseDecoder;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StandbyClient
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(StandbyClient.class);
    private final BlockingQueue<GetHeadResponse> headQueue = new LinkedBlockingDeque<GetHeadResponse>();
    private final BlockingQueue<GetSegmentResponse> segmentQueue = new LinkedBlockingDeque<GetSegmentResponse>();
    private final BlockingQueue<GetBlobResponse> blobQueue = new LinkedBlockingDeque<GetBlobResponse>();
    private final BlockingQueue<GetReferencesResponse> referencesQueue = new LinkedBlockingDeque<GetReferencesResponse>();
    private final int readTimeoutMs;
    private final String clientId;
    private Channel channel;

    StandbyClient(String host, int port, NioEventLoopGroup group, final String clientId, final boolean secure, final int readTimeoutMs, final File spoolFolder) throws InterruptedException {
        this.clientId = clientId;
        this.readTimeoutMs = readTimeoutMs;
        Bootstrap b = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)group)).channel(NioSocketChannel.class)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)readTimeoutMs)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                if (secure) {
                    p.addLast(new ChannelHandler[]{SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build().newHandler(ch.alloc())});
                }
                p.addLast(new ChannelHandler[]{new ReadTimeoutHandler((long)readTimeoutMs, TimeUnit.MILLISECONDS)});
                p.addLast(new ChannelHandler[]{new SnappyFrameDecoder(true)});
                p.addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4)});
                p.addLast(new ChannelHandler[]{new ResponseDecoder(spoolFolder)});
                p.addLast(new ChannelHandler[]{new StringEncoder(CharsetUtil.UTF_8)});
                p.addLast(new ChannelHandler[]{new GetHeadRequestEncoder()});
                p.addLast(new ChannelHandler[]{new GetSegmentRequestEncoder()});
                p.addLast(new ChannelHandler[]{new GetBlobRequestEncoder()});
                p.addLast(new ChannelHandler[]{new GetReferencesRequestEncoder()});
                p.addLast(new ChannelHandler[]{new GetHeadResponseHandler(StandbyClient.this.headQueue)});
                p.addLast(new ChannelHandler[]{new GetSegmentResponseHandler(StandbyClient.this.segmentQueue)});
                p.addLast(new ChannelHandler[]{new GetBlobResponseHandler(StandbyClient.this.blobQueue)});
                p.addLast(new ChannelHandler[]{new GetReferencesResponseHandler(StandbyClient.this.referencesQueue)});
                p.addLast(new ChannelHandler[]{new ExceptionHandler(clientId)});
            }
        });
        this.channel = b.connect(host, port).sync().channel();
    }

    @Override
    public void close() {
        if (this.channel == null) {
            return;
        }
        if (this.channel.close().awaitUninterruptibly(1L, TimeUnit.SECONDS)) {
            log.debug("Channel closed");
        } else {
            log.debug("Channel close timed out");
        }
    }

    @Nullable
    String getHead() throws InterruptedException {
        this.channel.writeAndFlush((Object)new GetHeadRequest(this.clientId));
        GetHeadResponse response = this.headQueue.poll(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        if (response == null) {
            return null;
        }
        return response.getHeadRecordId();
    }

    @Nullable
    byte[] getSegment(String segmentId) throws InterruptedException {
        this.channel.writeAndFlush((Object)new GetSegmentRequest(this.clientId, segmentId));
        GetSegmentResponse response = this.segmentQueue.poll(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        if (response == null) {
            return null;
        }
        return response.getSegmentData();
    }

    @Nullable
    InputStream getBlob(String blobId) throws InterruptedException {
        this.channel.writeAndFlush((Object)new GetBlobRequest(this.clientId, blobId));
        GetBlobResponse response = this.blobQueue.poll(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        if (response == null) {
            return null;
        }
        return response.getInputStream();
    }

    @Nullable
    Iterable<String> getReferences(String segmentId) throws InterruptedException {
        this.channel.writeAndFlush((Object)new GetReferencesRequest(this.clientId, segmentId));
        GetReferencesResponse response = this.referencesQueue.poll(this.readTimeoutMs, TimeUnit.MILLISECONDS);
        if (response == null) {
            return null;
        }
        return response.getReferences();
    }

    public int getReadTimeoutMs() {
        return this.readTimeoutMs;
    }
}

