/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.tool;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.segment.compaction.SegmentGCOptions;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.file.FileStoreBuilder;
import org.apache.jackrabbit.oak.segment.file.InvalidFileStoreVersionException;
import org.apache.jackrabbit.oak.segment.file.JournalEntry;
import org.apache.jackrabbit.oak.segment.file.JournalReader;
import org.apache.jackrabbit.oak.segment.file.tar.LocalJournalFile;
import org.apache.jackrabbit.oak.segment.spi.persistence.JournalFileWriter;
import org.jetbrains.annotations.Nullable;

public class Compact {
    private final File path;
    private final File journal;
    private final FileAccessMode fileAccessMode;
    private final int segmentCacheSize;
    private final boolean strictVersionCheck;
    private final long gcLogInterval;

    public static Builder builder() {
        return new Builder();
    }

    private static FileAccessMode newFileAccessMode(Boolean arg, String os) {
        if (os != null && os.toLowerCase().contains("windows")) {
            return FileAccessMode.REGULAR_ENFORCED;
        }
        if (arg == null) {
            return FileAccessMode.ARCH_DEPENDENT;
        }
        if (arg.booleanValue()) {
            return FileAccessMode.MEMORY_MAPPED;
        }
        return FileAccessMode.REGULAR;
    }

    private static Set<File> listFiles(File directory) {
        Object[] files = directory.listFiles();
        if (files == null) {
            return Collections.emptySet();
        }
        return Sets.newHashSet((Object[])files);
    }

    private static void printFiles(PrintStream s, Set<File> files) {
        for (File f : files) {
            s.printf("        %s, %s\n", Compact.getLastModified(f), f.getName());
        }
    }

    private static String getLastModified(File f) {
        return new Date(f.lastModified()).toString();
    }

    private static Set<String> fileNames(Set<File> files) {
        HashSet names = Sets.newHashSet();
        for (File f : files) {
            names.add(f.getName());
        }
        return names;
    }

    private static String printableSize(long size) {
        return String.format("%s (%d bytes)", IOUtils.humanReadableByteCount((long)size), size);
    }

    private static String printableStopwatch(Stopwatch s) {
        return String.format("%s (%ds)", s, s.elapsed(TimeUnit.SECONDS));
    }

    private Compact(Builder builder) {
        this.path = builder.path;
        this.journal = new File(builder.path, "journal.log");
        this.fileAccessMode = Compact.newFileAccessMode(builder.mmap, builder.os);
        this.segmentCacheSize = builder.segmentCacheSize;
        this.strictVersionCheck = !builder.force;
        this.gcLogInterval = builder.gcLogInterval;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int run() {
        System.out.printf("Compacting %s with %s\n", this.path, this.fileAccessMode.description);
        System.out.printf("    before\n", new Object[0]);
        Set<File> beforeFiles = Compact.listFiles(this.path);
        Compact.printFiles(System.out, beforeFiles);
        System.out.printf("    size %s\n", Compact.printableSize(FileUtils.sizeOfDirectory((File)this.path)));
        System.out.printf("    -> compacting\n", new Object[0]);
        Stopwatch watch = Stopwatch.createStarted();
        try (FileStore store = this.newFileStore();){
            String head;
            if (!store.compactFull()) {
                System.out.printf("Compaction cancelled after %s.\n", Compact.printableStopwatch(watch));
                int n = 1;
                return n;
            }
            System.out.printf("    -> cleaning up\n", new Object[0]);
            store.cleanup();
            LocalJournalFile journal = new LocalJournalFile(this.path, "journal.log");
            try (JournalReader journalReader = new JournalReader(journal);){
                head = String.format("%s root %s\n", ((JournalEntry)journalReader.next()).getRevision(), System.currentTimeMillis());
            }
            var8_13 = null;
            try (JournalFileWriter journalWriter = journal.openJournalWriter();){
                System.out.printf("    -> writing new %s: %s\n", journal.getName(), head);
                journalWriter.truncate();
                journalWriter.writeLine(head);
            }
            catch (Throwable throwable) {
                var8_13 = throwable;
                throw throwable;
            }
        }
        catch (Exception e) {
            watch.stop();
            e.printStackTrace(System.err);
            System.out.printf("Compaction failed after %s.\n", Compact.printableStopwatch(watch));
            return 1;
        }
        watch.stop();
        System.out.printf("    after\n", new Object[0]);
        Set<File> afterFiles = Compact.listFiles(this.path);
        Compact.printFiles(System.out, afterFiles);
        System.out.printf("    size %s\n", Compact.printableSize(FileUtils.sizeOfDirectory((File)this.path)));
        System.out.printf("    removed files %s\n", Compact.fileNames((Set<File>)Sets.difference(beforeFiles, afterFiles)));
        System.out.printf("    added files %s\n", Compact.fileNames((Set<File>)Sets.difference(afterFiles, beforeFiles)));
        System.out.printf("Compaction succeeded in %s.\n", Compact.printableStopwatch(watch));
        return 0;
    }

    private FileStore newFileStore() throws IOException, InvalidFileStoreVersionException {
        FileStoreBuilder builder = FileStoreBuilder.fileStoreBuilder(this.path.getAbsoluteFile()).withStrictVersionCheck(this.strictVersionCheck).withSegmentCacheSize(this.segmentCacheSize).withGCOptions(SegmentGCOptions.defaultGCOptions().setOffline().setGCLogInterval(this.gcLogInterval));
        if (this.fileAccessMode.memoryMapped != null) {
            builder.withMemoryMapping(this.fileAccessMode.memoryMapped);
        }
        return builder.build();
    }

    private static enum FileAccessMode {
        ARCH_DEPENDENT(null, "default access mode"),
        MEMORY_MAPPED(true, "memory mapped access mode"),
        REGULAR(false, "regular access mode"),
        REGULAR_ENFORCED(false, "enforced regular access mode");

        final Boolean memoryMapped;
        final String description;

        private FileAccessMode(Boolean memoryMapped, String description) {
            this.memoryMapped = memoryMapped;
            this.description = description;
        }
    }

    public static class Builder {
        private File path;
        private Boolean mmap;
        private String os;
        private boolean force;
        private long gcLogInterval = 150000L;
        private int segmentCacheSize = 256;

        private Builder() {
        }

        public Builder withPath(File path) {
            this.path = (File)Preconditions.checkNotNull((Object)path);
            return this;
        }

        public Builder withMmap(@Nullable Boolean mmap) {
            this.mmap = mmap;
            return this;
        }

        public Builder withOs(String os) {
            this.os = (String)Preconditions.checkNotNull((Object)os);
            return this;
        }

        public Builder withForce(boolean force) {
            this.force = force;
            return this;
        }

        public Builder withSegmentCacheSize(int segmentCacheSize) {
            Preconditions.checkArgument((segmentCacheSize > 0 ? 1 : 0) != 0, (Object)"segmentCacheSize must be strictly positive");
            this.segmentCacheSize = segmentCacheSize;
            return this;
        }

        public Builder withGCLogInterval(long gcLogInterval) {
            this.gcLogInterval = gcLogInterval;
            return this;
        }

        public Compact build() {
            Preconditions.checkNotNull((Object)this.path);
            return new Compact(this);
        }
    }
}

