/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file.tooling;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.json.BlobSerializer;
import org.apache.jackrabbit.oak.json.JsonSerializer;
import org.apache.jackrabbit.oak.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.segment.file.FileStoreBuilder;
import org.apache.jackrabbit.oak.segment.file.InvalidFileStoreVersionException;
import org.apache.jackrabbit.oak.segment.file.JournalEntry;
import org.apache.jackrabbit.oak.segment.file.JournalReader;
import org.apache.jackrabbit.oak.segment.file.ReadOnlyFileStore;
import org.apache.jackrabbit.oak.segment.spi.persistence.JournalFile;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RevisionHistory {
    private final ReadOnlyFileStore store;

    public RevisionHistory(@NotNull File directory) throws IOException, InvalidFileStoreVersionException {
        this.store = FileStoreBuilder.fileStoreBuilder((File)Preconditions.checkNotNull((Object)directory)).buildReadOnly();
    }

    private static NodeState getNode(SegmentNodeState root, String path) {
        SegmentNodeState node = root;
        for (String name : PathUtils.elements((String)path)) {
            node = node.getChildNode(name);
        }
        return node;
    }

    public Iterator<HistoryElement> getHistory(@NotNull JournalFile journal, final @NotNull String path) throws IOException {
        Preconditions.checkNotNull((Object)path);
        try (JournalReader journalReader = new JournalReader((JournalFile)Preconditions.checkNotNull((Object)journal));){
            Iterator iterator = Iterators.transform((Iterator)((Object)journalReader), (Function)new Function<JournalEntry, HistoryElement>(){

                @NotNull
                public HistoryElement apply(JournalEntry entry) {
                    RevisionHistory.this.store.setRevision(entry.getRevision());
                    NodeState node = RevisionHistory.getNode(RevisionHistory.this.store.getHead(), path);
                    return new HistoryElement(entry.getRevision(), node);
                }
            });
            return iterator;
        }
    }

    public static final class HistoryElement {
        private final String revision;
        private final NodeState node;

        HistoryElement(String revision, NodeState node) {
            this.revision = revision;
            this.node = node;
        }

        @NotNull
        public String getRevision() {
            return this.revision;
        }

        @Nullable
        public NodeState getNode() {
            return this.node;
        }

        public String toString(int depth) {
            JsonSerializer json = new JsonSerializer(depth, 0L, Integer.MAX_VALUE, "{\"properties\":[\"*\", \"-:childNodeCount\"]}", new BlobSerializer());
            json.serialize(this.node);
            return this.revision + "=" + json;
        }

        public String toString() {
            return this.toString(0);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            HistoryElement that = (HistoryElement)other;
            return this.revision.equals(that.revision) && (this.node == null ? that.node == null : this.node.equals(that.node));
        }

        public int hashCode() {
            return 31 * this.revision.hashCode() + (this.node != null ? this.node.hashCode() : 0);
        }
    }
}

