/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file.tar;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.zip.CRC32;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.segment.file.tar.GCGeneration;
import org.apache.jackrabbit.oak.segment.file.tar.binaries.BinaryReferencesIndexWriter;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveManager;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveWriter;
import org.apache.jackrabbit.oak.stats.CounterStats;
import org.apache.jackrabbit.oak.stats.NoopStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TarWriter
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(TarWriter.class);
    private final int writeIndex;
    private boolean closed = false;
    private final BinaryReferencesIndexWriter binaryReferences = BinaryReferencesIndexWriter.newBinaryReferencesIndexWriter();
    private final Map<UUID, Set<UUID>> graph = Maps.newHashMap();
    private final SegmentArchiveManager archiveManager;
    private final SegmentArchiveWriter archive;
    private final Object closeMonitor = new Object();
    private final CounterStats segmentCount;

    TarWriter(SegmentArchiveManager archiveManager, String archiveName) throws IOException {
        this.archiveManager = archiveManager;
        this.archive = archiveManager.create(archiveName);
        this.writeIndex = -1;
        this.segmentCount = NoopStats.INSTANCE;
    }

    TarWriter(SegmentArchiveManager archiveManager, int writeIndex, CounterStats segmentCountStats) throws IOException {
        this.archiveManager = archiveManager;
        this.archive = archiveManager.create(String.format("data%05d%s.tar", writeIndex, "a"));
        this.writeIndex = writeIndex;
        this.segmentCount = segmentCountStats;
    }

    synchronized boolean containsEntry(long msb, long lsb) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        return this.archive.containsSegment(msb, lsb);
    }

    int getEntryCount() {
        return this.archive.getEntryCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Buffer readEntry(long msb, long lsb) throws IOException {
        TarWriter tarWriter = this;
        synchronized (tarWriter) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        }
        return this.archive.readSegment(msb, lsb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long writeEntry(long msb, long lsb, byte[] data, int offset, int size, GCGeneration generation) throws IOException {
        Preconditions.checkNotNull((Object)data);
        Preconditions.checkPositionIndexes((int)offset, (int)(offset + size), (int)data.length);
        TarWriter tarWriter = this;
        synchronized (tarWriter) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0);
            this.archive.writeSegment(msb, lsb, data, offset, size, generation.getGeneration(), generation.getFullGeneration(), generation.isCompacted());
            this.segmentCount.inc();
            long currentLength = this.archive.getLength();
            Preconditions.checkState((currentLength <= Integer.MAX_VALUE ? 1 : 0) != 0);
            return currentLength;
        }
    }

    void addBinaryReference(GCGeneration generation, UUID segmentId, String reference) {
        this.binaryReferences.addEntry(generation.getGeneration(), generation.getFullGeneration(), generation.isCompacted(), segmentId, reference);
    }

    void addGraphEdge(UUID from, UUID to) {
        this.graph.computeIfAbsent(from, k -> Sets.newHashSet()).add(to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flush() throws IOException {
        Object object = this.closeMonitor;
        synchronized (object) {
            boolean doFlush;
            TarWriter tarWriter = this;
            synchronized (tarWriter) {
                doFlush = this.archive.isCreated() && !this.closed;
            }
            if (doFlush) {
                this.archive.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        if (!this.archive.isCreated()) {
            return;
        }
        object = this.closeMonitor;
        synchronized (object) {
            this.writeBinaryReferences();
            this.writeGraph();
            this.archive.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TarWriter createNextGeneration() throws IOException {
        Preconditions.checkState((this.writeIndex >= 0 ? 1 : 0) != 0);
        TarWriter tarWriter = this;
        synchronized (tarWriter) {
            if (!this.archive.isCreated()) {
                return this;
            }
        }
        this.close();
        int newIndex = this.writeIndex + 1;
        return new TarWriter(this.archiveManager, newIndex, this.segmentCount);
    }

    private void writeBinaryReferences() throws IOException {
        this.archive.writeBinaryReferences(this.binaryReferences.write());
    }

    private void writeGraph() throws IOException {
        int graphSize = 0;
        graphSize += 4;
        graphSize += 4;
        graphSize += 4;
        graphSize += 4;
        for (Map.Entry<UUID, Set<UUID>> entry : this.graph.entrySet()) {
            graphSize += 16;
            graphSize += 4;
            graphSize += 16 * entry.getValue().size();
        }
        Buffer buffer = Buffer.allocate((int)graphSize);
        for (Map.Entry<UUID, Set<UUID>> entry : this.graph.entrySet()) {
            UUID from = entry.getKey();
            buffer.putLong(from.getMostSignificantBits());
            buffer.putLong(from.getLeastSignificantBits());
            Set<UUID> adj = entry.getValue();
            buffer.putInt(adj.size());
            for (UUID to : adj) {
                buffer.putLong(to.getMostSignificantBits());
                buffer.putLong(to.getLeastSignificantBits());
            }
        }
        CRC32 cRC32 = new CRC32();
        cRC32.update(buffer.array(), 0, buffer.position());
        buffer.putInt((int)cRC32.getValue());
        buffer.putInt(this.graph.size());
        buffer.putInt(graphSize);
        buffer.putInt(170936074);
        this.archive.writeGraph(buffer.array());
    }

    synchronized long fileLength() {
        return this.archive.getLength();
    }

    synchronized String getFileName() {
        return this.archive.getName();
    }

    synchronized boolean isClosed() {
        return this.closed;
    }

    public String toString() {
        return this.getFileName();
    }
}

