/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file.tar;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.segment.file.tar.SegmentTarWriter;
import org.apache.jackrabbit.oak.segment.spi.monitor.FileStoreMonitor;
import org.apache.jackrabbit.oak.segment.spi.monitor.IOMonitor;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveManager;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveReader;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentTarManager
implements SegmentArchiveManager {
    private static final Pattern NAME_PATTERN = Pattern.compile("([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})(\\.([0-9a-f]{8}))?(\\..*)?");
    private static final Logger log = LoggerFactory.getLogger(SegmentTarManager.class);
    private final File segmentstoreDir;
    private final FileStoreMonitor fileStoreMonitor;
    private final IOMonitor ioMonitor;
    private final boolean memoryMapping;
    private final boolean offHeapAccess;

    public SegmentTarManager(File segmentstoreDir, FileStoreMonitor fileStoreMonitor, IOMonitor ioMonitor, boolean memoryMapping, boolean offHeapAccess) {
        this.segmentstoreDir = segmentstoreDir;
        this.fileStoreMonitor = fileStoreMonitor;
        this.ioMonitor = ioMonitor;
        this.memoryMapping = memoryMapping;
        this.offHeapAccess = offHeapAccess;
    }

    @Override
    public List<String> listArchives() {
        return Arrays.asList(this.segmentstoreDir.list((FilenameFilter)new SuffixFileFilter(".tar")));
    }

    /*
     * Exception decompiling
     */
    @Override
    public SegmentArchiveReader open(String name) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public SegmentArchiveReader forceOpen(String archiveName) throws IOException {
        return this.open(archiveName);
    }

    @Override
    public SegmentArchiveWriter create(String archiveName) {
        return new SegmentTarWriter(new File(this.segmentstoreDir, archiveName), this.fileStoreMonitor, this.ioMonitor);
    }

    @Override
    public boolean delete(String archiveName) {
        try {
            return Files.deleteIfExists(new File(this.segmentstoreDir, archiveName).toPath());
        }
        catch (IOException e) {
            log.error("Can't remove archive {}", (Object)archiveName, (Object)e);
            return false;
        }
    }

    @Override
    public boolean renameTo(String from, String to) {
        try {
            Files.move(new File(this.segmentstoreDir, from).toPath(), new File(this.segmentstoreDir, to).toPath(), new CopyOption[0]);
            return true;
        }
        catch (IOException e) {
            log.error("Can't move archive {} to {}", new Object[]{from, to, e});
            return false;
        }
    }

    @Override
    public void copyFile(String from, String to) throws IOException {
        Files.copy(new File(this.segmentstoreDir, from).toPath(), new File(this.segmentstoreDir, to).toPath(), new CopyOption[0]);
    }

    @Override
    public boolean exists(String archiveName) {
        return new File(this.segmentstoreDir, archiveName).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recoverEntries(String archiveName, LinkedHashMap<UUID, byte[]> entries) throws IOException {
        File file = new File(this.segmentstoreDir, archiveName);
        try (RandomAccessFile access = new RandomAccessFile(file, "r");){
            SegmentTarManager.recoverEntries(file, access, entries);
        }
    }

    private static void recoverEntries(File file, RandomAccessFile access, LinkedHashMap<UUID, byte[]> entries) throws IOException {
        byte[] header = new byte[512];
        while (access.getFilePointer() + 512L <= access.length()) {
            int i;
            access.readFully(header);
            int sum = 0;
            for (i = 0; i < 512; ++i) {
                sum += header[i] & 0xFF;
            }
            if (sum == 0 && access.getFilePointer() + 1024L == access.length()) {
                return;
            }
            for (i = 148; i < 156; ++i) {
                sum -= header[i] & 0xFF;
                sum += 32;
            }
            byte[] checkbytes = String.format("%06o\u0000 ", sum).getBytes(Charsets.UTF_8);
            for (int i2 = 0; i2 < checkbytes.length; ++i2) {
                if (checkbytes[i2] == header[148 + i2]) continue;
                log.warn("Invalid entry checksum at offset {} in tar file {}, skipping...", (Object)(access.getFilePointer() - 512L), (Object)file);
            }
            Buffer buffer = Buffer.wrap((byte[])header);
            String name = SegmentTarManager.readString(buffer, 100);
            buffer.position(124);
            int size = SegmentTarManager.readNumber(buffer, 12);
            if (access.getFilePointer() + (long)size > access.length()) {
                log.warn("Partial entry {} in tar file {}, ignoring...", (Object)name, (Object)file);
                return;
            }
            Matcher matcher = NAME_PATTERN.matcher(name);
            if (matcher.matches()) {
                UUID id = UUID.fromString(matcher.group(1));
                String checksum = matcher.group(3);
                if (checksum == null && entries.containsKey(id)) continue;
                byte[] data = new byte[size];
                access.readFully(data);
                long position = access.getFilePointer();
                long remainder = position % 512L;
                if (remainder != 0L) {
                    access.seek(position + (512L - remainder));
                }
                if (checksum != null) {
                    CRC32 crc = new CRC32();
                    crc.update(data, 0, data.length);
                    if (crc.getValue() != Long.parseLong(checksum, 16)) {
                        log.warn("Checksum mismatch in entry {} of tar file {}, skipping...", (Object)name, (Object)file);
                        continue;
                    }
                }
                entries.put(id, data);
                continue;
            }
            if (name.equals(file.getName() + ".idx")) continue;
            log.warn("Unexpected entry {} in tar file {}, skipping...", (Object)name, (Object)file);
            long position = access.getFilePointer() + (long)size;
            long remainder = position % 512L;
            if (remainder != 0L) {
                position += 512L - remainder;
            }
            access.seek(position);
        }
    }

    private static String readString(Buffer buffer, int fieldSize) {
        int n;
        byte[] b = new byte[fieldSize];
        buffer.get(b);
        for (n = 0; n < fieldSize && b[n] != 0; ++n) {
        }
        return new String(b, 0, n, Charsets.UTF_8);
    }

    private static int readNumber(Buffer buffer, int fieldSize) {
        int digit;
        byte[] b = new byte[fieldSize];
        buffer.get(b);
        int number = 0;
        for (int i = 0; i < fieldSize && 48 <= (digit = b[i] & 0xFF) && digit <= 55; ++i) {
            number = number * 8 + digit - 48;
        }
        return number;
    }
}

