/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file.tar;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import org.apache.commons.io.input.ReversedLinesFileReader;
import org.apache.jackrabbit.oak.segment.spi.persistence.JournalFile;
import org.apache.jackrabbit.oak.segment.spi.persistence.JournalFileReader;
import org.apache.jackrabbit.oak.segment.spi.persistence.JournalFileWriter;

public class LocalJournalFile
implements JournalFile {
    private final File journalFile;

    public LocalJournalFile(File directory, String journalFile) {
        this.journalFile = new File(directory, journalFile);
    }

    public LocalJournalFile(File journalFile) {
        this.journalFile = journalFile;
    }

    @Override
    public JournalFileReader openJournalReader() throws IOException {
        return new LocalJournalFileReader(this.journalFile);
    }

    @Override
    public JournalFileWriter openJournalWriter() throws IOException {
        return new LocalJournalFileWriter(this.journalFile);
    }

    @Override
    public String getName() {
        return this.journalFile.getName();
    }

    @Override
    public boolean exists() {
        return this.journalFile.exists();
    }

    private static class LocalJournalFileWriter
    implements JournalFileWriter {
        private final RandomAccessFile journalFile;

        public LocalJournalFileWriter(File file) throws IOException {
            this.journalFile = new RandomAccessFile(file, "rw");
            this.journalFile.seek(this.journalFile.length());
        }

        @Override
        public void truncate() throws IOException {
            this.journalFile.setLength(0L);
        }

        @Override
        public void writeLine(String line) throws IOException {
            this.journalFile.writeBytes(line + "\n");
            this.journalFile.getChannel().force(false);
        }

        @Override
        public void close() throws IOException {
            this.journalFile.close();
        }
    }

    private static class LocalJournalFileReader
    implements JournalFileReader {
        private final ReversedLinesFileReader journal;

        public LocalJournalFileReader(File file) throws IOException {
            this.journal = new ReversedLinesFileReader(file, Charset.defaultCharset());
        }

        @Override
        public String readLine() throws IOException {
            return this.journal.readLine();
        }

        @Override
        public void close() throws IOException {
            this.journal.close();
        }
    }
}

