/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import com.google.common.base.Function;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.segment.CheckpointCompactor;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.segment.SegmentWriter;
import org.apache.jackrabbit.oak.segment.compaction.SegmentGCOptions;
import org.apache.jackrabbit.oak.segment.compaction.SegmentGCStatus;
import org.apache.jackrabbit.oak.segment.file.CompactionResult;
import org.apache.jackrabbit.oak.segment.file.CompactionStrategy;
import org.apache.jackrabbit.oak.segment.file.GCJournal;
import org.apache.jackrabbit.oak.segment.file.PrintableStopwatch;
import org.apache.jackrabbit.oak.segment.file.TarRevisions;
import org.apache.jackrabbit.oak.segment.file.cancel.Cancellation;
import org.apache.jackrabbit.oak.segment.file.cancel.Canceller;
import org.apache.jackrabbit.oak.segment.file.tar.GCGeneration;
import org.apache.jackrabbit.oak.spi.state.NodeState;

abstract class AbstractCompactionStrategy
implements CompactionStrategy {
    AbstractCompactionStrategy() {
    }

    abstract SegmentGCOptions.GCType getCompactionType();

    abstract GCGeneration nextGeneration(GCGeneration var1);

    private CompactionResult compactionSucceeded(CompactionStrategy.Context context, GCGeneration generation, RecordId compactedRootId) {
        context.getGCListener().compactionSucceeded(generation);
        return CompactionResult.succeeded(this.getCompactionType(), generation, context.getGCOptions(), compactedRootId, context.getGCCount());
    }

    private static GCGeneration getGcGeneration(CompactionStrategy.Context context) {
        return context.getRevisions().getHead().getSegmentId().getGcGeneration();
    }

    private static SegmentNodeState getHead(CompactionStrategy.Context context) {
        return context.getSegmentReader().readHeadState(context.getRevisions());
    }

    private static long size(CompactionStrategy.Context context) {
        return context.getTarFiles().size();
    }

    private static CompactionResult compactionAborted(CompactionStrategy.Context context, GCGeneration generation) {
        context.getGCListener().compactionFailed(generation);
        return CompactionResult.aborted(AbstractCompactionStrategy.getGcGeneration(context), generation, context.getGCCount());
    }

    private static SegmentNodeState forceCompact(CompactionStrategy.Context context, NodeState base, NodeState onto, CheckpointCompactor compactor, Canceller canceller) throws InterruptedException {
        RecordId compactedId = AbstractCompactionStrategy.setHead(context, (Function<RecordId, RecordId>)((Function)headId -> {
            try {
                PrintableStopwatch t = PrintableStopwatch.createStarted();
                SegmentNodeState after = compactor.compact(base, context.getSegmentReader().readNode((RecordId)headId), onto, canceller);
                if (after != null) {
                    return after.getRecordId();
                }
                context.getGCListener().info("compaction cancelled after {}", new Object[]{t});
                return null;
            }
            catch (IOException e) {
                context.getGCListener().error("error during forced compaction.", e);
                return null;
            }
        }));
        if (compactedId == null) {
            return null;
        }
        return context.getSegmentReader().readNode(compactedId);
    }

    private static RecordId setHead(CompactionStrategy.Context context, Function<RecordId, RecordId> f) throws InterruptedException {
        return context.getRevisions().setHead(f, TarRevisions.timeout(context.getGCOptions().getForceTimeout(), TimeUnit.SECONDS));
    }

    private static String formatCompactionType(SegmentGCOptions.GCType compactionType) {
        switch (compactionType) {
            case FULL: {
                return "full";
            }
            case TAIL: {
                return "tail";
            }
        }
        throw new IllegalStateException("unsupported compaction type: " + (Object)((Object)compactionType));
    }

    final CompactionResult compact(CompactionStrategy.Context context, NodeState base) {
        context.getGCListener().info("running {} compaction", new Object[]{AbstractCompactionStrategy.formatCompactionType(this.getCompactionType())});
        GCGeneration nextGeneration = this.nextGeneration(AbstractCompactionStrategy.getGcGeneration(context));
        try {
            PrintableStopwatch watch = PrintableStopwatch.createStarted();
            context.getGCListener().info("compaction started, gc options={}, current generation={}, new generation={}", new Object[]{context.getGCOptions(), AbstractCompactionStrategy.getHead(context).getRecordId().getSegment().getGcGeneration(), nextGeneration});
            context.getGCListener().updateStatus(SegmentGCStatus.COMPACTION.message());
            GCJournal.GCJournalEntry gcEntry = context.getGCJournal().read();
            long initialSize = AbstractCompactionStrategy.size(context);
            SegmentWriter writer = context.getSegmentWriterFactory().newSegmentWriter(nextGeneration);
            context.getCompactionMonitor().init(gcEntry.getRepoSize(), gcEntry.getNodes(), initialSize);
            Canceller compactionCanceller = context.getCanceller().withShortCircuit();
            CheckpointCompactor compactor = new CheckpointCompactor(context.getGCListener(), context.getSegmentReader(), writer, context.getBlobStore(), context.getCompactionMonitor());
            SegmentNodeState head = AbstractCompactionStrategy.getHead(context);
            SegmentNodeState compacted = compactor.compact(base, head, base, compactionCanceller);
            if (compacted == null) {
                context.getGCListener().warn("compaction cancelled: {}.", new Object[]{compactionCanceller.check().getReason().orElse("unknown reason")});
                return AbstractCompactionStrategy.compactionAborted(context, nextGeneration);
            }
            context.getGCListener().info("compaction cycle 0 completed in {}. Compacted {} to {}", new Object[]{watch, head.getRecordId(), compacted.getRecordId()});
            int cycles = 0;
            boolean success = false;
            SegmentNodeState previousHead = head;
            while (cycles < context.getGCOptions().getRetryCount() && !(success = context.getRevisions().setHead(previousHead.getRecordId(), compacted.getRecordId(), TarRevisions.EXPEDITE_OPTION))) {
                context.getGCListener().info("compaction detected concurrent commits while compacting. Compacting these commits. Cycle {} of {}", new Object[]{++cycles, context.getGCOptions().getRetryCount()});
                context.getGCListener().updateStatus(SegmentGCStatus.COMPACTION_RETRY.message() + cycles);
                PrintableStopwatch cycleWatch = PrintableStopwatch.createStarted();
                head = AbstractCompactionStrategy.getHead(context);
                compacted = compactor.compact((NodeState)previousHead, head, (NodeState)compacted, compactionCanceller);
                if (compacted == null) {
                    context.getGCListener().warn("compaction cancelled: {}.", new Object[]{compactionCanceller.check().getReason().orElse("unknown reason")});
                    return AbstractCompactionStrategy.compactionAborted(context, nextGeneration);
                }
                context.getGCListener().info("compaction cycle {} completed in {}. Compacted {} against {} to {}", new Object[]{cycles, cycleWatch, head.getRecordId(), previousHead.getRecordId(), compacted.getRecordId()});
                previousHead = head;
            }
            if (!success) {
                context.getGCListener().info("compaction gave up compacting concurrent commits after {} cycles.", new Object[]{cycles});
                int forceTimeout = context.getGCOptions().getForceTimeout();
                if (forceTimeout > 0) {
                    context.getGCListener().info("trying to force compact remaining commits for {} seconds. Concurrent commits to the store will be blocked.", new Object[]{forceTimeout});
                    context.getGCListener().updateStatus(SegmentGCStatus.COMPACTION_FORCE_COMPACT.message());
                    PrintableStopwatch forceWatch = PrintableStopwatch.createStarted();
                    ++cycles;
                    Canceller forcedCompactionCanceller = compactionCanceller.withTimeout("forced compaction timeout exceeded", forceTimeout, TimeUnit.SECONDS).withShortCircuit();
                    compacted = AbstractCompactionStrategy.forceCompact(context, previousHead, compacted, compactor, forcedCompactionCanceller);
                    boolean bl = success = compacted != null;
                    if (success) {
                        context.getGCListener().info("compaction succeeded to force compact remaining commits after {}.", new Object[]{forceWatch});
                    } else {
                        Cancellation cancellation = forcedCompactionCanceller.check();
                        if (cancellation.isCancelled()) {
                            context.getGCListener().warn("compaction failed to force compact remaining commits after {}. Compaction was cancelled: {}.", new Object[]{forceWatch, cancellation.getReason().orElse("unknown reason")});
                        } else {
                            context.getGCListener().warn("compaction failed to force compact remaining commits. after {}. Could not acquire exclusive access to the node store.", new Object[]{forceWatch});
                        }
                    }
                }
            }
            if (success) {
                context.getSuccessfulCompactionListener().onSuccessfulCompaction(this.getCompactionType());
                writer.flush();
                context.getFlusher().flush();
                context.getGCListener().info("compaction succeeded in {}, after {} cycles", new Object[]{watch, cycles});
                return this.compactionSucceeded(context, nextGeneration, compacted.getRecordId());
            }
            context.getGCListener().info("compaction failed after {}, and {} cycles", new Object[]{watch, cycles});
            return AbstractCompactionStrategy.compactionAborted(context, nextGeneration);
        }
        catch (InterruptedException e) {
            context.getGCListener().error("compaction interrupted", e);
            Thread.currentThread().interrupt();
            return AbstractCompactionStrategy.compactionAborted(context, nextGeneration);
        }
        catch (IOException e) {
            context.getGCListener().error("compaction encountered an error", e);
            return AbstractCompactionStrategy.compactionAborted(context, nextGeneration);
        }
    }
}

