/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheStats;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import org.apache.jackrabbit.oak.api.jmx.CacheStatsMBean;
import org.apache.jackrabbit.oak.segment.Cache;
import org.apache.jackrabbit.oak.segment.CacheAccessTracker;
import org.apache.jackrabbit.oak.segment.RecordCache;
import org.apache.jackrabbit.oak.segment.RecordCacheStats;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.Template;
import org.apache.jackrabbit.oak.segment.file.PriorityCache;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WriterCacheManager {
    static final int DEFAULT_STRING_CACHE_SIZE_OSGi = 15000;
    public static final int DEFAULT_STRING_CACHE_SIZE = Integer.getInteger("oak.tar.stringsCacheSize", 15000);
    static final int DEFAULT_TEMPLATE_CACHE_SIZE_OSGi = 3000;
    public static final int DEFAULT_TEMPLATE_CACHE_SIZE = Integer.getInteger("oak.tar.templatesCacheSize", 3000);
    static final int DEFAULT_NODE_CACHE_SIZE_OSGi = 0x100000;
    public static final int DEFAULT_NODE_CACHE_SIZE = Integer.getInteger("oak.tar.nodeCacheSize", 0x100000);

    @NotNull
    public abstract Cache<String, RecordId> getStringCache(int var1);

    @NotNull
    public abstract Cache<Template, RecordId> getTemplateCache(int var1);

    @NotNull
    public abstract Cache<String, RecordId> getNodeCache(int var1);

    @NotNull
    public WriterCacheManager withAccessTracking(@NotNull String name, @NotNull StatisticsProvider statisticsProvider) {
        return new AccessTrackingCacheManager((String)Preconditions.checkNotNull((Object)name), (StatisticsProvider)Preconditions.checkNotNull((Object)statisticsProvider), this);
    }

    @Nullable
    public CacheStatsMBean getStringCacheStats() {
        return null;
    }

    @Nullable
    public CacheStatsMBean getTemplateCacheStats() {
        return null;
    }

    @Nullable
    public CacheStatsMBean getNodeCacheStats() {
        return null;
    }

    @Nullable
    public String getNodeCacheOccupancyInfo() {
        return null;
    }

    private static class AccessTrackingCacheManager
    extends WriterCacheManager {
        @NotNull
        private final String name;
        @NotNull
        private final StatisticsProvider statisticsProvider;
        @NotNull
        private final WriterCacheManager delegate;

        public AccessTrackingCacheManager(@NotNull String name, @NotNull StatisticsProvider statisticsProvider, @NotNull WriterCacheManager delegate) {
            this.name = name;
            this.statisticsProvider = statisticsProvider;
            this.delegate = delegate;
        }

        @Override
        @NotNull
        public Cache<String, RecordId> getStringCache(int generation) {
            return new CacheAccessTracker<String, RecordId>("oak.segment.string-deduplication-cache-" + this.name, this.statisticsProvider, this.delegate.getStringCache(generation));
        }

        @Override
        @NotNull
        public Cache<Template, RecordId> getTemplateCache(int generation) {
            return new CacheAccessTracker<Template, RecordId>("oak.segment.template-deduplication-cache-" + this.name, this.statisticsProvider, this.delegate.getTemplateCache(generation));
        }

        @Override
        @NotNull
        public Cache<String, RecordId> getNodeCache(int generation) {
            return new CacheAccessTracker<String, RecordId>("oak.segment.node-deduplication-cache-" + this.name, this.statisticsProvider, this.delegate.getNodeCache(generation));
        }
    }

    public static class Default
    extends WriterCacheManager {
        private final Generations<RecordCache<String>> stringCaches;
        private final Generations<RecordCache<Template>> templateCaches;
        private final Supplier<PriorityCache<String, RecordId>> nodeCache;

        public Default(@NotNull Supplier<RecordCache<String>> stringCacheFactory, @NotNull Supplier<RecordCache<Template>> templateCacheFactory, @NotNull Supplier<PriorityCache<String, RecordId>> nodeCacheFactory) {
            this.stringCaches = new Generations<RecordCache<String>>(stringCacheFactory);
            this.templateCaches = new Generations<RecordCache<Template>>(templateCacheFactory);
            this.nodeCache = Suppliers.memoize(nodeCacheFactory);
        }

        public Default() {
            this(RecordCache.factory(DEFAULT_STRING_CACHE_SIZE), RecordCache.factory(DEFAULT_TEMPLATE_CACHE_SIZE), PriorityCache.factory(DEFAULT_NODE_CACHE_SIZE));
        }

        @Override
        @NotNull
        public Cache<String, RecordId> getStringCache(int generation) {
            return this.stringCaches.getGeneration(generation);
        }

        @Override
        @NotNull
        public Cache<Template, RecordId> getTemplateCache(int generation) {
            return this.templateCaches.getGeneration(generation);
        }

        private PriorityCache<String, RecordId> nodeCache() {
            return (PriorityCache)this.nodeCache.get();
        }

        @Override
        @NotNull
        public Cache<String, RecordId> getNodeCache(final int generation) {
            return new Cache<String, RecordId>(){

                @Override
                public void put(@NotNull String stableId, @NotNull RecordId recordId, byte cost) {
                    this.nodeCache().put(stableId, recordId, generation, cost);
                }

                @Override
                public void put(@NotNull String key, @NotNull RecordId value) {
                    throw new UnsupportedOperationException();
                }

                @Override
                @Nullable
                public RecordId get(@NotNull String stableId) {
                    return (RecordId)this.nodeCache().get(stableId, generation);
                }
            };
        }

        @Override
        @Nullable
        public CacheStatsMBean getStringCacheStats() {
            return new RecordCacheStats("String deduplication cache stats", Default.accumulateRecordCacheStats(this.stringCaches), Default.accumulateRecordCacheSizes(this.stringCaches), Default.accumulateRecordCacheWeights(this.stringCaches));
        }

        @Override
        @Nullable
        public CacheStatsMBean getTemplateCacheStats() {
            return new RecordCacheStats("Template deduplication cache stats", Default.accumulateRecordCacheStats(this.templateCaches), Default.accumulateRecordCacheSizes(this.templateCaches), Default.accumulateRecordCacheWeights(this.templateCaches));
        }

        @NotNull
        private static <T> Supplier<CacheStats> accumulateRecordCacheStats(final Iterable<RecordCache<T>> caches) {
            return new Supplier<CacheStats>(){

                public CacheStats get() {
                    CacheStats stats = new CacheStats(0L, 0L, 0L, 0L, 0L, 0L);
                    for (RecordCache cache : caches) {
                        stats = stats.plus(cache.getStats());
                    }
                    return stats;
                }
            };
        }

        @NotNull
        public static <T> Supplier<Long> accumulateRecordCacheSizes(final Iterable<RecordCache<T>> caches) {
            return new Supplier<Long>(){

                public Long get() {
                    long size = 0L;
                    for (RecordCache cache : caches) {
                        size += cache.size();
                    }
                    return size;
                }
            };
        }

        @NotNull
        public static <T> Supplier<Long> accumulateRecordCacheWeights(final Iterable<RecordCache<T>> caches) {
            return new Supplier<Long>(){

                public Long get() {
                    long size = 0L;
                    for (RecordCache cache : caches) {
                        size += cache.estimateCurrentWeight();
                    }
                    return size;
                }
            };
        }

        @Override
        @Nullable
        public CacheStatsMBean getNodeCacheStats() {
            return new RecordCacheStats("Node deduplication cache stats", new Supplier<CacheStats>(){

                public CacheStats get() {
                    return this.nodeCache().getStats();
                }
            }, new Supplier<Long>(){

                public Long get() {
                    return this.nodeCache().size();
                }
            }, new Supplier<Long>(){

                public Long get() {
                    return this.nodeCache().estimateCurrentWeight();
                }
            });
        }

        protected final void evictCaches(Predicate<Integer> generations) {
            this.stringCaches.evictGenerations(generations);
            this.templateCaches.evictGenerations(generations);
            this.nodeCache().purgeGenerations(generations);
        }

        private static class Generations<T>
        implements Iterable<T> {
            private final ConcurrentMap<Integer, Supplier<T>> generations = Maps.newConcurrentMap();
            private final Supplier<T> cacheFactory;

            Generations(@NotNull Supplier<T> cacheFactory) {
                this.cacheFactory = (Supplier)Preconditions.checkNotNull(cacheFactory);
            }

            T getGeneration(int generation) {
                if (!this.generations.containsKey(generation)) {
                    this.generations.putIfAbsent(generation, Suppliers.memoize(this.cacheFactory));
                }
                return (T)((Supplier)this.generations.get(generation)).get();
            }

            @Override
            @NotNull
            public Iterator<T> iterator() {
                return Iterators.transform(this.generations.values().iterator(), (Function)new Function<Supplier<T>, T>(){

                    @Nullable
                    public T apply(Supplier<T> cacheFactory) {
                        return cacheFactory.get();
                    }
                });
            }

            void evictGenerations(@NotNull Predicate<Integer> evict) {
                Iterator it = this.generations.keySet().iterator();
                while (it.hasNext()) {
                    if (!evict.apply(it.next())) continue;
                    it.remove();
                }
            }
        }
    }

    public static class Empty
    extends WriterCacheManager {
        public static final WriterCacheManager INSTANCE = new Empty();
        private final RecordCache<String> stringCache = RecordCache.newRecordCache(0);
        private final RecordCache<Template> templateCache = RecordCache.newRecordCache(0);

        private Empty() {
        }

        @NotNull
        public RecordCache<String> getStringCache(int generation) {
            return this.stringCache;
        }

        @NotNull
        public RecordCache<Template> getTemplateCache(int generation) {
            return this.templateCache;
        }

        @Override
        @NotNull
        public Cache<String, RecordId> getNodeCache(int generation) {
            return new Cache<String, RecordId>(){

                @Override
                public void put(@NotNull String stableId, @NotNull RecordId recordId, byte cost) {
                }

                @Override
                public void put(@NotNull String key, @NotNull RecordId value) {
                    throw new UnsupportedOperationException();
                }

                @Override
                @Nullable
                public RecordId get(@NotNull String stableId) {
                    return null;
                }
            };
        }
    }
}

