/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.remote;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.segment.remote.RemoteSegmentArchiveEntry;
import org.apache.jackrabbit.oak.segment.remote.queue.SegmentWriteAction;
import org.apache.jackrabbit.oak.segment.remote.queue.SegmentWriteQueue;
import org.apache.jackrabbit.oak.segment.spi.monitor.FileStoreMonitor;
import org.apache.jackrabbit.oak.segment.spi.monitor.IOMonitor;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveWriter;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractRemoteSegmentArchiveWriter
implements SegmentArchiveWriter {
    protected final IOMonitor ioMonitor;
    protected final FileStoreMonitor monitor;
    protected final Optional<SegmentWriteQueue> queue;
    protected Map<UUID, RemoteSegmentArchiveEntry> index = Collections.synchronizedMap(new LinkedHashMap());
    protected int entries;
    protected long totalLength;
    protected volatile boolean created = false;

    public AbstractRemoteSegmentArchiveWriter(IOMonitor ioMonitor, FileStoreMonitor monitor) {
        this.ioMonitor = ioMonitor;
        this.monitor = monitor;
        this.queue = SegmentWriteQueue.THREADS > 0 ? Optional.of(new SegmentWriteQueue(this::doWriteArchiveEntry)) : Optional.empty();
    }

    public void writeSegment(long msb, long lsb, @NotNull byte[] data, int offset, int size, int generation, int fullGeneration, boolean compacted) throws IOException {
        this.created = true;
        RemoteSegmentArchiveEntry entry = new RemoteSegmentArchiveEntry(msb, lsb, this.entries++, size, generation, fullGeneration, compacted);
        if (this.queue.isPresent()) {
            this.queue.get().addToQueue(entry, data, offset, size);
        } else {
            this.doWriteArchiveEntry(entry, data, offset, size);
        }
        this.index.put(new UUID(msb, lsb), entry);
        this.totalLength += (long)size;
        this.monitor.written((long)size);
    }

    public Buffer readSegment(long msb, long lsb) throws IOException {
        UUID uuid = new UUID(msb, lsb);
        Optional<SegmentWriteAction> segment = this.queue.map(q -> q.read(uuid));
        if (segment.isPresent()) {
            return segment.get().toBuffer();
        }
        RemoteSegmentArchiveEntry indexEntry = this.index.get(new UUID(msb, lsb));
        if (indexEntry == null) {
            return null;
        }
        return this.doReadArchiveEntry(indexEntry);
    }

    public boolean containsSegment(long msb, long lsb) {
        UUID uuid = new UUID(msb, lsb);
        Optional<SegmentWriteAction> segment = this.queue.map(q -> q.read(uuid));
        if (segment.isPresent()) {
            return true;
        }
        return this.index.containsKey(new UUID(msb, lsb));
    }

    public void writeGraph(@NotNull byte[] data) throws IOException {
        this.writeDataFile(data, ".gph");
    }

    public void writeBinaryReferences(@NotNull byte[] data) throws IOException {
        this.writeDataFile(data, ".brf");
    }

    public void writeDataFile(byte[] data, String extension) throws IOException {
        this.doWriteDataFile(data, extension);
        this.totalLength += (long)data.length;
        this.monitor.written((long)data.length);
    }

    public long getLength() {
        return this.totalLength;
    }

    public int getEntryCount() {
        return this.index.size();
    }

    public void close() throws IOException {
        if (this.queue.isPresent()) {
            SegmentWriteQueue q = this.queue.get();
            q.flush();
            q.close();
        }
        this.afterQueueClosed();
    }

    public boolean isCreated() {
        return this.created || !this.queueIsEmpty();
    }

    private boolean queueIsEmpty() {
        return this.queue.map(SegmentWriteQueue::isEmpty).orElse(true);
    }

    public void flush() throws IOException {
        if (this.queue.isPresent()) {
            this.queue.get().flush();
            this.afterQueueFlushed();
        }
    }

    protected abstract void doWriteArchiveEntry(RemoteSegmentArchiveEntry var1, byte[] var2, int var3, int var4) throws IOException;

    protected abstract Buffer doReadArchiveEntry(RemoteSegmentArchiveEntry var1) throws IOException;

    protected abstract void doWriteDataFile(byte[] var1, String var2) throws IOException;

    protected abstract void afterQueueClosed() throws IOException;

    protected abstract void afterQueueFlushed() throws IOException;
}

