/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.azure.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class AzureConfigurationParserUtils {
    public static final String KEY_CONNECTION_STRING = "connectionString";
    public static final String KEY_CONTAINER_NAME = "containerName";
    public static final String KEY_ACCOUNT_NAME = "accountName";
    public static final String KEY_STORAGE_URI = "storageUri";
    public static final String KEY_DIR = "directory";
    public static final String KEY_SHARED_ACCESS_SIGNATURE = "sharedAccessSignature";

    private AzureConfigurationParserUtils() {
    }

    public static boolean isCustomAzureConnectionString(String conn) {
        return conn.contains(AzureConnectionKey.DEFAULT_ENDPOINTS_PROTOCOL.text());
    }

    public static Map<String, String> parseAzureConfigurationFromCustomConnection(String connectionString) {
        HashMap<AzureConnectionKey, String> tempConfig = new HashMap<AzureConnectionKey, String>();
        String[] connKeys = connectionString.split(";");
        for (AzureConnectionKey key : AzureConnectionKey.values()) {
            for (String connKey : connKeys) {
                if (!connKey.toLowerCase().startsWith(key.text().toLowerCase())) continue;
                tempConfig.put(key, connKey.substring(connKey.indexOf("=") + 1));
            }
        }
        StringBuilder canonicalConnectionString = new StringBuilder();
        canonicalConnectionString.append(AzureConnectionKey.DEFAULT_ENDPOINTS_PROTOCOL.text()).append("=").append((String)tempConfig.get((Object)AzureConnectionKey.DEFAULT_ENDPOINTS_PROTOCOL)).append(";");
        canonicalConnectionString.append(AzureConnectionKey.ACCOUNT_NAME.text()).append("=").append((String)tempConfig.get((Object)AzureConnectionKey.ACCOUNT_NAME)).append(";");
        if (tempConfig.containsKey((Object)AzureConnectionKey.ACCOUNT_KEY)) {
            canonicalConnectionString.append(AzureConnectionKey.ACCOUNT_KEY.text()).append("=").append((String)tempConfig.get((Object)AzureConnectionKey.ACCOUNT_KEY)).append(";");
        }
        if (tempConfig.containsKey((Object)AzureConnectionKey.SHARED_ACCESS_SIGNATURE)) {
            canonicalConnectionString.append(AzureConnectionKey.SHARED_ACCESS_SIGNATURE.text()).append("=").append((String)tempConfig.get((Object)AzureConnectionKey.SHARED_ACCESS_SIGNATURE)).append(";");
        }
        if (tempConfig.containsKey((Object)AzureConnectionKey.BLOB_ENDPOINT)) {
            canonicalConnectionString.append(AzureConnectionKey.BLOB_ENDPOINT.text()).append("=").append((String)tempConfig.get((Object)AzureConnectionKey.BLOB_ENDPOINT)).append(";");
        }
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(KEY_CONNECTION_STRING, canonicalConnectionString.toString());
        config.put(KEY_CONTAINER_NAME, (String)tempConfig.get((Object)AzureConnectionKey.CONTAINER_NAME));
        config.put(KEY_DIR, (String)tempConfig.get((Object)AzureConnectionKey.DIRECTORY));
        config.put(KEY_SHARED_ACCESS_SIGNATURE, (String)tempConfig.get((Object)AzureConnectionKey.SHARED_ACCESS_SIGNATURE));
        return config;
    }

    public static Map<String, String> parseAzureConfigurationFromUri(String uriStr) {
        URI uri = AzureConfigurationParserUtils.parseURIString(uriStr);
        String host = uri.getHost();
        String path = uri.getPath();
        String scheme = uri.getScheme();
        String sasToken = uri.getRawQuery();
        int lastSlashPosPath = path.lastIndexOf(47);
        int dotPosHost = host.indexOf(".");
        String accountName = host.substring(0, dotPosHost);
        String container = path.substring(0, lastSlashPosPath);
        String storageUri = scheme + "://" + host + container;
        String dir = path.substring(lastSlashPosPath + 1);
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(KEY_ACCOUNT_NAME, accountName);
        config.put(KEY_STORAGE_URI, storageUri);
        config.put(KEY_DIR, dir);
        if (sasToken != null) {
            config.put(KEY_SHARED_ACCESS_SIGNATURE, sasToken);
        }
        return config;
    }

    @NotNull
    private static URI parseURIString(String uriStr) {
        try {
            return new URI(uriStr);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    public static enum AzureConnectionKey {
        DEFAULT_ENDPOINTS_PROTOCOL("DefaultEndpointsProtocol"),
        ACCOUNT_NAME("AccountName"),
        ACCOUNT_KEY("AccountKey"),
        BLOB_ENDPOINT("BlobEndpoint"),
        CONTAINER_NAME("ContainerName"),
        DIRECTORY("Directory"),
        SHARED_ACCESS_SIGNATURE("SharedAccessSignature");

        private final String text;

        private AzureConnectionKey(String text) {
            this.text = text;
        }

        public String text() {
            return this.text;
        }
    }
}

