/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.azure;

import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.LocationMode;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.BlobRequestOptions;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.oak.segment.azure.AzurePersistence;
import org.apache.jackrabbit.oak.segment.azure.Configuration;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentNodeStorePersistence;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, configurationPid={"org.apache.jackrabbit.oak.segment.azure.AzureSegmentStoreService"})
public class AzureSegmentStoreService {
    private static final Logger log = LoggerFactory.getLogger(AzureSegmentStoreService.class);
    public static final String DEFAULT_CONTAINER_NAME = "oak";
    public static final String DEFAULT_ROOT_PATH = "/oak";
    public static final boolean DEFAULT_ENABLE_SECONDARY_LOCATION = false;
    private ServiceRegistration registration;

    @Activate
    public void activate(ComponentContext context, final Configuration config) throws IOException {
        AzurePersistence persistence = AzureSegmentStoreService.createAzurePersistenceFrom(config);
        this.registration = context.getBundleContext().registerService(SegmentNodeStorePersistence.class, (Object)persistence, (Dictionary)new Hashtable<String, Object>(){
            {
                this.put("service.pid", String.format("%s(%s, %s)", AzurePersistence.class.getName(), config.accountName(), config.rootPath()));
                if (!Objects.equals(config.role(), "")) {
                    this.put("role", config.role());
                }
            }
        });
    }

    @Deactivate
    public void deactivate() throws IOException {
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
    }

    private static AzurePersistence createAzurePersistenceFrom(Configuration configuration) throws IOException {
        if (!StringUtils.isBlank((CharSequence)configuration.connectionURL())) {
            return AzureSegmentStoreService.createPersistenceFromConnectionURL(configuration);
        }
        if (!StringUtils.isBlank((CharSequence)configuration.sharedAccessSignature())) {
            return AzureSegmentStoreService.createPersistenceFromSasUri(configuration);
        }
        return AzureSegmentStoreService.createPersistenceFromAccessKey(configuration);
    }

    private static AzurePersistence createPersistenceFromAccessKey(Configuration configuration) throws IOException {
        StringBuilder connectionString = new StringBuilder();
        connectionString.append("DefaultEndpointsProtocol=https;");
        connectionString.append("AccountName=").append(configuration.accountName()).append(';');
        connectionString.append("AccountKey=").append(configuration.accessKey()).append(';');
        if (!StringUtils.isBlank((CharSequence)configuration.blobEndpoint())) {
            connectionString.append("BlobEndpoint=").append(configuration.blobEndpoint()).append(';');
        }
        return AzureSegmentStoreService.createAzurePersistence(connectionString.toString(), configuration, true);
    }

    private static AzurePersistence createPersistenceFromSasUri(Configuration configuration) throws IOException {
        StringBuilder connectionString = new StringBuilder();
        connectionString.append("DefaultEndpointsProtocol=https;");
        connectionString.append("AccountName=").append(configuration.accountName()).append(';');
        connectionString.append("SharedAccessSignature=").append(configuration.sharedAccessSignature()).append(';');
        if (!StringUtils.isBlank((CharSequence)configuration.blobEndpoint())) {
            connectionString.append("BlobEndpoint=").append(configuration.blobEndpoint()).append(';');
        }
        return AzureSegmentStoreService.createAzurePersistence(connectionString.toString(), configuration, false);
    }

    @NotNull
    private static AzurePersistence createPersistenceFromConnectionURL(Configuration configuration) throws IOException {
        return AzureSegmentStoreService.createAzurePersistence(configuration.connectionURL(), configuration, true);
    }

    @NotNull
    private static AzurePersistence createAzurePersistence(String connectionString, Configuration configuration, boolean createContainer) throws IOException {
        try {
            CloudStorageAccount cloud = CloudStorageAccount.parse(connectionString);
            log.info("Connection string: '{}'", (Object)cloud);
            CloudBlobClient cloudBlobClient = cloud.createCloudBlobClient();
            BlobRequestOptions blobRequestOptions = new BlobRequestOptions();
            if (configuration.enableSecondaryLocation()) {
                blobRequestOptions.setLocationMode(LocationMode.PRIMARY_THEN_SECONDARY);
            }
            cloudBlobClient.setDefaultRequestOptions(blobRequestOptions);
            CloudBlobContainer container = cloudBlobClient.getContainerReference(configuration.containerName());
            if (createContainer && !container.exists()) {
                container.create();
            }
            String path = AzureSegmentStoreService.normalizePath(configuration.rootPath());
            return new AzurePersistence(container.getDirectoryReference(path));
        }
        catch (StorageException | URISyntaxException | InvalidKeyException e) {
            throw new IOException(e);
        }
    }

    @NotNull
    private static String normalizePath(@NotNull String rootPath) {
        if (rootPath.length() > 0 && rootPath.charAt(0) == '/') {
            return rootPath.substring(1);
        }
        return rootPath;
    }
}

