/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.azure;

import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.CloudAppendBlob;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.guava.common.base.Charsets;
import org.apache.jackrabbit.oak.segment.spi.persistence.GCJournalFile;

public class AzureGCJournalFile
implements GCJournalFile {
    private final CloudAppendBlob gcJournal;

    public AzureGCJournalFile(CloudAppendBlob gcJournal) {
        this.gcJournal = gcJournal;
    }

    public void writeLine(String line) throws IOException {
        try {
            if (!this.gcJournal.exists()) {
                this.gcJournal.createOrReplace();
            }
            this.gcJournal.appendText(line + "\n", Charsets.UTF_8.name(), null, null, null);
        }
        catch (StorageException e) {
            throw new IOException(e);
        }
    }

    public List<String> readLines() throws IOException {
        try {
            if (!this.gcJournal.exists()) {
                return Collections.emptyList();
            }
            byte[] data = new byte[(int)this.gcJournal.getProperties().getLength()];
            this.gcJournal.downloadToByteArray(data, 0);
            return IOUtils.readLines((InputStream)new ByteArrayInputStream(data), (Charset)Charset.defaultCharset());
        }
        catch (StorageException e) {
            throw new IOException(e);
        }
    }

    public void truncate() throws IOException {
        try {
            if (this.gcJournal.exists()) {
                this.gcJournal.delete();
            }
        }
        catch (StorageException e) {
            throw new IOException(e);
        }
    }
}

