/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.data.AbstractDataStore;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.core.data.MultiDataStoreAware;
import org.apache.jackrabbit.guava.common.base.Stopwatch;
import org.apache.jackrabbit.guava.common.cache.CacheLoader;
import org.apache.jackrabbit.guava.common.collect.Iterators;
import org.apache.jackrabbit.guava.common.io.Closeables;
import org.apache.jackrabbit.guava.common.util.concurrent.ListeningExecutorService;
import org.apache.jackrabbit.oak.commons.FileIOUtils;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.plugins.blob.CompositeDataStoreCache;
import org.apache.jackrabbit.oak.plugins.blob.DataStoreCacheStatsMBean;
import org.apache.jackrabbit.oak.plugins.blob.SharedDataStore;
import org.apache.jackrabbit.oak.plugins.blob.StagingUploader;
import org.apache.jackrabbit.oak.plugins.blob.datastore.TypedDataStore;
import org.apache.jackrabbit.oak.spi.blob.AbstractDataRecord;
import org.apache.jackrabbit.oak.spi.blob.AbstractSharedBackend;
import org.apache.jackrabbit.oak.spi.blob.BlobOptions;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.util.LazyFileInputStream;
import org.apache.jackrabbit.util.TransientFileFactory;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSharedCachingDataStore
extends AbstractDataStore
implements MultiDataStoreAware,
SharedDataStore,
TypedDataStore {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSharedCachingDataStore.class);
    private String path;
    private long cacheSize = 0x1000000000L;
    private int stagingSplitPercentage = 10;
    private int uploadThreads = 10;
    private int stagingPurgeInterval = 300;
    private int stagingRetryInterval = 600;
    private File rootDirectory;
    private File tmp;
    private StatisticsProvider statisticsProvider;
    protected CompositeDataStoreCache cache;
    protected AbstractSharedBackend backend;
    protected ListeningExecutorService listeningExecutor;
    protected ScheduledExecutorService schedulerExecutor;
    protected ExecutorService executor;

    public void init(String homeDir) throws DataStoreException {
        if (this.path == null) {
            this.path = homeDir + "/repository/datastore";
        }
        this.path = FilenameUtils.normalizeNoEndSeparator((String)new File(this.path).getAbsolutePath());
        Validate.checkArgument((this.stagingSplitPercentage >= 0 && this.stagingSplitPercentage <= 50 ? 1 : 0) != 0, (String)"Staging percentage cache should be between 0 and 50");
        this.rootDirectory = new File(this.path);
        this.tmp = new File(this.rootDirectory, "tmp");
        LOG.trace("Temporary file created [{}]", (Object)this.tmp.mkdirs());
        this.backend = this.createBackend();
        this.backend.init();
        String home = FilenameUtils.normalizeNoEndSeparator((String)new File(homeDir).getAbsolutePath());
        this.cache = new CompositeDataStoreCache(this.path, new File(home), this.cacheSize, this.stagingSplitPercentage, this.uploadThreads, new CacheLoader<String, InputStream>(){

            public InputStream load(String key) throws Exception {
                return AbstractSharedCachingDataStore.this.backend.read(new DataIdentifier(key));
            }
        }, new StagingUploader(){

            @Override
            public void write(String id, File file) throws DataStoreException {
                AbstractSharedCachingDataStore.this.backend.write(new DataIdentifier(id), file);
            }

            @Override
            public void adopt(File f, File moved) throws IOException {
                FileUtils.moveFile((File)f, (File)moved);
            }
        }, this.statisticsProvider, this.listeningExecutor, this.schedulerExecutor, this.executor, this.stagingPurgeInterval, this.stagingRetryInterval);
    }

    protected abstract AbstractSharedBackend createBackend();

    public DataRecord getRecord(DataIdentifier identifier) throws DataStoreException {
        DataRecord record = this.getRecordIfStored(identifier);
        if (record != null) {
            return record;
        }
        throw new DataStoreException("Record " + identifier + " does not exist");
    }

    @Nullable
    public DataRecord getRecordIfStored(DataIdentifier dataIdentifier) throws DataStoreException {
        File cached = this.cache.getIfPresent(dataIdentifier.toString());
        if (cached != null && cached.exists()) {
            return new FileCacheDataRecord(this, this.backend, dataIdentifier, cached.length(), this.tmp, cached.lastModified());
        }
        try {
            DataRecord rec = this.backend.getRecord(dataIdentifier);
            return new FileCacheDataRecord(this, this.backend, dataIdentifier, rec.getLength(), this.tmp, rec.getLastModified());
        }
        catch (Exception e) {
            LOG.error("Error retrieving record [{}]", (Object)dataIdentifier, (Object)e);
            return null;
        }
    }

    public DataRecord addRecord(InputStream inputStream) throws DataStoreException {
        return this.addRecord(inputStream, new BlobOptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataRecord addRecord(InputStream inputStream, BlobOptions blobOptions) throws DataStoreException {
        Stopwatch watch = Stopwatch.createStarted();
        try {
            TransientFileFactory fileFactory = TransientFileFactory.getInstance();
            File tmpFile = fileFactory.createTransientFile("upload", null, this.tmp);
            MessageDigest digest = MessageDigest.getInstance(this.DIGEST);
            long length = 0L;
            try (DigestOutputStream output = new DigestOutputStream(new FileOutputStream(tmpFile), digest);){
                length = IOUtils.copyLarge((InputStream)inputStream, (OutputStream)output);
            }
            DataIdentifier identifier = new DataIdentifier(AbstractSharedCachingDataStore.encodeHexString((byte[])digest.digest()));
            LOG.debug("SHA-256 of [{}], length =[{}] took [{}] ms ", new Object[]{identifier, length, watch.elapsed(TimeUnit.MILLISECONDS)});
            if (blobOptions.getUpload() == BlobOptions.UploadType.SYNCHRONOUS || !this.cache.stage(identifier.toString(), tmpFile)) {
                this.backend.write(identifier, tmpFile);
                LOG.debug("Added blob [{}] to backend", (Object)identifier);
                this.cache.getDownloadCache().put(identifier.toString(), tmpFile);
                boolean deletedTemp = FileUtils.deleteQuietly((File)tmpFile);
                LOG.trace("Temporary file deleted {}", (Object)deletedTemp);
            }
            return this.getRecordIfStored(identifier);
        }
        catch (Exception e) {
            LOG.error("Error in adding record");
            throw new DataStoreException("Error in adding record ", (Throwable)e);
        }
    }

    public Iterator<DataIdentifier> getAllIdentifiers() throws DataStoreException {
        return Iterators.concat((Iterator)Iterators.transform(this.cache.getStagingCache().getAllIdentifiers(), id -> new DataIdentifier(id)), (Iterator)this.backend.getAllIdentifiers());
    }

    public void deleteRecord(DataIdentifier dataIdentifier) throws DataStoreException {
        this.cache.invalidate(dataIdentifier.toString());
        this.backend.deleteRecord(dataIdentifier);
    }

    public void close() throws DataStoreException {
        this.backend.close();
        this.cache.close();
    }

    public boolean exists(DataIdentifier identifier) {
        try {
            if (identifier != null) {
                return this.backend.exists(identifier);
            }
        }
        catch (DataStoreException e) {
            LOG.warn(String.format("Data Store Exception caught checking for %s in pending uploads", identifier), (Throwable)e);
        }
        return false;
    }

    public List<DataStoreCacheStatsMBean> getStats() {
        return List.of(this.cache.getCacheStats(), this.cache.getStagingCacheStats());
    }

    protected CompositeDataStoreCache getCache() {
        return this.cache;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setCacheSize(long cacheSize) {
        this.cacheSize = cacheSize;
    }

    public void setStagingSplitPercentage(int stagingSplitPercentage) {
        this.stagingSplitPercentage = stagingSplitPercentage;
    }

    public void setUploadThreads(int uploadThreads) {
        this.uploadThreads = uploadThreads;
    }

    public void setStagingPurgeInterval(int stagingPurgeInterval) {
        this.stagingPurgeInterval = stagingPurgeInterval;
    }

    public void setStagingRetryInterval(int stagingRetryInterval) {
        this.stagingRetryInterval = stagingRetryInterval;
    }

    public void setStatisticsProvider(StatisticsProvider statisticsProvider) {
        this.statisticsProvider = statisticsProvider;
    }

    @Override
    public void addMetadataRecord(InputStream stream, String name) throws DataStoreException {
        this.backend.addMetadataRecord(stream, name);
    }

    @Override
    public void addMetadataRecord(File f, String name) throws DataStoreException {
        this.backend.addMetadataRecord(f, name);
    }

    @Override
    public DataRecord getMetadataRecord(String name) {
        return this.backend.getMetadataRecord(name);
    }

    @Override
    public boolean metadataRecordExists(String name) {
        return this.backend.metadataRecordExists(name);
    }

    @Override
    public List<DataRecord> getAllMetadataRecords(String prefix) {
        return this.backend.getAllMetadataRecords(prefix);
    }

    @Override
    public boolean deleteMetadataRecord(String name) {
        return this.backend.deleteMetadataRecord(name);
    }

    @Override
    public void deleteAllMetadataRecords(String prefix) {
        this.backend.deleteAllMetadataRecords(prefix);
    }

    @Override
    public Iterator<DataRecord> getAllRecords() throws DataStoreException {
        return this.backend.getAllRecords();
    }

    @Override
    public DataRecord getRecordForId(DataIdentifier identifier) throws DataStoreException {
        return this.backend.getRecord(identifier);
    }

    @Override
    public SharedDataStore.Type getType() {
        return SharedDataStore.Type.SHARED;
    }

    protected byte[] getOrCreateReferenceKey() throws DataStoreException {
        return this.backend.getOrCreateReferenceKey();
    }

    public void clearInUse() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public void updateModifiedDateOnAccess(long l) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public int deleteAllOlderThan(long l) throws DataStoreException {
        throw new UnsupportedOperationException("Operation not supported");
    }

    static class FileCacheDataRecord
    extends AbstractDataRecord {
        private final long length;
        private final long lastModified;
        private final AbstractSharedCachingDataStore store;
        private final File temp;

        public FileCacheDataRecord(AbstractSharedCachingDataStore store, AbstractSharedBackend backend, DataIdentifier identifier, long length, File temp, long lastModified) {
            super(backend, identifier);
            this.length = length;
            this.temp = temp;
            this.lastModified = lastModified;
            this.store = store;
        }

        public long getLength() throws DataStoreException {
            return this.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public InputStream getStream() throws DataStoreException {
            LazyFileInputStream lazyFileInputStream;
            File cached = null;
            try {
                cached = this.store.cache.get(this.getIdentifier().toString());
            }
            catch (Exception e) {
                LOG.debug("Error retrieving from cache " + this.getIdentifier(), (Throwable)e);
            }
            if (cached != null && cached.exists()) return new FileInputStream(cached);
            InputStream in = null;
            try {
                TransientFileFactory fileFactory = TransientFileFactory.getInstance();
                File tmpFile = fileFactory.createTransientFile("temp0cache", null, this.temp);
                in = this.backend.getRecord(this.getIdentifier()).getStream();
                FileIOUtils.copyInputStreamToFile((InputStream)in, (File)tmpFile);
                lazyFileInputStream = new LazyFileInputStream(tmpFile);
            }
            catch (Throwable throwable) {
                try {
                    Closeables.close(in, (boolean)false);
                    throw throwable;
                }
                catch (Exception e) {
                    throw new DataStoreException("Error opening input stream for identifier " + this.getIdentifier(), (Throwable)e);
                }
            }
            Closeables.close((Closeable)in, (boolean)false);
            return lazyFileInputStream;
        }

        public long getLastModified() {
            return this.lastModified;
        }
    }
}

