/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.blob.cloud.azure.blobstorage;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.oak.blob.cloud.azure.blobstorage.AzureDataStore;
import org.apache.jackrabbit.oak.plugins.blob.AbstractSharedCachingDataStore;
import org.apache.jackrabbit.oak.plugins.blob.datastore.AbstractDataStoreService;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;

public abstract class AbstractAzureDataStoreService
extends AbstractDataStoreService {
    private static final String DESCRIPTION = "oak.datastore.description";
    private ServiceRegistration delegateReg;

    protected DataStore createDataStore(ComponentContext context, Map<String, Object> config) {
        Properties properties = new Properties();
        properties.putAll(config);
        AzureDataStore dataStore = new AzureDataStore();
        dataStore.setStatisticsProvider(this.getStatisticsProvider());
        dataStore.setProperties(properties);
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("service.pid", ((Object)((Object)dataStore)).getClass().getName());
        ((Dictionary)props).put(DESCRIPTION, this.getDescription());
        this.delegateReg = context.getBundleContext().registerService(new String[]{AbstractSharedCachingDataStore.class.getName(), AbstractSharedCachingDataStore.class.getName()}, (Object)dataStore, props);
        return dataStore;
    }

    protected void deactivate() throws DataStoreException {
        if (this.delegateReg != null) {
            this.delegateReg.unregister();
        }
        super.deactivate();
    }

    protected String[] getDescription() {
        return new String[]{"type=AzureBlob"};
    }
}

