/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vfs.ext.ds;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Properties;
import javax.jcr.RepositoryException;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.impl.StandardFileSystemManager;
import org.apache.commons.vfs2.util.DelegatingFileSystemOptionsBuilder;
import org.apache.jackrabbit.core.data.Backend;
import org.apache.jackrabbit.core.data.CachingDataStore;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.vfs.ext.ds.VFSBackend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VFSDataStore
extends CachingDataStore {
    static final String BASE_FOLDER_URI = "baseFolderUri";
    static final String ASYNC_WRITE_POOL_SIZE = "asyncWritePoolSize";
    static final String FILE_SYSTEM_MANAGER_CLASS_NAME = "fileSystemManagerClassName";
    private static final Logger LOG = LoggerFactory.getLogger(VFSDataStore.class);
    static final String PROP_MAX_TOTAL_CONNECTIONS = "maxTotalConnections";
    static final String PROP_MAX_CONNECTIONS_PER_HOST = "maxConnectionsPerHost";
    static final int DEFAULT_MAX_CONNECTION = 200;
    private static final String FILE_SYSTEM_OPTIONS_PROP_PREFIX = "fso.";
    private String fileSystemManagerClassName;
    private FileSystemManager fileSystemManager;
    private FileSystemOptions fileSystemOptions;
    private Properties fileSystemOptionsProperties;
    private String baseFolderUri;
    private FileObject baseFolder;
    private int asyncWritePoolSize = 10;

    public void init(String homeDir) throws RepositoryException {
        this.overridePropertiesFromConfig();
        if (this.baseFolderUri == null) {
            throw new RepositoryException("VFS base folder URI must be set.");
        }
        this.fileSystemManager = this.createFileSystemManager();
        FileName baseFolderName = null;
        try {
            baseFolderName = this.fileSystemManager.resolveURI(this.baseFolderUri);
            FileSystemOptions fso = this.getFileSystemOptions();
            this.baseFolder = fso != null ? this.fileSystemManager.resolveFile(this.baseFolderUri, fso) : this.fileSystemManager.resolveFile(this.baseFolderUri);
            this.baseFolder.createFolder();
        }
        catch (FileSystemException e) {
            throw new RepositoryException("Could not initialize the VFS base folder at '" + (baseFolderName == null ? "" : baseFolderName.getFriendlyURI()) + "'.", (Throwable)e);
        }
        super.init(homeDir);
    }

    public void close() throws DataStoreException {
        VFSBackend backend = (VFSBackend)this.getBackend();
        try {
            int seconds = 0;
            while (backend.getAsyncWriteExecutorActiveCount() > 0 && seconds++ < 300) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while waiting for the async write executor to complete.", (Throwable)e);
        }
        super.close();
    }

    protected Backend createBackend() {
        VFSBackend backend = new VFSBackend(this.baseFolder);
        backend.setAsyncWritePoolSize(this.getAsyncWritePoolSize());
        return backend;
    }

    protected String getMarkerFile() {
        return "vfs.init.done";
    }

    public String getFileSystemManagerClassName() {
        return this.fileSystemManagerClassName;
    }

    public void setFileSystemManagerClassName(String fileSystemManagerClassName) {
        this.fileSystemManagerClassName = fileSystemManagerClassName;
    }

    public FileSystemManager getFileSystemManager() {
        return this.fileSystemManager;
    }

    public FileSystemOptions getFileSystemOptions() throws RepositoryException {
        if (this.fileSystemOptions == null) {
            this.fileSystemOptions = this.createFileSystemOptions();
        }
        return this.fileSystemOptions;
    }

    public void setFileSystemOptions(FileSystemOptions fileSystemOptions) {
        this.fileSystemOptions = fileSystemOptions;
    }

    public void setFileSystemOptionsProperties(Properties fileSystemOptionsProperties) {
        this.fileSystemOptionsProperties = fileSystemOptionsProperties;
    }

    public void setFileSystemOptionsPropertiesInString(String fileSystemOptionsPropertiesInString) {
        if (fileSystemOptionsPropertiesInString != null) {
            try {
                StringReader reader = new StringReader(fileSystemOptionsPropertiesInString);
                Properties props = new Properties();
                props.load(reader);
                this.fileSystemOptionsProperties = props;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not load file system options properties.", e);
            }
        }
    }

    public void setBaseFolderUri(String baseFolderUri) {
        this.baseFolderUri = baseFolderUri;
    }

    public int getAsyncWritePoolSize() {
        return this.asyncWritePoolSize;
    }

    public void setAsyncWritePoolSize(int asyncWritePoolSize) {
        this.asyncWritePoolSize = asyncWritePoolSize;
    }

    protected FileSystemManager createFileSystemManager() throws RepositoryException {
        StandardFileSystemManager fileSystemManager = null;
        try {
            if (this.getFileSystemManagerClassName() == null) {
                fileSystemManager = new StandardFileSystemManager();
            } else {
                Class<?> mgrClass = Class.forName(this.getFileSystemManagerClassName());
                fileSystemManager = (FileSystemManager)mgrClass.newInstance();
            }
            if (fileSystemManager instanceof DefaultFileSystemManager) {
                ((DefaultFileSystemManager)fileSystemManager).init();
            }
        }
        catch (FileSystemException e) {
            throw new RepositoryException("Could not initialize file system manager of class: " + this.getFileSystemManagerClassName(), (Throwable)e);
        }
        catch (Exception e) {
            throw new RepositoryException("Could not create file system manager of class: " + this.getFileSystemManagerClassName(), (Throwable)e);
        }
        return fileSystemManager;
    }

    protected FileSystemOptions createFileSystemOptions() throws RepositoryException {
        FileSystemOptions fso = null;
        if (this.fileSystemOptionsProperties != null) {
            try {
                fso = new FileSystemOptions();
                DelegatingFileSystemOptionsBuilder delegate = new DelegatingFileSystemOptionsBuilder(this.getFileSystemManager());
                Enumeration<?> e = this.fileSystemOptionsProperties.propertyNames();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    if (!key.startsWith(FILE_SYSTEM_OPTIONS_PROP_PREFIX)) continue;
                    String value = this.fileSystemOptionsProperties.getProperty(key);
                    String schemeDotPropName = key.substring(FILE_SYSTEM_OPTIONS_PROP_PREFIX.length());
                    int offset = schemeDotPropName.indexOf(46);
                    if (offset > 0) {
                        String scheme = schemeDotPropName.substring(0, offset);
                        String propName = schemeDotPropName.substring(offset + 1);
                        delegate.setConfigString(fso, scheme, propName, value);
                        continue;
                    }
                    LOG.warn("Ignoring an FileSystemOptions property in invalid format. Key: {}, Value: {}", (Object)key, (Object)value);
                }
            }
            catch (FileSystemException e) {
                throw new RepositoryException("Could not create File System Options.", (Throwable)e);
            }
        }
        return fso;
    }

    protected Properties getFileSystemOptionsProperties() {
        return this.fileSystemOptionsProperties;
    }

    private void overridePropertiesFromConfig() throws RepositoryException {
        String config = this.getConfig();
        if (config != null && !"".equals(config)) {
            try {
                Properties props = this.readConfig(config);
                String propValue = props.getProperty(ASYNC_WRITE_POOL_SIZE);
                if (propValue != null && !"".equals(propValue)) {
                    this.setAsyncWritePoolSize(Integer.parseInt(propValue));
                }
                if ((propValue = props.getProperty(BASE_FOLDER_URI)) != null && !"".equals(propValue)) {
                    this.setBaseFolderUri(propValue);
                }
                if ((propValue = props.getProperty(FILE_SYSTEM_MANAGER_CLASS_NAME)) != null && !"".equals(propValue)) {
                    this.setFileSystemManagerClassName(propValue);
                }
                Properties fsoProps = new Properties();
                Enumeration<?> propNames = props.propertyNames();
                while (propNames.hasMoreElements()) {
                    String propName = (String)propNames.nextElement();
                    if (!propName.startsWith(FILE_SYSTEM_OPTIONS_PROP_PREFIX)) continue;
                    fsoProps.setProperty(propName, props.getProperty(propName));
                }
                if (!fsoProps.isEmpty()) {
                    this.setFileSystemOptionsProperties(fsoProps);
                }
            }
            catch (IOException e) {
                throw new RepositoryException("Configuration file doesn't exist at '" + config + "'.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readConfig(String fileName) throws IOException {
        if (!new File(fileName).exists()) {
            throw new IOException("Config file not found: " + fileName);
        }
        Properties prop = new Properties();
        try (FileInputStream in = null;){
            in = new FileInputStream(fileName);
            prop.load(in);
        }
        return prop;
    }
}

