/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.extractor;

import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.jackrabbit.extractor.AbstractTextExtractor;
import org.apache.jackrabbit.extractor.ExtractorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XMLTextExtractor
extends AbstractTextExtractor {
    public XMLTextExtractor() {
        super(new String[]{"text/xml", "application/xml"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader extractText(InputStream stream, String type, String encoding) throws IOException {
        try {
            CharArrayWriter writer = new CharArrayWriter();
            ExtractorHandler handler = new ExtractorHandler(writer);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setContentHandler(handler);
            reader.setErrorHandler(handler);
            InputSource source = new InputSource(new FilterInputStream(stream){

                public void close() {
                }
            });
            if (encoding != null) {
                source.setEncoding(encoding);
            }
            reader.parse(source);
            CharArrayReader charArrayReader = new CharArrayReader(writer.toCharArray());
            return charArrayReader;
        }
        catch (ParserConfigurationException e) {
            StringReader stringReader = new StringReader("");
            return stringReader;
        }
        catch (SAXException e) {
            StringReader stringReader = new StringReader("");
            return stringReader;
        }
        finally {
            stream.close();
        }
    }
}

