/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2jcr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.LoginException;
import javax.jcr.MergeException;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import javax.jcr.Workspace;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.observation.EventListener;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.util.TraversingItemVisitor;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import org.apache.jackrabbit.api.jsr283.lock.LockManager;
import org.apache.jackrabbit.spi.Batch;
import org.apache.jackrabbit.spi.EventBundle;
import org.apache.jackrabbit.spi.EventFilter;
import org.apache.jackrabbit.spi.IdFactory;
import org.apache.jackrabbit.spi.ItemId;
import org.apache.jackrabbit.spi.LockInfo;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.NodeInfo;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PathFactory;
import org.apache.jackrabbit.spi.PropertyId;
import org.apache.jackrabbit.spi.PropertyInfo;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.QueryInfo;
import org.apache.jackrabbit.spi.RepositoryService;
import org.apache.jackrabbit.spi.SessionInfo;
import org.apache.jackrabbit.spi.Subscription;
import org.apache.jackrabbit.spi.commons.EventFilterImpl;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.spi.commons.name.PathBuilder;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.apache.jackrabbit.spi.commons.value.QValueFactoryImpl;
import org.apache.jackrabbit.spi.commons.value.ValueFormat;
import org.apache.jackrabbit.spi2jcr.BatchReadConfig;
import org.apache.jackrabbit.spi2jcr.ChildInfoImpl;
import org.apache.jackrabbit.spi2jcr.EventSubscription;
import org.apache.jackrabbit.spi2jcr.IdFactoryImpl;
import org.apache.jackrabbit.spi2jcr.LockInfoImpl;
import org.apache.jackrabbit.spi2jcr.NodeInfoImpl;
import org.apache.jackrabbit.spi2jcr.PropertyInfoImpl;
import org.apache.jackrabbit.spi2jcr.QNodeDefinitionImpl;
import org.apache.jackrabbit.spi2jcr.QNodeTypeDefinitionImpl;
import org.apache.jackrabbit.spi2jcr.QPropertyDefinitionImpl;
import org.apache.jackrabbit.spi2jcr.QueryInfoImpl;
import org.apache.jackrabbit.spi2jcr.RepositoryServiceImpl;
import org.apache.jackrabbit.spi2jcr.SessionInfoImpl;

public class RepositoryServiceImpl
implements RepositoryService {
    private final Repository repository;
    private final BatchReadConfig batchReadConfig;
    private final IdFactoryImpl idFactory = (IdFactoryImpl)IdFactoryImpl.getInstance();
    private final boolean supportsObservation;

    public RepositoryServiceImpl(Repository repository, BatchReadConfig batchReadConfig) {
        this.repository = repository;
        this.batchReadConfig = batchReadConfig;
        this.supportsObservation = "true".equals(repository.getDescriptor("option.observation.supported"));
    }

    public IdFactory getIdFactory() {
        return this.idFactory;
    }

    public NameFactory getNameFactory() {
        return NameFactoryImpl.getInstance();
    }

    public PathFactory getPathFactory() {
        return PathFactoryImpl.getInstance();
    }

    public QValueFactory getQValueFactory() {
        return QValueFactoryImpl.getInstance();
    }

    public Map getRepositoryDescriptors() throws RepositoryException {
        HashMap<String, String> descriptors = new HashMap<String, String>();
        String[] keys = this.repository.getDescriptorKeys();
        int i = 0;
        while (i < keys.length) {
            if (keys[i].equals("option.transactions.supported")) {
                descriptors.put(keys[i], "false");
            } else {
                descriptors.put(keys[i], this.repository.getDescriptor(keys[i]));
            }
            ++i;
        }
        return descriptors;
    }

    public SessionInfo obtain(Credentials credentials, String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        Credentials duplicate = SessionInfoImpl.duplicateCredentials(credentials);
        return new SessionInfoImpl(this.repository.login(credentials, workspaceName), duplicate, this.getNameFactory(), this.getPathFactory());
    }

    public SessionInfo obtain(SessionInfo sessionInfo, String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        Session s = this.repository.login(sInfo.getCredentials(), workspaceName);
        return new SessionInfoImpl(s, sInfo.getCredentials(), this.getNameFactory(), this.getPathFactory());
    }

    public SessionInfo impersonate(SessionInfo sessionInfo, Credentials credentials) throws LoginException, RepositoryException {
        Credentials duplicate = SessionInfoImpl.duplicateCredentials(credentials);
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        return new SessionInfoImpl(sInfo.getSession().impersonate(credentials), duplicate, this.getNameFactory(), this.getPathFactory());
    }

    public void dispose(SessionInfo sessionInfo) throws RepositoryException {
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        Iterator it = sInfo.getSubscriptions().iterator();
        while (it.hasNext()) {
            EventSubscription s = (EventSubscription)it.next();
            s.dispose();
        }
        sInfo.getSession().logout();
    }

    public String[] getWorkspaceNames(SessionInfo sessionInfo) throws RepositoryException {
        Session s = this.getSessionInfoImpl(sessionInfo).getSession();
        return s.getWorkspace().getAccessibleWorkspaceNames();
    }

    public boolean isGranted(SessionInfo sessionInfo, ItemId itemId, String[] actions) throws RepositoryException {
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        String path = this.pathForId(itemId, sInfo);
        try {
            String actStr;
            if (actions.length == 1) {
                actStr = actions[0];
            } else {
                String comma = "";
                actStr = "";
                int i = 0;
                while (i < actions.length) {
                    actStr = String.valueOf(actStr) + comma;
                    actStr = String.valueOf(actStr) + actions[i];
                    comma = ",";
                    ++i;
                }
            }
            sInfo.getSession().checkPermission(path, actStr);
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    public QNodeDefinition getNodeDefinition(SessionInfo sessionInfo, NodeId nodeId) throws RepositoryException {
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        try {
            return new QNodeDefinitionImpl(this.getNode(nodeId, sInfo).getDefinition(), sInfo.getNamePathResolver());
        }
        catch (NameException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public QPropertyDefinition getPropertyDefinition(SessionInfo sessionInfo, PropertyId propertyId) throws RepositoryException {
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        try {
            return new QPropertyDefinitionImpl(this.getProperty(propertyId, sInfo).getDefinition(), sInfo.getNamePathResolver(), this.getQValueFactory());
        }
        catch (NameException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public NodeInfo getNodeInfo(SessionInfo sessionInfo, NodeId nodeId) throws ItemNotFoundException, RepositoryException {
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        Node node = this.getNode(nodeId, sInfo);
        try {
            return new NodeInfoImpl(node, this.idFactory, sInfo.getNamePathResolver());
        }
        catch (NameException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public Iterator getItemInfos(SessionInfo sessionInfo, NodeId nodeId) throws ItemNotFoundException, RepositoryException {
        final SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        Node node = this.getNode(nodeId, sInfo);
        Name ntName = null;
        try {
            ntName = sInfo.getNamePathResolver().getQName(node.getProperty("jcr:primaryType").getString());
        }
        catch (NameException nameException) {
            // empty catch block
        }
        int depth = this.batchReadConfig.getDepth(ntName);
        if (depth == 0) {
            NodeInfoImpl info;
            try {
                info = new NodeInfoImpl(node, this.idFactory, sInfo.getNamePathResolver());
            }
            catch (NameException e) {
                throw new RepositoryException((Throwable)e);
            }
            return Collections.singletonList(info).iterator();
        }
        final ArrayList itemInfos = new ArrayList();
        TraversingItemVisitor visitor = new TraversingItemVisitor(false, depth){

            protected void entering(Property property, int i) throws RepositoryException {
                try {
                    itemInfos.add(new PropertyInfoImpl(property, RepositoryServiceImpl.this.idFactory, sInfo.getNamePathResolver(), RepositoryServiceImpl.this.getQValueFactory()));
                }
                catch (NameException e) {
                    throw new RepositoryException((Throwable)e);
                }
            }

            protected void entering(Node node, int i) throws RepositoryException {
                try {
                    itemInfos.add(new NodeInfoImpl(node, RepositoryServiceImpl.this.idFactory, sInfo.getNamePathResolver()));
                }
                catch (NameException e) {
                    throw new RepositoryException((Throwable)e);
                }
            }

            protected void leaving(Property property, int i) {
            }

            protected void leaving(Node node, int i) {
            }
        };
        visitor.visit(node);
        return itemInfos.iterator();
    }

    public Iterator getChildInfos(SessionInfo sessionInfo, NodeId parentId) throws ItemNotFoundException, RepositoryException {
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        NodeIterator children = this.getNode(parentId, sInfo).getNodes();
        ArrayList<ChildInfoImpl> childInfos = new ArrayList<ChildInfoImpl>();
        try {
            while (children.hasNext()) {
                childInfos.add(new ChildInfoImpl(children.nextNode(), sInfo.getNamePathResolver()));
            }
        }
        catch (NameException e) {
            throw new RepositoryException((Throwable)e);
        }
        return childInfos.iterator();
    }

    public PropertyInfo getPropertyInfo(SessionInfo sessionInfo, PropertyId propertyId) throws ItemNotFoundException, RepositoryException {
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        try {
            return new PropertyInfoImpl(this.getProperty(propertyId, sInfo), this.idFactory, sInfo.getNamePathResolver(), this.getQValueFactory());
        }
        catch (NameException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public Batch createBatch(SessionInfo sessionInfo, ItemId itemId) throws RepositoryException {
        return new BatchImpl(this.getSessionInfoImpl(sessionInfo));
    }

    public void submit(Batch batch) throws PathNotFoundException, ItemNotFoundException, NoSuchNodeTypeException, ValueFormatException, VersionException, LockException, ConstraintViolationException, AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
        if (!(batch instanceof BatchImpl)) {
            throw new RepositoryException("Unknown Batch implementation: " + batch.getClass().getName());
        }
        ((BatchImpl)batch).end();
    }

    public void importXml(SessionInfo sessionInfo, final NodeId parentId, final InputStream xmlStream, final int uuidBehaviour) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
        final SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        this.executeWithLocalEvents(new Callable(){

            public Object run() throws RepositoryException {
                String path = RepositoryServiceImpl.this.pathForId((ItemId)parentId, sInfo);
                try {
                    sInfo.getSession().getWorkspace().importXML(path, xmlStream, uuidBehaviour);
                }
                catch (IOException e) {
                    throw new RepositoryException(e.getMessage(), (Throwable)e);
                }
                return null;
            }
        }, sInfo);
    }

    public void move(SessionInfo sessionInfo, final NodeId srcNodeId, final NodeId destParentNodeId, final Name destName) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
        final SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        this.executeWithLocalEvents(new Callable(){

            public Object run() throws RepositoryException {
                String srcPath = RepositoryServiceImpl.this.pathForId((ItemId)srcNodeId, sInfo);
                StringBuffer destPath = new StringBuffer(RepositoryServiceImpl.this.pathForId((ItemId)destParentNodeId, sInfo));
                if (destPath.length() > 1) {
                    destPath.append("/");
                }
                destPath.append(sInfo.getNamePathResolver().getJCRName(destName));
                sInfo.getSession().getWorkspace().move(srcPath, destPath.toString());
                return null;
            }
        }, sInfo);
    }

    public void copy(SessionInfo sessionInfo, final String srcWorkspaceName, final NodeId srcNodeId, final NodeId destParentNodeId, final Name destName) throws NoSuchWorkspaceException, ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, UnsupportedRepositoryOperationException, RepositoryException {
        final SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        this.executeWithLocalEvents(new Callable(){

            public Object run() throws RepositoryException {
                Workspace ws = sInfo.getSession().getWorkspace();
                String destPath = RepositoryServiceImpl.this.getDestinationPath(destParentNodeId, destName, sInfo);
                if (ws.getName().equals(srcWorkspaceName)) {
                    String srcPath = RepositoryServiceImpl.this.pathForId((ItemId)srcNodeId, sInfo);
                    ws.copy(srcPath, destPath);
                } else {
                    SessionInfoImpl srcInfo = RepositoryServiceImpl.this.getSessionInfoImpl(RepositoryServiceImpl.this.obtain(sInfo, srcWorkspaceName));
                    try {
                        String srcPath = RepositoryServiceImpl.this.pathForId((ItemId)srcNodeId, srcInfo);
                        ws.copy(srcWorkspaceName, srcPath, destPath);
                    }
                    finally {
                        RepositoryServiceImpl.this.dispose(srcInfo);
                    }
                }
                return null;
            }
        }, sInfo);
    }

    public void update(SessionInfo sessionInfo, final NodeId nodeId, final String srcWorkspaceName) throws NoSuchWorkspaceException, AccessDeniedException, LockException, InvalidItemStateException, RepositoryException {
        final SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        this.executeWithLocalEvents(new Callable(){

            public Object run() throws RepositoryException {
                RepositoryServiceImpl.this.getNode(nodeId, sInfo).update(srcWorkspaceName);
                return null;
            }
        }, sInfo);
    }

    public void clone(final SessionInfo sessionInfo, final String srcWorkspaceName, final NodeId srcNodeId, final NodeId destParentNodeId, final Name destName, final boolean removeExisting) throws NoSuchWorkspaceException, ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, UnsupportedRepositoryOperationException, RepositoryException {
        final SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        this.executeWithLocalEvents(new Callable(){

            public Object run() throws RepositoryException {
                SessionInfoImpl srcInfo = RepositoryServiceImpl.this.getSessionInfoImpl(RepositoryServiceImpl.this.obtain(sessionInfo, srcWorkspaceName));
                try {
                    String srcPath = RepositoryServiceImpl.this.pathForId((ItemId)srcNodeId, srcInfo);
                    String destPath = RepositoryServiceImpl.this.getDestinationPath(destParentNodeId, destName, sInfo);
                    Workspace wsp = sInfo.getSession().getWorkspace();
                    wsp.clone(srcWorkspaceName, srcPath, destPath, removeExisting);
                }
                finally {
                    RepositoryServiceImpl.this.dispose(srcInfo);
                }
                return null;
            }
        }, sInfo);
    }

    public LockInfo getLockInfo(SessionInfo sessionInfo, NodeId nodeId) throws RepositoryException {
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        try {
            Lock lock = this.getNode(nodeId, sInfo).getLock();
            return LockInfoImpl.createLockInfo(lock, this.idFactory, sInfo.getNamePathResolver());
        }
        catch (LockException e) {
            return null;
        }
    }

    public LockInfo lock(SessionInfo sessionInfo, final NodeId nodeId, final boolean deep, final boolean sessionScoped) throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        final SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        return (LockInfo)this.executeWithLocalEvents(new Callable(){

            public Object run() throws RepositoryException {
                Node n = RepositoryServiceImpl.this.getNode(nodeId, sInfo);
                Lock lock = n.lock(deep, sessionScoped);
                return LockInfoImpl.createLockInfo(lock, RepositoryServiceImpl.this.idFactory, sInfo.getNamePathResolver());
            }
        }, sInfo);
    }

    public LockInfo lock(SessionInfo sessionInfo, final NodeId nodeId, final boolean deep, final boolean sessionScoped, final long timeoutHint, final String ownerHint) throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, RepositoryException {
        final SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        return (LockInfo)this.executeWithLocalEvents(new Callable(){

            public Object run() throws RepositoryException {
                Lock lock;
                Node n = RepositoryServiceImpl.this.getNode(nodeId, sInfo);
                if (sInfo.getSession() instanceof org.apache.jackrabbit.api.jsr283.Session) {
                    LockManager lMgr = ((org.apache.jackrabbit.api.jsr283.Workspace)sInfo.getSession().getWorkspace()).getLockManager();
                    lock = lMgr.lock(n.getPath(), deep, sessionScoped, timeoutHint, ownerHint);
                } else {
                    lock = n.lock(deep, sessionScoped);
                }
                return LockInfoImpl.createLockInfo(lock, RepositoryServiceImpl.this.idFactory, sInfo.getNamePathResolver());
            }
        }, sInfo);
    }

    public void refreshLock(SessionInfo sessionInfo, NodeId nodeId) throws LockException, RepositoryException {
        this.getNode(nodeId, this.getSessionInfoImpl(sessionInfo)).getLock().refresh();
    }

    public void unlock(SessionInfo sessionInfo, final NodeId nodeId) throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        final SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        this.executeWithLocalEvents(new Callable(){

            public Object run() throws RepositoryException {
                RepositoryServiceImpl.this.getNode(nodeId, sInfo).unlock();
                return null;
            }
        }, sInfo);
    }

    public NodeId checkin(final SessionInfo sessionInfo, final NodeId nodeId) throws VersionException, UnsupportedRepositoryOperationException, InvalidItemStateException, LockException, RepositoryException {
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        Version newVersion = (Version)this.executeWithLocalEvents(new Callable(){

            public Object run() throws RepositoryException {
                return RepositoryServiceImpl.this.getNode(nodeId, RepositoryServiceImpl.this.getSessionInfoImpl(sessionInfo)).checkin();
            }
        }, sInfo);
        return this.idFactory.createNodeId((Node)newVersion, sInfo.getNamePathResolver());
    }

    public void checkout(final SessionInfo sessionInfo, final NodeId nodeId) throws UnsupportedRepositoryOperationException, LockException, RepositoryException {
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        this.executeWithLocalEvents(new Callable(){

            public Object run() throws RepositoryException {
                RepositoryServiceImpl.this.getNode(nodeId, RepositoryServiceImpl.this.getSessionInfoImpl(sessionInfo)).checkout();
                return null;
            }
        }, sInfo);
    }

    public void removeVersion(SessionInfo sessionInfo, final NodeId versionHistoryId, final NodeId versionId) throws ReferentialIntegrityException, AccessDeniedException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        final SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        this.executeWithLocalEvents(new Callable(){

            public Object run() throws RepositoryException {
                Node vHistory = RepositoryServiceImpl.this.getNode(versionHistoryId, sInfo);
                Node version = RepositoryServiceImpl.this.getNode(versionId, sInfo);
                if (!(vHistory instanceof VersionHistory)) {
                    throw new RepositoryException("versionHistoryId does not reference a VersionHistor node");
                }
                ((VersionHistory)vHistory).removeVersion(version.getName());
                return null;
            }
        }, sInfo);
    }

    public void restore(final SessionInfo sessionInfo, final NodeId nodeId, final NodeId versionId, final boolean removeExisting) throws VersionException, PathNotFoundException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        final SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        this.executeWithLocalEvents(new Callable(){

            public Object run() throws RepositoryException {
                Version v = (Version)RepositoryServiceImpl.this.getNode(versionId, sInfo);
                if (RepositoryServiceImpl.this.hasNode(sessionInfo, nodeId)) {
                    Node n = RepositoryServiceImpl.this.getNode(nodeId, sInfo);
                    n.restore(v, removeExisting);
                } else {
                    Node n = null;
                    Path relPath = null;
                    Path path = nodeId.getPath();
                    if (nodeId.getUniqueID() != null) {
                        n = RepositoryServiceImpl.this.getNode(RepositoryServiceImpl.this.idFactory.createNodeId(nodeId.getUniqueID()), sInfo);
                        relPath = path.isAbsolute() ? RepositoryServiceImpl.this.getPathFactory().getRootPath().computeRelativePath(nodeId.getPath()) : path;
                    } else {
                        int degree = 0;
                        while (degree < path.getLength()) {
                            Path ancestorPath = path.getAncestor(degree);
                            NodeId parentId = RepositoryServiceImpl.this.idFactory.createNodeId(nodeId.getUniqueID(), ancestorPath);
                            if (RepositoryServiceImpl.this.hasNode(sessionInfo, parentId)) {
                                n = RepositoryServiceImpl.this.getNode(parentId, sInfo);
                                relPath = ancestorPath.computeRelativePath(path);
                            }
                            ++degree;
                        }
                    }
                    if (n == null) {
                        throw new PathNotFoundException("Path not found " + nodeId);
                    }
                    n.restore(v, sInfo.getNamePathResolver().getJCRPath(relPath), removeExisting);
                }
                return null;
            }
        }, sInfo);
    }

    private boolean hasNode(SessionInfo sessionInfo, NodeId nodeId) throws RepositoryException {
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        try {
            this.getNode(nodeId, sInfo);
        }
        catch (ItemNotFoundException e) {
            return false;
        }
        catch (PathNotFoundException e) {
            return false;
        }
        return true;
    }

    public void restore(SessionInfo sessionInfo, final NodeId[] versionIds, final boolean removeExisting) throws ItemExistsException, UnsupportedRepositoryOperationException, VersionException, LockException, InvalidItemStateException, RepositoryException {
        final SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        this.executeWithLocalEvents(new Callable(){

            public Object run() throws RepositoryException {
                Version[] versions = new Version[versionIds.length];
                int i = 0;
                while (i < versions.length) {
                    Node n = RepositoryServiceImpl.this.getNode(versionIds[i], sInfo);
                    if (!(n instanceof Version)) {
                        throw new RepositoryException(String.valueOf(n.getPath()) + " does not reference a Version node");
                    }
                    versions[i] = (Version)n;
                    ++i;
                }
                sInfo.getSession().getWorkspace().restore(versions, removeExisting);
                return null;
            }
        }, sInfo);
    }

    public Iterator merge(SessionInfo sessionInfo, final NodeId nodeId, final String srcWorkspaceName, final boolean bestEffort) throws NoSuchWorkspaceException, AccessDeniedException, MergeException, LockException, InvalidItemStateException, RepositoryException {
        final SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        return (Iterator)this.executeWithLocalEvents(new Callable(){

            public Object run() throws RepositoryException {
                Node n = RepositoryServiceImpl.this.getNode(nodeId, sInfo);
                NodeIterator it = n.merge(srcWorkspaceName, bestEffort);
                ArrayList<NodeId> ids = new ArrayList<NodeId>();
                while (it.hasNext()) {
                    ids.add(RepositoryServiceImpl.this.idFactory.createNodeId(it.nextNode(), sInfo.getNamePathResolver()));
                }
                return ids.iterator();
            }
        }, sInfo);
    }

    public void resolveMergeConflict(SessionInfo sessionInfo, final NodeId nodeId, final NodeId[] mergeFailedIds, final NodeId[] predecessorIds) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
        final SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        this.executeWithLocalEvents(new Callable(){

            public Object run() throws RepositoryException {
                Node node = RepositoryServiceImpl.this.getNode(nodeId, sInfo);
                Version version = null;
                NamePathResolver resolver = sInfo.getNamePathResolver();
                List<NodeId> l = Arrays.asList(mergeFailedIds);
                Property mergeFailed = node.getProperty(resolver.getJCRName(NameConstants.JCR_MERGEFAILED));
                Value[] values = mergeFailed.getValues();
                int i = 0;
                while (i < values.length) {
                    String uuid = values[i].getString();
                    if (!l.contains(RepositoryServiceImpl.this.idFactory.createNodeId(uuid))) {
                        version = (Version)sInfo.getSession().getNodeByUUID(uuid);
                        break;
                    }
                    ++i;
                }
                l = new ArrayList<NodeId>(predecessorIds.length);
                l.addAll(Arrays.asList(predecessorIds));
                Property predecessors = node.getProperty(resolver.getJCRName(NameConstants.JCR_PREDECESSORS));
                values = predecessors.getValues();
                int i2 = 0;
                while (i2 < values.length) {
                    NodeId vId = RepositoryServiceImpl.this.idFactory.createNodeId(values[i2].getString());
                    l.remove(vId);
                    ++i2;
                }
                boolean cancel = l.isEmpty();
                if (cancel) {
                    node.cancelMerge(version);
                } else {
                    node.doneMerge(version);
                }
                return null;
            }
        }, sInfo);
    }

    public void addVersionLabel(SessionInfo sessionInfo, final NodeId versionHistoryId, final NodeId versionId, final Name label, final boolean moveLabel) throws VersionException, RepositoryException {
        final SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        this.executeWithLocalEvents(new Callable(){

            public Object run() throws RepositoryException {
                String jcrLabel = sInfo.getNamePathResolver().getJCRName(label);
                Node version = RepositoryServiceImpl.this.getNode(versionId, sInfo);
                Node vHistory = RepositoryServiceImpl.this.getNode(versionHistoryId, sInfo);
                if (!(vHistory instanceof VersionHistory)) {
                    throw new RepositoryException("versionHistoryId does not reference a VersionHistory node");
                }
                ((VersionHistory)vHistory).addVersionLabel(version.getName(), jcrLabel, moveLabel);
                return null;
            }
        }, sInfo);
    }

    public void removeVersionLabel(SessionInfo sessionInfo, final NodeId versionHistoryId, NodeId versionId, final Name label) throws VersionException, RepositoryException {
        final SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        this.executeWithLocalEvents(new Callable(){

            public Object run() throws RepositoryException {
                String jcrLabel = sInfo.getNamePathResolver().getJCRName(label);
                Node vHistory = RepositoryServiceImpl.this.getNode(versionHistoryId, sInfo);
                if (!(vHistory instanceof VersionHistory)) {
                    throw new RepositoryException("versionHistoryId does not reference a VersionHistory node");
                }
                ((VersionHistory)vHistory).removeVersionLabel(jcrLabel);
                return null;
            }
        }, sInfo);
    }

    public String[] getSupportedQueryLanguages(SessionInfo sessionInfo) throws RepositoryException {
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        return sInfo.getSession().getWorkspace().getQueryManager().getSupportedQueryLanguages();
    }

    public void checkQueryStatement(SessionInfo sessionInfo, String statement, String language, Map namespaces) throws InvalidQueryException, RepositoryException {
        this.createQuery(this.getSessionInfoImpl(sessionInfo).getSession(), statement, language, namespaces);
    }

    public QueryInfo executeQuery(SessionInfo sessionInfo, String statement, String language, Map namespaces) throws RepositoryException {
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        Query query = this.createQuery(sInfo.getSession(), statement, language, namespaces);
        return new QueryInfoImpl(query.execute(), this.idFactory, sInfo.getNamePathResolver(), this.getQValueFactory());
    }

    public EventFilter createEventFilter(SessionInfo sessionInfo, int eventTypes, Path absPath, boolean isDeep, String[] uuid, Name[] nodeTypeName, boolean noLocal) throws UnsupportedRepositoryOperationException, RepositoryException {
        HashSet<Name> ntNames = null;
        if (nodeTypeName != null) {
            ntNames = new HashSet<Name>(Arrays.asList(nodeTypeName));
        }
        return new EventFilterImpl(eventTypes, absPath, isDeep, uuid, ntNames, noLocal);
    }

    public Subscription createSubscription(SessionInfo sessionInfo, EventFilter[] filters) throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.getSessionInfoImpl(sessionInfo).createSubscription((IdFactory)this.idFactory, filters);
    }

    public EventBundle[] getEvents(Subscription subscription, long timeout) throws RepositoryException, UnsupportedRepositoryOperationException, InterruptedException {
        if (subscription instanceof EventSubscription) {
            return ((EventSubscription)subscription).getEventBundles(timeout);
        }
        throw new RepositoryException("Unknown subscription implementation: " + subscription.getClass().getName());
    }

    public void updateEventFilters(Subscription subscription, EventFilter[] filters) throws RepositoryException {
        this.getEventSubscription(subscription).setFilters(filters);
    }

    public void dispose(Subscription subscription) throws RepositoryException {
        this.getEventSubscription(subscription).dispose();
    }

    public Map getRegisteredNamespaces(SessionInfo sessionInfo) throws RepositoryException {
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        NamespaceRegistry nsReg = sInfo.getSession().getWorkspace().getNamespaceRegistry();
        HashMap<String, String> namespaces = new HashMap<String, String>();
        String[] prefixes = nsReg.getPrefixes();
        int i = 0;
        while (i < prefixes.length) {
            namespaces.put(prefixes[i], nsReg.getURI(prefixes[i]));
            ++i;
        }
        return namespaces;
    }

    public String getNamespaceURI(SessionInfo sessionInfo, String prefix) throws NamespaceException, RepositoryException {
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        return sInfo.getSession().getWorkspace().getNamespaceRegistry().getURI(prefix);
    }

    public String getNamespacePrefix(SessionInfo sessionInfo, String uri) throws NamespaceException, RepositoryException {
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        return sInfo.getSession().getWorkspace().getNamespaceRegistry().getPrefix(uri);
    }

    public void registerNamespace(SessionInfo sessionInfo, String prefix, String uri) throws NamespaceException, UnsupportedRepositoryOperationException, AccessDeniedException, RepositoryException {
        Session session = this.getSessionInfoImpl(sessionInfo).getSession();
        NamespaceRegistry nsReg = session.getWorkspace().getNamespaceRegistry();
        nsReg.registerNamespace(prefix, uri);
    }

    public void unregisterNamespace(SessionInfo sessionInfo, String uri) throws NamespaceException, UnsupportedRepositoryOperationException, AccessDeniedException, RepositoryException {
        Session session = this.getSessionInfoImpl(sessionInfo).getSession();
        NamespaceRegistry nsReg = session.getWorkspace().getNamespaceRegistry();
        nsReg.unregisterNamespace(nsReg.getPrefix(uri));
    }

    public Iterator getQNodeTypeDefinitions(SessionInfo sessionInfo) throws RepositoryException {
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        NodeTypeManager ntMgr = sInfo.getSession().getWorkspace().getNodeTypeManager();
        ArrayList<QNodeTypeDefinitionImpl> nodeTypes = new ArrayList<QNodeTypeDefinitionImpl>();
        try {
            NodeTypeIterator it = ntMgr.getAllNodeTypes();
            while (it.hasNext()) {
                NodeType nt = it.nextNodeType();
                nodeTypes.add(new QNodeTypeDefinitionImpl(nt, sInfo.getNamePathResolver(), this.getQValueFactory()));
            }
        }
        catch (NameException e) {
            throw new RepositoryException((Throwable)e);
        }
        return nodeTypes.iterator();
    }

    public Iterator getQNodeTypeDefinitions(SessionInfo sessionInfo, Name[] nodetypeNames) throws RepositoryException {
        SessionInfoImpl sInfo = this.getSessionInfoImpl(sessionInfo);
        NodeTypeManager ntMgr = sInfo.getSession().getWorkspace().getNodeTypeManager();
        ArrayList<QNodeTypeDefinitionImpl> defs = new ArrayList<QNodeTypeDefinitionImpl>();
        int i = 0;
        while (i < nodetypeNames.length) {
            try {
                String ntName = sInfo.getNamePathResolver().getJCRName(nodetypeNames[i]);
                NodeType nt = ntMgr.getNodeType(ntName);
                defs.add(new QNodeTypeDefinitionImpl(nt, sInfo.getNamePathResolver(), this.getQValueFactory()));
                NodeType[] supertypes = nt.getSupertypes();
                int st = 0;
                while (st < supertypes.length) {
                    defs.add(new QNodeTypeDefinitionImpl(supertypes[i], sInfo.getNamePathResolver(), this.getQValueFactory()));
                    ++st;
                }
            }
            catch (NameException e) {
                throw new RepositoryException((Throwable)e);
            }
            ++i;
        }
        return defs.iterator();
    }

    private SessionInfoImpl getSessionInfoImpl(SessionInfo sessionInfo) throws RepositoryException {
        if (sessionInfo instanceof SessionInfoImpl) {
            return (SessionInfoImpl)sessionInfo;
        }
        throw new RepositoryException("Unknown SessionInfo implementation: " + sessionInfo.getClass().getName());
    }

    private EventSubscription getEventSubscription(Subscription subscription) throws RepositoryException {
        if (subscription instanceof EventSubscription) {
            return (EventSubscription)subscription;
        }
        throw new RepositoryException("Unknown Subscription implementation: " + subscription.getClass().getName());
    }

    private String getDestinationPath(NodeId destParentNodeId, Name destName, SessionInfoImpl sessionInfo) throws RepositoryException {
        StringBuffer destPath = new StringBuffer(this.pathForId((ItemId)destParentNodeId, sessionInfo));
        if (destPath.length() > 1) {
            destPath.append("/");
        }
        destPath.append(sessionInfo.getNamePathResolver().getJCRName(destName));
        return destPath.toString();
    }

    private String pathForId(ItemId id, SessionInfoImpl sessionInfo) throws RepositoryException {
        Session session = sessionInfo.getSession();
        StringBuffer path = new StringBuffer();
        if (id.getUniqueID() != null) {
            path.append(session.getNodeByUUID(id.getUniqueID()).getPath());
        } else {
            path.append("/");
        }
        if (id.getPath() == null) {
            return path.toString();
        }
        if (id.getPath().isAbsolute()) {
            if (path.length() == 1) {
                path.setLength(0);
            }
        } else if (path.length() > 1) {
            path.append("/");
        }
        path.append(sessionInfo.getNamePathResolver().getJCRPath(id.getPath()));
        return path.toString();
    }

    private Node getParent(NodeId parentId, SessionInfoImpl sessionInfo) throws InvalidItemStateException, RepositoryException {
        try {
            return this.getNode(parentId, sessionInfo);
        }
        catch (PathNotFoundException e) {
            throw new InvalidItemStateException((Throwable)e);
        }
    }

    private Node getNode(NodeId id, SessionInfoImpl sessionInfo) throws ItemNotFoundException, PathNotFoundException, RepositoryException {
        Session session = sessionInfo.getSession();
        Node n = id.getUniqueID() != null ? session.getNodeByUUID(id.getUniqueID()) : session.getRootNode();
        Path path = id.getPath();
        if (path == null || path.denotesRoot()) {
            return n;
        }
        String jcrPath = sessionInfo.getNamePathResolver().getJCRPath(path);
        if (path.isAbsolute()) {
            jcrPath = jcrPath.substring(1, jcrPath.length());
        }
        return n.getNode(jcrPath);
    }

    private Property getProperty(PropertyId id, SessionInfoImpl sessionInfo) throws ItemNotFoundException, PathNotFoundException, RepositoryException {
        Session session = sessionInfo.getSession();
        Node n = id.getUniqueID() != null ? session.getNodeByUUID(id.getUniqueID()) : session.getRootNode();
        Path path = id.getPath();
        String jcrPath = sessionInfo.getNamePathResolver().getJCRPath(path);
        if (path.isAbsolute()) {
            jcrPath = jcrPath.substring(1, jcrPath.length());
        }
        return n.getProperty(jcrPath);
    }

    private Query createQuery(Session session, String statement, String language, Map namespaces) throws InvalidQueryException, RepositoryException {
        QueryManager qMgr = session.getWorkspace().getQueryManager();
        Map previous = this.setNamespaceMappings(session, namespaces);
        try {
            Query query = qMgr.createQuery(statement, language);
            return query;
        }
        finally {
            this.setNamespaceMappings(session, previous);
        }
    }

    private Map setNamespaceMappings(Session session, Map namespaces) throws RepositoryException {
        HashMap<String, String> previous = new HashMap<String, String>();
        Iterator iterator = namespaces.entrySet().iterator();
        while (iterator.hasNext()) {
            String oldPrefix;
            Map.Entry entry = iterator.next();
            String uri = (String)entry.getValue();
            String prefix = (String)entry.getKey();
            if (prefix.equals(oldPrefix = session.getNamespacePrefix(uri))) continue;
            String oldURI = this.safeGetURI(session, prefix);
            if (oldURI != null) {
                int i = 2;
                String tmpPrefix = String.valueOf(oldPrefix) + i++;
                while (this.safeGetURI(session, tmpPrefix) != null || namespaces.containsKey(tmpPrefix)) {
                    tmpPrefix = String.valueOf(oldPrefix) + i++;
                }
                session.setNamespacePrefix(tmpPrefix, oldURI);
                previous.put(prefix, oldURI);
            }
            session.setNamespacePrefix(prefix, uri);
            previous.put(oldPrefix, uri);
        }
        return previous;
    }

    private String safeGetURI(Session session, String prefix) throws RepositoryException {
        try {
            return session.getNamespaceURI(prefix);
        }
        catch (NamespaceException e) {
            return null;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object executeWithLocalEvents(Callable call, SessionInfoImpl sInfo) throws RepositoryException {
        if (this.supportsObservation == false) return call.run();
        subscr = sInfo.getSubscriptions();
        if (subscr.size() == 0) return call.run();
        obsMgr = sInfo.getSession().getWorkspace().getObservationManager();
        listeners = new ArrayList<EventListener>(subscr.size());
        try {
            it = subscr.iterator();
            while (it.hasNext()) {
                s = (EventSubscription)it.next();
                listener = s.getLocalEventListener();
                listeners.add(listener);
                obsMgr.addEventListener(listener, 31, "/", true, null, null, false);
            }
            var10_9 = call.run();
            return var10_9;
        }
        finally {
            it = listeners.iterator();
            ** while (it.hasNext())
        }
lbl-1000:
        // 1 sources

        {
            try {
                obsMgr.removeEventListener((EventListener)it.next());
            }
            catch (RepositoryException var12_12) {
                // empty catch block
            }
            continue;
        }
lbl26:
        // 1 sources

        return var10_9;
    }

    static /* synthetic */ Node access$0(RepositoryServiceImpl repositoryServiceImpl, NodeId nodeId, SessionInfoImpl sessionInfoImpl) throws InvalidItemStateException, RepositoryException {
        return repositoryServiceImpl.getParent(nodeId, sessionInfoImpl);
    }

    static /* synthetic */ Property access$1(RepositoryServiceImpl repositoryServiceImpl, PropertyId propertyId, SessionInfoImpl sessionInfoImpl) throws ItemNotFoundException, PathNotFoundException, RepositoryException {
        return repositoryServiceImpl.getProperty(propertyId, sessionInfoImpl);
    }

    static /* synthetic */ Object access$5(RepositoryServiceImpl repositoryServiceImpl, Callable callable, SessionInfoImpl sessionInfoImpl) throws RepositoryException {
        return repositoryServiceImpl.executeWithLocalEvents(callable, sessionInfoImpl);
    }

    private final class BatchImpl
    implements Batch {
        private final SessionInfoImpl sInfo;
        private final Set removedNodeIds = new HashSet();
        private boolean failed = false;

        BatchImpl(SessionInfoImpl sInfo) {
            this.sInfo = sInfo;
        }

        public void addNode(NodeId parentId, Name nodeName, Name nodetypeName, String uuid) throws RepositoryException {
            this.executeGuarded(new Callable(this, parentId, nodeName, nodetypeName, uuid){
                final /* synthetic */ BatchImpl this$1;
                private final /* synthetic */ NodeId val$parentId;
                private final /* synthetic */ Name val$nodeName;
                private final /* synthetic */ Name val$nodetypeName;
                private final /* synthetic */ String val$uuid;
                {
                    this.this$1 = batchImpl;
                    this.val$parentId = nodeId;
                    this.val$nodeName = name;
                    this.val$nodetypeName = name2;
                    this.val$uuid = string;
                }

                public Object run() throws RepositoryException {
                    Session s = BatchImpl.access$0(this.this$1).getSession();
                    Node parent = RepositoryServiceImpl.access$0(BatchImpl.access$5(this.this$1), this.val$parentId, BatchImpl.access$0(this.this$1));
                    String jcrName = BatchImpl.access$1(this.this$1, this.val$nodeName);
                    String ntName = BatchImpl.access$1(this.this$1, this.val$nodetypeName);
                    if (this.val$uuid == null) {
                        if (ntName == null) {
                            parent.addNode(jcrName);
                        } else {
                            parent.addNode(jcrName, ntName);
                        }
                    } else {
                        String xml = BatchImpl.access$2(this.this$1, jcrName, ntName, this.val$uuid);
                        ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());
                        try {
                            s.importXML(parent.getPath(), (InputStream)in, 3);
                        }
                        catch (IOException e) {
                            throw new RepositoryException(e.getMessage(), (Throwable)e);
                        }
                    }
                    return null;
                }
            });
        }

        public void addProperty(NodeId parentId, Name propertyName, QValue value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, PathNotFoundException, ItemExistsException, AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
            this.executeGuarded(new Callable(this, parentId, value, propertyName){
                final /* synthetic */ BatchImpl this$1;
                private final /* synthetic */ NodeId val$parentId;
                private final /* synthetic */ QValue val$value;
                private final /* synthetic */ Name val$propertyName;
                {
                    this.this$1 = batchImpl;
                    this.val$parentId = nodeId;
                    this.val$value = qValue;
                    this.val$propertyName = name;
                }

                public Object run() throws RepositoryException {
                    Session s = BatchImpl.access$0(this.this$1).getSession();
                    Node parent = RepositoryServiceImpl.access$0(BatchImpl.access$5(this.this$1), this.val$parentId, BatchImpl.access$0(this.this$1));
                    Value jcrValue = ValueFormat.getJCRValue((QValue)this.val$value, (NamePathResolver)BatchImpl.access$0(this.this$1).getNamePathResolver(), (ValueFactory)s.getValueFactory());
                    parent.setProperty(BatchImpl.access$1(this.this$1, this.val$propertyName), jcrValue);
                    return null;
                }
            });
        }

        public void addProperty(NodeId parentId, Name propertyName, QValue[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, PathNotFoundException, ItemExistsException, AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
            this.executeGuarded(new Callable(this, parentId, values, propertyName){
                final /* synthetic */ BatchImpl this$1;
                private final /* synthetic */ NodeId val$parentId;
                private final /* synthetic */ QValue[] val$values;
                private final /* synthetic */ Name val$propertyName;
                {
                    this.this$1 = batchImpl;
                    this.val$parentId = nodeId;
                    this.val$values = qValueArray;
                    this.val$propertyName = name;
                }

                public Object run() throws RepositoryException {
                    Session s = BatchImpl.access$0(this.this$1).getSession();
                    Node n = RepositoryServiceImpl.access$0(BatchImpl.access$5(this.this$1), this.val$parentId, BatchImpl.access$0(this.this$1));
                    Value[] jcrValues = new Value[this.val$values.length];
                    int i = 0;
                    while (i < jcrValues.length) {
                        jcrValues[i] = ValueFormat.getJCRValue((QValue)this.val$values[i], (NamePathResolver)BatchImpl.access$0(this.this$1).getNamePathResolver(), (ValueFactory)s.getValueFactory());
                        ++i;
                    }
                    n.setProperty(BatchImpl.access$1(this.this$1, this.val$propertyName), jcrValues);
                    return null;
                }
            });
        }

        public void setValue(PropertyId propertyId, QValue value) throws RepositoryException {
            this.executeGuarded(new Callable(this, value, propertyId){
                final /* synthetic */ BatchImpl this$1;
                private final /* synthetic */ QValue val$value;
                private final /* synthetic */ PropertyId val$propertyId;
                {
                    this.this$1 = batchImpl;
                    this.val$value = qValue;
                    this.val$propertyId = propertyId;
                }

                public Object run() throws RepositoryException {
                    Session s = BatchImpl.access$0(this.this$1).getSession();
                    Value jcrValue = ValueFormat.getJCRValue((QValue)this.val$value, (NamePathResolver)BatchImpl.access$0(this.this$1).getNamePathResolver(), (ValueFactory)s.getValueFactory());
                    RepositoryServiceImpl.access$1(BatchImpl.access$5(this.this$1), this.val$propertyId, BatchImpl.access$0(this.this$1)).setValue(jcrValue);
                    return null;
                }
            });
        }

        public void setValue(PropertyId propertyId, QValue[] values) throws RepositoryException {
            this.executeGuarded(new Callable(this, values, propertyId){
                final /* synthetic */ BatchImpl this$1;
                private final /* synthetic */ QValue[] val$values;
                private final /* synthetic */ PropertyId val$propertyId;
                {
                    this.this$1 = batchImpl;
                    this.val$values = qValueArray;
                    this.val$propertyId = propertyId;
                }

                public Object run() throws RepositoryException {
                    Session s = BatchImpl.access$0(this.this$1).getSession();
                    Value[] jcrValues = new Value[this.val$values.length];
                    int i = 0;
                    while (i < jcrValues.length) {
                        jcrValues[i] = ValueFormat.getJCRValue((QValue)this.val$values[i], (NamePathResolver)BatchImpl.access$0(this.this$1).getNamePathResolver(), (ValueFactory)s.getValueFactory());
                        ++i;
                    }
                    RepositoryServiceImpl.access$1(BatchImpl.access$5(this.this$1), this.val$propertyId, BatchImpl.access$0(this.this$1)).setValue(jcrValues);
                    return null;
                }
            });
        }

        public void remove(ItemId itemId) throws RepositoryException {
            this.executeGuarded(new Callable(this, itemId){
                final /* synthetic */ BatchImpl this$1;
                private final /* synthetic */ ItemId val$itemId;
                {
                    this.this$1 = batchImpl;
                    this.val$itemId = itemId;
                }

                public Object run() throws RepositoryException {
                    try {
                        if (this.val$itemId.denotesNode()) {
                            NodeId nodeId = BatchImpl.access$3(this.this$1, this.val$itemId);
                            RepositoryServiceImpl.access$2(BatchImpl.access$5(this.this$1), nodeId, BatchImpl.access$0(this.this$1)).remove();
                        } else {
                            RepositoryServiceImpl.access$1(BatchImpl.access$5(this.this$1), (PropertyId)this.val$itemId, BatchImpl.access$0(this.this$1)).remove();
                        }
                    }
                    catch (ItemNotFoundException e) {
                        throw new InvalidItemStateException((Throwable)e);
                    }
                    catch (PathNotFoundException e) {
                        throw new InvalidItemStateException((Throwable)e);
                    }
                    return null;
                }
            });
        }

        private NodeId calcRemoveNodeId(ItemId itemId) throws MalformedPathException {
            NodeId nodeId = (NodeId)itemId;
            Path p = itemId.getPath();
            if (p != null) {
                this.removedNodeIds.add(itemId);
                int index = p.getNameElement().getNormalizedIndex();
                if (index > 1) {
                    Path.Element[] elems = p.getElements();
                    PathBuilder pb = new PathBuilder();
                    int i = 0;
                    while (i <= elems.length - 2) {
                        pb.addLast(elems[i]);
                        ++i;
                    }
                    pb.addLast(p.getNameElement().getName(), index - 1);
                    NodeId prevSibling = RepositoryServiceImpl.this.idFactory.createNodeId(itemId.getUniqueID(), pb.getPath());
                    if (this.removedNodeIds.contains(prevSibling)) {
                        nodeId = prevSibling;
                    }
                }
            }
            return nodeId;
        }

        public void reorderNodes(NodeId parentId, NodeId srcNodeId, NodeId beforeNodeId) throws RepositoryException {
            this.executeGuarded(new Callable(this, parentId, srcNodeId, beforeNodeId){
                final /* synthetic */ BatchImpl this$1;
                private final /* synthetic */ NodeId val$parentId;
                private final /* synthetic */ NodeId val$srcNodeId;
                private final /* synthetic */ NodeId val$beforeNodeId;
                {
                    this.this$1 = batchImpl;
                    this.val$parentId = nodeId;
                    this.val$srcNodeId = nodeId2;
                    this.val$beforeNodeId = nodeId3;
                }

                public Object run() throws RepositoryException {
                    Node parent = RepositoryServiceImpl.access$0(BatchImpl.access$5(this.this$1), this.val$parentId, BatchImpl.access$0(this.this$1));
                    Node srcNode = RepositoryServiceImpl.access$2(BatchImpl.access$5(this.this$1), this.val$srcNodeId, BatchImpl.access$0(this.this$1));
                    Node beforeNode = null;
                    if (this.val$beforeNodeId != null) {
                        beforeNode = RepositoryServiceImpl.access$2(BatchImpl.access$5(this.this$1), this.val$beforeNodeId, BatchImpl.access$0(this.this$1));
                    }
                    String srcPath = srcNode.getName();
                    if (srcNode.getIndex() > 1) {
                        srcPath = String.valueOf(srcPath) + "[" + srcNode.getIndex() + "]";
                    }
                    String beforePath = null;
                    if (beforeNode != null) {
                        beforePath = beforeNode.getName();
                        if (beforeNode.getIndex() > 1) {
                            beforePath = String.valueOf(beforePath) + "[" + beforeNode.getIndex() + "]";
                        }
                    }
                    parent.orderBefore(srcPath, beforePath);
                    return null;
                }
            });
        }

        public void setMixins(NodeId nodeId, Name[] mixinNodeTypeIds) throws RepositoryException {
            this.executeGuarded(new Callable(this, mixinNodeTypeIds, nodeId){
                final /* synthetic */ BatchImpl this$1;
                private final /* synthetic */ Name[] val$mixinNodeTypeIds;
                private final /* synthetic */ NodeId val$nodeId;
                {
                    this.this$1 = batchImpl;
                    this.val$mixinNodeTypeIds = nameArray;
                    this.val$nodeId = nodeId;
                }

                public Object run() throws RepositoryException {
                    HashSet<String> mixinNames = new HashSet<String>();
                    int i = 0;
                    while (i < this.val$mixinNodeTypeIds.length) {
                        mixinNames.add(BatchImpl.access$1(this.this$1, this.val$mixinNodeTypeIds[i]));
                        ++i;
                    }
                    Node n = RepositoryServiceImpl.access$2(BatchImpl.access$5(this.this$1), this.val$nodeId, BatchImpl.access$0(this.this$1));
                    NodeType[] nts = n.getMixinNodeTypes();
                    HashSet<String> currentMixins = new HashSet<String>();
                    int i2 = 0;
                    while (i2 < nts.length) {
                        currentMixins.add(nts[i2].getName());
                        ++i2;
                    }
                    HashSet<E> remove = new HashSet<E>(currentMixins);
                    remove.removeAll(mixinNames);
                    mixinNames.removeAll(currentMixins);
                    Iterator<E> it = remove.iterator();
                    while (it.hasNext()) {
                        n.removeMixin((String)it.next());
                    }
                    it = mixinNames.iterator();
                    while (it.hasNext()) {
                        n.addMixin((String)it.next());
                    }
                    return null;
                }
            });
        }

        public void move(NodeId srcNodeId, NodeId destParentNodeId, Name destName) throws RepositoryException {
            this.executeGuarded(new Callable(this, srcNodeId, destParentNodeId, destName){
                final /* synthetic */ BatchImpl this$1;
                private final /* synthetic */ NodeId val$srcNodeId;
                private final /* synthetic */ NodeId val$destParentNodeId;
                private final /* synthetic */ Name val$destName;
                {
                    this.this$1 = batchImpl;
                    this.val$srcNodeId = nodeId;
                    this.val$destParentNodeId = nodeId2;
                    this.val$destName = name;
                }

                public Object run() throws RepositoryException {
                    String srcPath = RepositoryServiceImpl.access$4(BatchImpl.access$5(this.this$1), (ItemId)this.val$srcNodeId, BatchImpl.access$0(this.this$1));
                    String destPath = RepositoryServiceImpl.access$4(BatchImpl.access$5(this.this$1), (ItemId)this.val$destParentNodeId, BatchImpl.access$0(this.this$1));
                    if (destPath.length() > 1) {
                        destPath = String.valueOf(destPath) + "/";
                    }
                    destPath = String.valueOf(destPath) + BatchImpl.access$1(this.this$1, this.val$destName);
                    BatchImpl.access$0(this.this$1).getSession().move(srcPath, destPath);
                    return null;
                }
            });
        }

        private void executeGuarded(Callable call) throws RepositoryException {
            if (this.failed) {
                return;
            }
            try {
                call.run();
            }
            catch (RepositoryException e) {
                this.failed = true;
                this.sInfo.getSession().refresh(false);
                throw e;
            }
            catch (RuntimeException e) {
                this.failed = true;
                this.sInfo.getSession().refresh(false);
                throw e;
            }
        }

        private String getJcrName(Name name) throws RepositoryException {
            if (name == null) {
                return null;
            }
            return this.sInfo.getNamePathResolver().getJCRName(name);
        }

        private String createXMLFragment(String nodeName, String ntName, String uuid) {
            StringBuffer xml = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            xml.append("<sv:node xmlns:jcr=\"http://www.jcp.org/jcr/1.0\" ");
            xml.append("xmlns:sv=\"http://www.jcp.org/jcr/sv/1.0\" ");
            xml.append("sv:name=\"").append(nodeName).append("\">");
            xml.append("<sv:property sv:name=\"jcr:primaryType\" sv:type=\"Name\">");
            xml.append("<sv:value>").append(ntName).append("</sv:value>");
            xml.append("</sv:property>");
            xml.append("<sv:property sv:name=\"jcr:uuid\" sv:type=\"String\">");
            xml.append("<sv:value>").append(uuid).append("</sv:value>");
            xml.append("</sv:property>");
            xml.append("</sv:node>");
            return xml.toString();
        }

        private void end() throws AccessDeniedException, ItemExistsException, ConstraintViolationException, InvalidItemStateException, VersionException, LockException, NoSuchNodeTypeException, RepositoryException {
            this.executeGuarded(new Callable(this){
                final /* synthetic */ BatchImpl this$1;
                {
                    this.this$1 = batchImpl;
                }

                public Object run() throws RepositoryException {
                    RepositoryServiceImpl.access$5(BatchImpl.access$5(this.this$1), new Callable(this){
                        final /* synthetic */ 10 this$2;
                        {
                            this.this$2 = var1_1;
                        }

                        public Object run() throws RepositoryException {
                            BatchImpl.access$0(10.access$0(this.this$2)).getSession().save();
                            return null;
                        }
                    }, BatchImpl.access$0(this.this$1));
                    return null;
                }

                static /* synthetic */ BatchImpl access$0(10 var0) {
                    return var0.this$1;
                }
            });
        }

        static /* synthetic */ SessionInfoImpl access$0(BatchImpl batchImpl) {
            return batchImpl.sInfo;
        }

        static /* synthetic */ String access$1(BatchImpl batchImpl, Name name) throws RepositoryException {
            return batchImpl.getJcrName(name);
        }

        static /* synthetic */ String access$2(BatchImpl batchImpl, String string, String string2, String string3) {
            return batchImpl.createXMLFragment(string, string2, string3);
        }

        static /* synthetic */ NodeId access$3(BatchImpl batchImpl, ItemId itemId) throws MalformedPathException {
            return batchImpl.calcRemoveNodeId(itemId);
        }

        static /* synthetic */ RepositoryServiceImpl access$5(BatchImpl batchImpl) {
            return batchImpl.RepositoryServiceImpl.this;
        }
    }

    private static interface Callable {
        public Object run() throws RepositoryException;
    }
}

