/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2jcr;

import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.Row;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.QueryResultRow;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.value.ValueFormat;
import org.apache.jackrabbit.spi2jcr.IdFactoryImpl;

class QueryResultRowImpl
implements QueryResultRow {
    private final NodeId nodeId;
    private final double score;
    private final QValue[] values;

    public QueryResultRowImpl(Row row, String[] columnNames, String scoreName, String pathName, IdFactoryImpl idFactory, NamePathResolver resolver, QValueFactory qValueFactory) throws RepositoryException {
        Path path;
        String jcrPath = row.getValue(pathName).getString();
        try {
            path = resolver.getQPath(jcrPath);
        }
        catch (NameException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        this.nodeId = idFactory.createNodeId(null, path);
        this.score = row.getValue(scoreName).getDouble();
        this.values = new QValue[columnNames.length];
        int i = 0;
        while (i < columnNames.length) {
            Value v = row.getValue(columnNames[i]);
            this.values[i] = v == null ? null : ValueFormat.getQValue((Value)v, (NamePathResolver)resolver, (QValueFactory)qValueFactory);
            ++i;
        }
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public double getScore() {
        return this.score;
    }

    public QValue[] getValues() {
        QValue[] vals = new QValue[this.values.length];
        System.arraycopy(this.values, 0, vals, 0, this.values.length);
        return vals;
    }
}

