/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2jcr;

import java.util.NoSuchElementException;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import org.apache.jackrabbit.commons.iterator.RangeIteratorAdapter;
import org.apache.jackrabbit.commons.iterator.RangeIteratorDecorator;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.QueryInfo;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi2jcr.IdFactoryImpl;
import org.apache.jackrabbit.spi2jcr.QueryResultRowImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class QueryInfoImpl
implements QueryInfo {
    private static final Logger log;
    private final QueryResult result;
    private final IdFactoryImpl idFactory;
    private final NamePathResolver resolver;
    private final QValueFactory qValueFactory;
    private final Name[] columnNames;
    private final String scoreName;
    private final String pathName;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.spi2jcr.QueryInfoImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    public QueryInfoImpl(QueryResult result, IdFactoryImpl idFactory, NamePathResolver resolver, QValueFactory qValueFactory) throws RepositoryException {
        this.result = result;
        this.idFactory = idFactory;
        this.resolver = resolver;
        this.qValueFactory = qValueFactory;
        String[] jcrNames = result.getColumnNames();
        this.columnNames = new Name[jcrNames.length];
        try {
            int i = 0;
            while (i < jcrNames.length) {
                this.columnNames[i] = resolver.getQName(jcrNames[i]);
                ++i;
            }
            this.scoreName = resolver.getJCRName(NameConstants.JCR_SCORE);
            this.pathName = resolver.getJCRName(NameConstants.JCR_PATH);
        }
        catch (NameException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    public RangeIterator getRows() {
        try {
            final String[] columnJcrNames = this.result.getColumnNames();
            return new RangeIteratorDecorator((RangeIterator)this.result.getRows()){

                public Object next() {
                    try {
                        return new QueryResultRowImpl((Row)super.next(), columnJcrNames, QueryInfoImpl.this.scoreName, QueryInfoImpl.this.pathName, QueryInfoImpl.this.idFactory, QueryInfoImpl.this.resolver, QueryInfoImpl.this.qValueFactory);
                    }
                    catch (RepositoryException e) {
                        log.warn("Exception when creating QueryResultRowImpl: " + e.getMessage(), (Throwable)e);
                        throw new NoSuchElementException();
                    }
                }
            };
        }
        catch (RepositoryException e) {
            return RangeIteratorAdapter.EMPTY;
        }
    }

    public Name[] getColumnNames() {
        Name[] names = new Name[this.columnNames.length];
        System.arraycopy(this.columnNames, 0, names, 0, this.columnNames.length);
        return names;
    }
}

