/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2jcr;

import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.apache.jackrabbit.spi.IdFactory;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.PathFactory;
import org.apache.jackrabbit.spi.PropertyId;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.identifier.AbstractIdFactory;
import org.apache.jackrabbit.spi.commons.name.PathBuilder;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;

class IdFactoryImpl
extends AbstractIdFactory {
    private static final IdFactory INSTANCE = new IdFactoryImpl();

    private IdFactoryImpl() {
    }

    public static IdFactory getInstance() {
        return INSTANCE;
    }

    protected PathFactory getPathFactory() {
        return PathFactoryImpl.getInstance();
    }

    public NodeId createNodeId(Node node, NamePathResolver resolver) throws RepositoryException {
        PathBuilder builder = new PathBuilder();
        int pathElements = 0;
        String uniqueId = null;
        while (uniqueId == null) {
            try {
                uniqueId = node.getUUID();
            }
            catch (UnsupportedRepositoryOperationException e) {
                Name name;
                ++pathElements;
                String jcrName = node.getName();
                if (jcrName.equals("")) {
                    builder.addRoot();
                    break;
                }
                try {
                    name = resolver.getQName(node.getName());
                }
                catch (NameException ex) {
                    throw new RepositoryException(ex.getMessage(), (Throwable)ex);
                }
                if (node.getIndex() == 1) {
                    builder.addFirst(name);
                } else {
                    builder.addFirst(name, node.getIndex());
                }
                node = node.getParent();
            }
        }
        if (pathElements > 0) {
            return this.createNodeId(uniqueId, builder.getPath());
        }
        return this.createNodeId(uniqueId);
    }

    public PropertyId createPropertyId(Property property, NamePathResolver resolver) throws RepositoryException {
        Name name;
        Node parent = property.getParent();
        NodeId nodeId = this.createNodeId(parent, resolver);
        String jcrName = property.getName();
        try {
            name = resolver.getQName(jcrName);
        }
        catch (NameException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        return this.createPropertyId(nodeId, name);
    }
}

