/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2dav;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi2dav.CredentialsWrapper;

public class SessionInfoImpl
extends org.apache.jackrabbit.spi.commons.SessionInfoImpl {
    private final CredentialsWrapper credentials;
    private final Set sessionScopedTokens = new HashSet();
    private String lastBatchId;
    private NamePathResolver resolver;

    SessionInfoImpl(CredentialsWrapper creds, String workspaceName) {
        this.credentials = creds;
        super.setWorkspacename(workspaceName);
    }

    public String getUserID() {
        return this.credentials.getUserId();
    }

    CredentialsWrapper getCredentials() {
        return this.credentials;
    }

    String getLastBatchId() {
        return this.lastBatchId;
    }

    void setLastBatchId(String batchId) {
        this.lastBatchId = batchId;
    }

    NamePathResolver getNamePathResolver() {
        return this.resolver;
    }

    void setNamePathResolver(NamePathResolver resolver) {
        this.resolver = resolver;
    }

    String[] getAllLockTokens() {
        HashSet<String> s = new HashSet<String>(Arrays.asList(this.getLockTokens()));
        s.addAll(this.sessionScopedTokens);
        return s.toArray(new String[s.size()]);
    }

    void addLockToken(String token, boolean sessionScoped) {
        if (sessionScoped) {
            this.sessionScopedTokens.add(token);
        } else {
            super.addLockToken(token);
        }
    }

    void removeLockToken(String token, boolean sessionScoped) {
        if (sessionScoped) {
            this.sessionScopedTokens.remove(token);
        } else {
            super.removeLockToken(token);
        }
    }
}

