/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2dav;

import java.lang.reflect.Constructor;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.client.methods.DavMethod;
import org.apache.jackrabbit.webdav.client.methods.DeleteMethod;
import org.apache.jackrabbit.webdav.client.methods.MkColMethod;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExceptionConverter {
    private static Logger log = LoggerFactory.getLogger(ExceptionConverter.class);

    private ExceptionConverter() {
    }

    public static RepositoryException generate(DavException davExc) throws RepositoryException {
        return ExceptionConverter.generate(davExc, null);
    }

    public static RepositoryException generate(DavException davExc, DavMethod method) throws RepositoryException {
        String msg = davExc.getMessage();
        if (davExc.hasErrorCondition()) {
            try {
                Element error = davExc.toXml(DomUtil.BUILDER_FACTORY.newDocumentBuilder().newDocument());
                if (DomUtil.matches((Node)error, (String)"error", (Namespace)DavConstants.NAMESPACE) && DomUtil.hasChildElement((Node)error, (String)"exception", null)) {
                    Class<?> cl;
                    Constructor<?> excConstr;
                    Element exc = DomUtil.getChildElement((Node)error, (String)"exception", null);
                    if (DomUtil.hasChildElement((Node)exc, (String)"message", null)) {
                        msg = DomUtil.getChildText((Element)exc, (String)"message", null);
                    }
                    if (DomUtil.hasChildElement((Node)exc, (String)"class", null) && (excConstr = (cl = Class.forName(DomUtil.getChildText((Element)exc, (String)"class", null))).getConstructor(String.class)) != null) {
                        Object o = excConstr.newInstance(msg);
                        if (o instanceof RepositoryException) {
                            return (RepositoryException)((Object)o);
                        }
                        if (o instanceof Exception) {
                            return new RepositoryException(msg, (Throwable)((Exception)o));
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        switch (davExc.getErrorCode()) {
            case 404: {
                if (method != null && (method instanceof DeleteMethod || method instanceof MkColMethod || method instanceof PutMethod)) {
                    throw new InvalidItemStateException(msg, (Throwable)davExc);
                }
                return new ItemNotFoundException(msg, (Throwable)davExc);
            }
            case 423: {
                return new LockException(msg, (Throwable)davExc);
            }
            case 405: {
                return new ConstraintViolationException(msg, (Throwable)davExc);
            }
            case 409: {
                return new InvalidItemStateException(msg, (Throwable)davExc);
            }
            case 412: {
                return new LockException(msg, (Throwable)davExc);
            }
            case 501: {
                if (method != null) {
                    throw new UnsupportedOperationException("Missing implementation: Method " + method + " could not be executed", davExc);
                }
                throw new UnsupportedOperationException("Missing implementation", davExc);
            }
        }
        return new RepositoryException(msg, (Throwable)davExc);
    }
}

