/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi.commons.nodetype;

import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.spi.commons.nodetype.BooleanConstraint;
import org.apache.jackrabbit.spi.commons.nodetype.DateConstraint;
import org.apache.jackrabbit.spi.commons.nodetype.InvalidConstraintException;
import org.apache.jackrabbit.spi.commons.nodetype.NameConstraint;
import org.apache.jackrabbit.spi.commons.nodetype.NumericConstraint;
import org.apache.jackrabbit.spi.commons.nodetype.PathConstraint;
import org.apache.jackrabbit.spi.commons.nodetype.ReferenceConstraint;
import org.apache.jackrabbit.spi.commons.nodetype.StringConstraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ValueConstraint {
    protected static Logger log;
    public static final ValueConstraint[] EMPTY_ARRAY;
    static final NameFactory NAME_FACTORY;
    private final String qualifiedDefinition;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.spi.commons.nodetype.ValueConstraint");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
        EMPTY_ARRAY = new ValueConstraint[0];
        NAME_FACTORY = NameFactoryImpl.getInstance();
    }

    protected ValueConstraint(String qualifiedDefinition) {
        this.qualifiedDefinition = qualifiedDefinition;
    }

    public String getDefinition(NamePathResolver resolver) {
        return this.qualifiedDefinition;
    }

    public String getQualifiedDefinition() {
        return this.qualifiedDefinition;
    }

    abstract void check(QValue var1) throws ConstraintViolationException, RepositoryException;

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ValueConstraint) {
            return this.qualifiedDefinition.equals(((ValueConstraint)other).qualifiedDefinition);
        }
        return false;
    }

    public int hashCode() {
        return this.qualifiedDefinition.hashCode();
    }

    public static ValueConstraint create(int type, String qualifiedDefinition) throws InvalidConstraintException {
        if (qualifiedDefinition == null) {
            throw new IllegalArgumentException("illegal definition (null)");
        }
        switch (type) {
            case 1: {
                return new StringConstraint(qualifiedDefinition);
            }
            case 6: {
                return new BooleanConstraint(qualifiedDefinition);
            }
            case 2: {
                return new NumericConstraint(qualifiedDefinition);
            }
            case 5: {
                return new DateConstraint(qualifiedDefinition);
            }
            case 3: 
            case 4: {
                return new NumericConstraint(qualifiedDefinition);
            }
            case 7: {
                return NameConstraint.create(qualifiedDefinition);
            }
            case 8: {
                return PathConstraint.create(qualifiedDefinition);
            }
            case 9: {
                return ReferenceConstraint.create(qualifiedDefinition);
            }
        }
        throw new IllegalArgumentException("unknown/unsupported target type for constraint: " + PropertyType.nameFromValue((int)type));
    }

    public static ValueConstraint create(int type, String definition, NamePathResolver resolver) throws InvalidConstraintException {
        if (definition == null) {
            throw new IllegalArgumentException("Illegal definition (null) for ValueConstraint.");
        }
        switch (type) {
            case 1: {
                return new StringConstraint(definition);
            }
            case 6: {
                return new BooleanConstraint(definition);
            }
            case 2: {
                return new NumericConstraint(definition);
            }
            case 5: {
                return new DateConstraint(definition);
            }
            case 3: 
            case 4: {
                return new NumericConstraint(definition);
            }
            case 7: {
                return NameConstraint.create(definition, resolver);
            }
            case 8: {
                return PathConstraint.create(definition, resolver);
            }
            case 9: {
                return ReferenceConstraint.create(definition, resolver);
            }
        }
        throw new IllegalArgumentException("Unknown/unsupported target type for constraint: " + PropertyType.nameFromValue((int)type));
    }

    public static void checkValueConstraints(QPropertyDefinition pd, QValue[] values) throws ConstraintViolationException, RepositoryException {
        if (!pd.isMultiple() && values != null && values.length > 1) {
            throw new ConstraintViolationException("the property is not multi-valued");
        }
        String[] constraints = pd.getValueConstraints();
        if (constraints == null || constraints.length == 0) {
            return;
        }
        if (values != null && values.length > 0) {
            int i = 0;
            while (i < values.length) {
                boolean satisfied = false;
                ConstraintViolationException cve = null;
                int j = 0;
                while (j < constraints.length && !satisfied) {
                    try {
                        ValueConstraint cnstr = ValueConstraint.create(pd.getRequiredType(), constraints[j]);
                        cnstr.check(values[i]);
                        satisfied = true;
                    }
                    catch (ConstraintViolationException e) {
                        cve = e;
                    }
                    catch (InvalidConstraintException e) {
                        cve = new ConstraintViolationException(e.getMessage(), (Throwable)((Object)e));
                    }
                    ++j;
                }
                if (!satisfied) {
                    throw cve;
                }
                ++i;
            }
        }
    }
}

