/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi.commons.nodetype;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QItemDefinition;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;

public class NodeTypeDefDiff {
    public static final int NONE = 0;
    public static final int TRIVIAL = 1;
    public static final int MINOR = 2;
    public static final int MAJOR = 3;
    private final QNodeTypeDefinition oldDef;
    private final QNodeTypeDefinition newDef;
    private int type;
    private final List propDefDiffs = new ArrayList();
    private final List childNodeDefDiffs = new ArrayList();

    private NodeTypeDefDiff(QNodeTypeDefinition oldDef, QNodeTypeDefinition newDef) {
        this.oldDef = oldDef;
        this.newDef = newDef;
        this.init();
    }

    private void init() {
        if (this.oldDef.equals(this.newDef)) {
            this.type = 0;
        } else {
            this.type = 1;
            int tmpType = this.supertypesDiff();
            if (tmpType > this.type) {
                this.type = tmpType;
            }
            if ((tmpType = this.mixinFlagDiff()) > this.type) {
                this.type = tmpType;
            }
            if ((tmpType = this.buildPropDefDiffs()) > this.type) {
                this.type = tmpType;
            }
            if ((tmpType = this.buildChildNodeDefDiffs()) > this.type) {
                this.type = tmpType;
            }
        }
    }

    public static NodeTypeDefDiff create(QNodeTypeDefinition oldDef, QNodeTypeDefinition newDef) {
        if (oldDef == null || newDef == null) {
            throw new IllegalArgumentException("arguments can not be null");
        }
        if (!oldDef.getName().equals(newDef.getName())) {
            throw new IllegalArgumentException("at least node type names must be matching");
        }
        return new NodeTypeDefDiff(oldDef, newDef);
    }

    public boolean isModified() {
        return this.type != 0;
    }

    public boolean isTrivial() {
        return this.type == 1;
    }

    public boolean isMinor() {
        return this.type == 2;
    }

    public boolean isMajor() {
        return this.type == 3;
    }

    public int getType() {
        return this.type;
    }

    public int mixinFlagDiff() {
        return this.oldDef.isMixin() != this.newDef.isMixin() ? 3 : 0;
    }

    public int supertypesDiff() {
        return !Arrays.equals(this.oldDef.getSupertypes(), this.newDef.getSupertypes()) ? 3 : 0;
    }

    private int buildPropDefDiffs() {
        Name name;
        int maxType = 0;
        QPropertyDefinition[] pda1 = this.oldDef.getPropertyDefs();
        HashMap<Name, QPropertyDefinition> defs1 = new HashMap<Name, QPropertyDefinition>();
        int i = 0;
        while (i < pda1.length) {
            defs1.put(pda1[i].getName(), pda1[i]);
            ++i;
        }
        QPropertyDefinition[] pda2 = this.newDef.getPropertyDefs();
        HashMap<Name, QPropertyDefinition> defs2 = new HashMap<Name, QPropertyDefinition>();
        int i2 = 0;
        while (i2 < pda2.length) {
            defs2.put(pda2[i2].getName(), pda2[i2]);
            ++i2;
        }
        Iterator iter = defs1.keySet().iterator();
        while (iter.hasNext()) {
            QPropertyDefinition def2;
            name = (Name)iter.next();
            QPropertyDefinition def1 = (QPropertyDefinition)defs1.get(name);
            PropDefDiff diff = new PropDefDiff(def1, def2 = (QPropertyDefinition)defs2.get(name));
            if (diff.getType() > maxType) {
                maxType = diff.getType();
            }
            this.propDefDiffs.add(diff);
            defs2.remove(name);
        }
        iter = defs2.keySet().iterator();
        while (iter.hasNext()) {
            name = (Name)iter.next();
            QPropertyDefinition def = (QPropertyDefinition)defs2.get(name);
            PropDefDiff diff = new PropDefDiff(null, def);
            if (diff.getType() > maxType) {
                maxType = diff.getType();
            }
            this.propDefDiffs.add(diff);
        }
        return maxType;
    }

    private int buildChildNodeDefDiffs() {
        Name name;
        int maxType = 0;
        QNodeDefinition[] cnda1 = this.oldDef.getChildNodeDefs();
        HashMap<Name, QNodeDefinition> defs1 = new HashMap<Name, QNodeDefinition>();
        int i = 0;
        while (i < cnda1.length) {
            defs1.put(cnda1[i].getName(), cnda1[i]);
            ++i;
        }
        QNodeDefinition[] cnda2 = this.newDef.getChildNodeDefs();
        HashMap<Name, QNodeDefinition> defs2 = new HashMap<Name, QNodeDefinition>();
        int i2 = 0;
        while (i2 < cnda2.length) {
            defs2.put(cnda2[i2].getName(), cnda2[i2]);
            ++i2;
        }
        Iterator iter = defs1.keySet().iterator();
        while (iter.hasNext()) {
            QNodeDefinition def2;
            name = (Name)iter.next();
            QNodeDefinition def1 = (QNodeDefinition)defs1.get(name);
            ChildNodeDefDiff diff = new ChildNodeDefDiff(def1, def2 = (QNodeDefinition)defs2.get(name));
            if (diff.getType() > maxType) {
                maxType = diff.getType();
            }
            this.childNodeDefDiffs.add(diff);
            defs2.remove(name);
        }
        iter = defs2.keySet().iterator();
        while (iter.hasNext()) {
            name = (Name)iter.next();
            QNodeDefinition def = (QNodeDefinition)defs2.get(name);
            ChildNodeDefDiff diff = new ChildNodeDefDiff(null, def);
            if (diff.getType() > maxType) {
                maxType = diff.getType();
            }
            this.childNodeDefDiffs.add(diff);
        }
        return maxType;
    }

    public String toString() {
        String result = String.valueOf(this.getClass().getName()) + "[\n\tnodeTypeName=" + this.oldDef.getName();
        result = String.valueOf(result) + ",\n\tmixinFlagDiff=" + this.modificationTypeToString(this.mixinFlagDiff());
        result = String.valueOf(result) + ",\n\tsupertypesDiff=" + this.modificationTypeToString(this.supertypesDiff());
        result = String.valueOf(result) + ",\n\tpropertyDifferences=[\n";
        result = String.valueOf(result) + this.toString(this.propDefDiffs);
        result = String.valueOf(result) + "\t]";
        result = String.valueOf(result) + ",\n\tchildNodeDifferences=[\n";
        result = String.valueOf(result) + this.toString(this.childNodeDefDiffs);
        result = String.valueOf(result) + "\t]\n";
        result = String.valueOf(result) + "]\n";
        return result;
    }

    private String toString(List childItemDefDiffs) {
        String result = "";
        Iterator iter = childItemDefDiffs.iterator();
        while (iter.hasNext()) {
            ChildItemDefDiff propDefDiff = (ChildItemDefDiff)iter.next();
            result = String.valueOf(result) + "\t\t" + propDefDiff;
            if (iter.hasNext()) {
                result = String.valueOf(result) + ",";
            }
            result = String.valueOf(result) + "\n";
        }
        return result;
    }

    private String modificationTypeToString(int modifcationType) {
        String typeString = "unknown";
        switch (modifcationType) {
            case 0: {
                typeString = "NONE";
                break;
            }
            case 1: {
                typeString = "TRIVIAL";
                break;
            }
            case 2: {
                typeString = "MINOR";
                break;
            }
            case 3: {
                typeString = "MAJOR";
            }
        }
        return typeString;
    }

    abstract class ChildItemDefDiff {
        protected final QItemDefinition oldDef;
        protected final QItemDefinition newDef;
        protected int type;

        ChildItemDefDiff(QItemDefinition oldDef, QItemDefinition newDef) {
            this.oldDef = oldDef;
            this.newDef = newDef;
            this.init();
        }

        protected void init() {
            this.type = this.isAdded() ? (!this.newDef.isMandatory() ? 1 : 3) : (this.isRemoved() ? 3 : (this.oldDef.equals(this.newDef) ? 0 : (this.oldDef.isMandatory() != this.newDef.isMandatory() && this.newDef.isMandatory() ? 3 : (!this.oldDef.definesResidual() && this.newDef.definesResidual() ? 2 : (!this.oldDef.getName().equals(this.newDef.getName()) ? 3 : 1)))));
        }

        public int getType() {
            return this.type;
        }

        public boolean isAdded() {
            return this.oldDef == null && this.newDef != null;
        }

        public boolean isRemoved() {
            return this.oldDef != null && this.newDef == null;
        }

        public boolean isModified() {
            return this.oldDef != null && this.newDef != null && !this.oldDef.equals(this.newDef);
        }

        public String toString() {
            String typeString = NodeTypeDefDiff.this.modificationTypeToString(this.getType());
            String operationString = this.isAdded() ? "ADDED" : (this.isModified() ? "MODIFIED" : (this.isRemoved() ? "REMOVED" : "NONE"));
            QItemDefinition itemDefinition = this.oldDef != null ? this.oldDef : this.newDef;
            return String.valueOf(this.getClass().getName()) + "[itemName=" + itemDefinition.getName() + ", type=" + typeString + ", operation=" + operationString + "]";
        }
    }

    public class ChildNodeDefDiff
    extends ChildItemDefDiff {
        ChildNodeDefDiff(QNodeDefinition oldDef, QNodeDefinition newDef) {
            super((QItemDefinition)oldDef, (QItemDefinition)newDef);
        }

        public QNodeDefinition getOldDef() {
            return (QNodeDefinition)this.oldDef;
        }

        public QNodeDefinition getNewDef() {
            return (QNodeDefinition)this.newDef;
        }

        protected void init() {
            super.init();
            if (this.isModified() && this.type != 0 && this.type != 3) {
                List<Name> l2;
                List<Name> l1;
                boolean b2;
                boolean b1 = this.getOldDef().allowsSameNameSiblings();
                if (b1 != (b2 = this.getNewDef().allowsSameNameSiblings()) && !b2) {
                    this.type = 3;
                }
                if (this.type == 1 && !(l1 = Arrays.asList(this.getOldDef().getRequiredPrimaryTypes())).equals(l2 = Arrays.asList(this.getNewDef().getRequiredPrimaryTypes()))) {
                    this.type = l1.containsAll(l2) ? 2 : 3;
                }
            }
        }
    }

    public class PropDefDiff
    extends ChildItemDefDiff {
        PropDefDiff(QPropertyDefinition oldDef, QPropertyDefinition newDef) {
            super((QItemDefinition)oldDef, (QItemDefinition)newDef);
        }

        public QPropertyDefinition getOldDef() {
            return (QPropertyDefinition)this.oldDef;
        }

        public QPropertyDefinition getNewDef() {
            return (QPropertyDefinition)this.newDef;
        }

        protected void init() {
            super.init();
            if (this.isModified() && this.type != 0 && this.type != 3) {
                String[] vca1 = this.getOldDef().getValueConstraints();
                HashSet<String> set1 = new HashSet<String>();
                int i = 0;
                while (i < vca1.length) {
                    set1.add(vca1[i]);
                    ++i;
                }
                String[] vca2 = this.getNewDef().getValueConstraints();
                HashSet<String> set2 = new HashSet<String>();
                int i2 = 0;
                while (i2 < vca2.length) {
                    set2.add(vca2[i2]);
                    ++i2;
                }
                if (set1.isEmpty() && !set2.isEmpty()) {
                    this.type = 3;
                } else if (!set2.containsAll(set1) && !set2.isEmpty()) {
                    this.type = 3;
                }
                if (this.type == 1) {
                    boolean b2;
                    boolean b1;
                    int t2;
                    int t1 = this.getOldDef().getRequiredType();
                    if (t1 != (t2 = this.getNewDef().getRequiredType())) {
                        this.type = t2 == 0 ? 2 : 3;
                    }
                    if ((b1 = this.getOldDef().isMultiple()) != (b2 = this.getNewDef().isMultiple())) {
                        this.type = b2 ? 2 : 3;
                    }
                }
            }
        }
    }
}

