/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi.commons.name;

import java.util.LinkedList;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PathFactory;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;

public final class PathBuilder {
    private final PathFactory factory;
    private final LinkedList queue;
    boolean isNormalized = true;
    boolean leadingParent = true;

    public PathBuilder() {
        this(PathFactoryImpl.getInstance());
    }

    public PathBuilder(PathFactory factory) {
        this.factory = factory != null ? factory : PathFactoryImpl.getInstance();
        this.queue = new LinkedList();
    }

    public PathBuilder(Path.Element[] elements) {
        this();
        this.addAll(elements);
    }

    public PathBuilder(Path parent) {
        this();
        this.addAll(parent.getElements());
    }

    public void addRoot() {
        this.addFirst(this.factory.getRootElement());
    }

    public void addAll(Path.Element[] elements) {
        int i = 0;
        while (i < elements.length) {
            this.addLast(elements[i]);
            ++i;
        }
    }

    public void addFirst(Path.Element elem) {
        if (this.queue.isEmpty()) {
            this.isNormalized &= !elem.denotesCurrent();
            this.leadingParent = elem.denotesParent();
        } else {
            this.isNormalized &= !elem.denotesCurrent() && (!this.leadingParent || elem.denotesParent());
            this.leadingParent |= elem.denotesParent();
        }
        this.queue.addFirst(elem);
    }

    public void addFirst(Name name) {
        this.addFirst(this.factory.createElement(name));
    }

    public void addFirst(Name name, int index) {
        this.addFirst(this.factory.createElement(name, index));
    }

    public void addLast(Path.Element elem) {
        this.queue.addLast(elem);
        this.leadingParent &= elem.denotesParent();
        this.isNormalized &= !elem.denotesCurrent() && (this.leadingParent || !elem.denotesParent());
    }

    public void addLast(Name name) {
        this.addLast(this.factory.createElement(name));
    }

    public void addLast(Name name, int index) {
        this.addLast(this.factory.createElement(name, index));
    }

    public Path getPath() throws MalformedPathException {
        if (this.queue.size() == 0) {
            throw new MalformedPathException("empty path");
        }
        Path.Element[] elements = this.queue.toArray(new Path.Element[this.queue.size()]);
        return this.factory.create(elements);
    }
}

