/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi.commons.batch;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.spi.Batch;
import org.apache.jackrabbit.spi.ItemId;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.PropertyId;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.commons.batch.ChangeLog;
import org.apache.jackrabbit.spi.commons.batch.Operation;
import org.apache.jackrabbit.spi.commons.batch.Operations;

public class ChangeLogImpl
implements ChangeLog {
    protected final List operations = new LinkedList();

    public void addNode(NodeId parentId, Name nodeName, Name nodetypeName, String uuid) throws RepositoryException {
        this.addOperation(Operations.addNode(parentId, nodeName, nodetypeName, uuid));
    }

    public void addProperty(NodeId parentId, Name propertyName, QValue value) throws RepositoryException {
        this.addOperation(Operations.addProperty(parentId, propertyName, value));
    }

    public void addProperty(NodeId parentId, Name propertyName, QValue[] values) throws RepositoryException {
        this.addOperation(Operations.addProperty(parentId, propertyName, values));
    }

    public void move(NodeId srcNodeId, NodeId destParentNodeId, Name destName) throws RepositoryException {
        this.addOperation(Operations.move(srcNodeId, destParentNodeId, destName));
    }

    public void remove(ItemId itemId) throws RepositoryException {
        this.addOperation(Operations.remove(itemId));
    }

    public void reorderNodes(NodeId parentId, NodeId srcNodeId, NodeId beforeNodeId) throws RepositoryException {
        this.addOperation(Operations.reorderNodes(parentId, srcNodeId, beforeNodeId));
    }

    public void setMixins(NodeId nodeId, Name[] mixinNodeTypeNames) throws RepositoryException {
        this.addOperation(Operations.setMixins(nodeId, mixinNodeTypeNames));
    }

    public void setValue(PropertyId propertyId, QValue value) throws RepositoryException {
        this.addOperation(Operations.setValue(propertyId, value));
    }

    public void setValue(PropertyId propertyId, QValue[] values) throws RepositoryException {
        this.addOperation(Operations.setValue(propertyId, values));
    }

    public Batch apply(Batch batch) throws RepositoryException {
        if (batch == null) {
            throw new IllegalArgumentException("Batch must not be null");
        }
        Iterator it = this.operations.iterator();
        while (it.hasNext()) {
            Operation op = (Operation)it.next();
            op.apply(batch);
        }
        return batch;
    }

    protected void addOperation(Operation op) throws RepositoryException {
        this.operations.add(op);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        Iterator it = this.operations.iterator();
        while (it.hasNext()) {
            b.append(it.next());
            if (!it.hasNext()) continue;
            b.append(", ");
        }
        return b.toString();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof ChangeLogImpl) {
            return this.equals((ChangeLogImpl)other);
        }
        return false;
    }

    public boolean equals(ChangeLogImpl other) {
        return this.operations.equals(other.operations);
    }

    public int hashCode() {
        throw new IllegalArgumentException("Not hashable");
    }
}

