/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.ocm.reflection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sf.cglib.proxy.Enhancer;
import org.apache.commons.beanutils.ConstructorUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.jackrabbit.ocm.exception.JcrMappingException;

public abstract class ReflectionUtils {
    private static ClassLoader classLoader = ReflectionUtils.class.getClassLoader();
    private static HashMap<Class, Class> defaultImplementation = new HashMap();

    public static void setClassLoader(ClassLoader newClassLoader) {
        classLoader = newClassLoader;
    }

    public static ClassLoader getClassLoader() {
        return classLoader;
    }

    public static Object getNestedProperty(Object object, String fieldName) {
        if (null == object) {
            return null;
        }
        try {
            return PropertyUtils.getNestedProperty((Object)object, (String)fieldName);
        }
        catch (IllegalAccessException e) {
            throw new JcrMappingException("Cannot access property " + fieldName, e);
        }
        catch (InvocationTargetException e) {
            throw new JcrMappingException("Cannot access property " + fieldName, e);
        }
        catch (NoSuchMethodException e) {
            throw new JcrMappingException("Cannot access property " + fieldName, e);
        }
    }

    public static Class getPropertyType(Object object, String fieldName) {
        try {
            return PropertyUtils.getPropertyType((Object)object, (String)fieldName);
        }
        catch (Exception ex) {
            throw new JcrMappingException("Cannot access property " + fieldName, ex);
        }
    }

    public static Object newInstance(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception ex) {
            throw new JcrMappingException("Cannot create instance for class " + clazz, ex);
        }
    }

    public static Object invokeConstructor(String className, Object[] params) {
        try {
            Class converterClass = ReflectionUtils.forName(className);
            return ConstructorUtils.invokeConstructor((Class)converterClass, (Object[])params);
        }
        catch (Exception ex) {
            throw new JcrMappingException("Cannot create instance for class " + className, ex);
        }
    }

    public static void setNestedProperty(Object object, String fieldName, Object value) {
        try {
            PropertyUtils.setNestedProperty((Object)object, (String)fieldName, (Object)value);
        }
        catch (Exception ex) {
            String className = object == null ? "<null>" : object.getClass().getName();
            throw new JcrMappingException("Cannot set the field " + fieldName + " in the class : " + className, ex);
        }
    }

    public static Object newInstance(String clazz) {
        try {
            return ReflectionUtils.forName(clazz).newInstance();
        }
        catch (Exception ex) {
            throw new JcrMappingException("Cannot create instance for class " + clazz, ex);
        }
    }

    public static Class forName(String clazz) {
        try {
            return Class.forName(clazz, true, ReflectionUtils.getClassLoader());
        }
        catch (Exception ex) {
            throw new JcrMappingException("Cannot load class " + clazz, ex);
        }
    }

    public static boolean isProxy(Class beanClass) {
        return Enhancer.isEnhanced((Class)beanClass);
    }

    public static Class getBeanClass(Object bean) {
        Class<?> beanClass = bean.getClass();
        if (ReflectionUtils.isProxy(beanClass)) {
            return beanClass.getSuperclass();
        }
        return beanClass;
    }

    public static boolean implementsInterface(Class clazz, Class interfaceClass) {
        Class<?>[] arr$;
        int len$;
        int i$;
        if (clazz.getInterfaces() != null && (i$ = 0) < (len$ = (arr$ = clazz.getInterfaces()).length)) {
            Class<?> foundInterface = arr$[i$];
            if (foundInterface == interfaceClass) {
                return true;
            }
            return ReflectionUtils.implementsInterface(foundInterface, interfaceClass);
        }
        if (clazz.getSuperclass() != null) {
            return ReflectionUtils.implementsInterface(clazz.getSuperclass(), interfaceClass);
        }
        return false;
    }

    public static Class getDefaultImplementation(Class clazz) {
        if (!clazz.isInterface()) {
            throw new JcrMappingException(clazz + " is not an interface");
        }
        return defaultImplementation.get(clazz);
    }

    public static boolean isAbstractClass(Class clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    public static Class getAncestorClass(Class clazz) {
        Class ancestorClass = clazz.getSuperclass();
        if (ancestorClass == Object.class) {
            return null;
        }
        return ancestorClass;
    }

    public static Class[] getInterfaces(Class clazz) {
        return clazz.getInterfaces();
    }

    static {
        defaultImplementation.put(Collection.class, ArrayList.class);
        defaultImplementation.put(List.class, ArrayList.class);
        defaultImplementation.put(Map.class, HashMap.class);
        defaultImplementation.put(SortedMap.class, TreeMap.class);
        defaultImplementation.put(Set.class, HashSet.class);
    }
}

