/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.ocm.query.impl;

import java.util.Map;
import javax.jcr.ValueFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.ocm.manager.atomictypeconverter.AtomicTypeConverter;
import org.apache.jackrabbit.ocm.mapper.model.ClassDescriptor;
import org.apache.jackrabbit.ocm.mapper.model.FieldDescriptor;
import org.apache.jackrabbit.ocm.query.Filter;
import org.apache.jackrabbit.ocm.reflection.ReflectionUtils;

public class FilterImpl
implements Filter {
    private static final Log log = LogFactory.getLog(FilterImpl.class);
    private Class claszz;
    private String scope = "";
    private String nodeName = "*";
    private String jcrExpression = "";
    private ClassDescriptor classDescriptor;
    private Map atomicTypeConverters;
    private ValueFactory valueFactory;

    public FilterImpl(ClassDescriptor classDescriptor, Map atomicTypeConverters, Class clazz, ValueFactory valueFactory) {
        this.claszz = clazz;
        this.atomicTypeConverters = atomicTypeConverters;
        this.classDescriptor = classDescriptor;
        this.valueFactory = valueFactory;
    }

    public Class getFilterClass() {
        return this.claszz;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getScope() {
        return this.scope;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public Filter addContains(String scope, String fullTextSearch) {
        String jcrExpression = null;
        jcrExpression = scope.equals(".") ? "jcr:contains(., '" + fullTextSearch + "')" : "jcr:contains(@" + this.getJcrFieldName(scope) + ", '" + fullTextSearch + "')";
        this.addExpression(jcrExpression);
        return this;
    }

    public Filter addBetween(String fieldAttributeName, Object value1, Object value2) {
        String jcrExpression = "( @" + this.getJcrFieldName(fieldAttributeName) + " >= " + this.getStringValue(fieldAttributeName, value1) + " and @" + this.getJcrFieldName(fieldAttributeName) + " <= " + this.getStringValue(fieldAttributeName, value2) + ")";
        this.addExpression(jcrExpression);
        return this;
    }

    public Filter addEqualTo(String fieldAttributeName, Object value) {
        String jcrExpression = "@" + this.getJcrFieldName(fieldAttributeName) + " = " + this.getStringValue(fieldAttributeName, value);
        this.addExpression(jcrExpression);
        return this;
    }

    public Filter addGreaterOrEqualThan(String fieldAttributeName, Object value) {
        String jcrExpression = "@" + this.getJcrFieldName(fieldAttributeName) + " >= " + this.getStringValue(fieldAttributeName, value);
        this.addExpression(jcrExpression);
        return this;
    }

    public Filter addGreaterThan(String fieldAttributeName, Object value) {
        String jcrExpression = "@" + this.getJcrFieldName(fieldAttributeName) + " > " + this.getStringValue(fieldAttributeName, value);
        this.addExpression(jcrExpression);
        return this;
    }

    public Filter addLessOrEqualThan(String fieldAttributeName, Object value) {
        String jcrExpression = "@" + this.getJcrFieldName(fieldAttributeName) + " <= " + this.getStringValue(fieldAttributeName, value);
        this.addExpression(jcrExpression);
        return this;
    }

    public Filter addLessThan(String fieldAttributeName, Object value) {
        String jcrExpression = "@" + this.getJcrFieldName(fieldAttributeName) + " < " + this.getStringValue(fieldAttributeName, value);
        this.addExpression(jcrExpression);
        return this;
    }

    public Filter addLike(String fieldAttributeName, Object value) {
        String jcrExpression = "jcr:like(@" + this.getJcrFieldName(fieldAttributeName) + ", '" + value + "')";
        this.addExpression(jcrExpression);
        return this;
    }

    public Filter addNotEqualTo(String fieldAttributeName, Object value) {
        String jcrExpression = "@" + this.getJcrFieldName(fieldAttributeName) + " != " + this.getStringValue(fieldAttributeName, value);
        this.addExpression(jcrExpression);
        return this;
    }

    public Filter addNotNull(String fieldAttributeName) {
        String jcrExpression = "@" + this.getJcrFieldName(fieldAttributeName);
        this.addExpression(jcrExpression);
        return this;
    }

    public Filter addIsNull(String fieldAttributeName) {
        String jcrExpression = "not(@" + this.getJcrFieldName(fieldAttributeName) + ")";
        this.addExpression(jcrExpression);
        return this;
    }

    public Filter addOrFilter(String fieldAttributeName, String[] valueList) {
        String jcrExpression = "";
        for (String object : valueList) {
            jcrExpression = "@" + this.getJcrFieldName(fieldAttributeName) + " = " + this.getStringValue(fieldAttributeName, object);
            this.orExpression(jcrExpression);
        }
        this.addExpression(jcrExpression);
        return this;
    }

    public Filter addOrFilter(Filter filter) {
        FilterImpl theFilter = (FilterImpl)filter;
        if (theFilter.getJcrExpression() != null && theFilter.getJcrExpression().length() > 0) {
            this.jcrExpression = null == this.jcrExpression || "".equals(this.jcrExpression) ? ((FilterImpl)filter).getJcrExpression() : "(" + this.jcrExpression + ")  or ( " + ((FilterImpl)filter).getJcrExpression() + ")";
        }
        return this;
    }

    public Filter addAndFilter(Filter filter) {
        FilterImpl theFilter = (FilterImpl)filter;
        if (theFilter.getJcrExpression() != null && theFilter.getJcrExpression().length() > 0) {
            this.jcrExpression = null == this.jcrExpression || "".equals(this.jcrExpression) ? ((FilterImpl)filter).getJcrExpression() : "(" + this.jcrExpression + ") and  ( " + ((FilterImpl)filter).getJcrExpression() + ")";
        }
        return this;
    }

    public Filter addJCRExpression(String jcrExpression) {
        this.addExpression(jcrExpression);
        return this;
    }

    public Filter orJCRExpression(String jcrExpression) {
        this.orExpression(jcrExpression);
        return this;
    }

    private String getJcrFieldName(String fieldAttribute) {
        String jcrFieldName = this.classDescriptor.getJcrName(fieldAttribute);
        if (jcrFieldName == null) {
            log.error((Object)("Impossible to find the jcrFieldName for the attribute :" + fieldAttribute));
        }
        return jcrFieldName;
    }

    private String getStringValue(String fieldName, Object value) {
        String fieldConverterName;
        FieldDescriptor fieldDescriptor = this.classDescriptor.getFieldDescriptor(fieldName);
        AtomicTypeConverter atomicTypeConverter = null;
        atomicTypeConverter = fieldDescriptor != null ? ((fieldConverterName = fieldDescriptor.getConverter()) != null ? (AtomicTypeConverter)ReflectionUtils.newInstance(fieldConverterName) : (AtomicTypeConverter)this.atomicTypeConverters.get(value.getClass())) : (AtomicTypeConverter)this.atomicTypeConverters.get(value.getClass());
        return atomicTypeConverter.getXPathQueryValue(this.valueFactory, value);
    }

    public String getJcrExpression() {
        return this.jcrExpression;
    }

    private void addExpression(String jcrExpression) {
        if (this.jcrExpression.length() > 0) {
            this.jcrExpression = this.jcrExpression + " and ";
        }
        this.jcrExpression = this.jcrExpression + jcrExpression;
    }

    private void orExpression(String jcrExpression) {
        if (this.jcrExpression.length() > 0) {
            this.jcrExpression = this.jcrExpression + " or ";
        }
        this.jcrExpression = this.jcrExpression + jcrExpression;
    }

    public String toString() {
        return this.getJcrExpression();
    }
}

