/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.ocm.mapper.impl.digester;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.digester.Digester;
import org.apache.jackrabbit.ocm.exception.InitMapperException;
import org.apache.jackrabbit.ocm.mapper.DescriptorReader;
import org.apache.jackrabbit.ocm.mapper.model.BeanDescriptor;
import org.apache.jackrabbit.ocm.mapper.model.ClassDescriptor;
import org.apache.jackrabbit.ocm.mapper.model.CollectionDescriptor;
import org.apache.jackrabbit.ocm.mapper.model.FieldDescriptor;
import org.apache.jackrabbit.ocm.mapper.model.ImplementDescriptor;
import org.apache.jackrabbit.ocm.mapper.model.MappingDescriptor;

public class DigesterDescriptorReader
implements DescriptorReader {
    private boolean validating = true;
    private URL dtdResolver;
    private Collection configFileStreams = new ArrayList();

    public DigesterDescriptorReader(InputStream stream) {
        this.configFileStreams.add(stream);
    }

    public DigesterDescriptorReader(InputStream[] streams) {
        for (int i = 0; i < streams.length; ++i) {
            this.configFileStreams.add(streams[i]);
        }
    }

    public DigesterDescriptorReader(String xmlFile) {
        try {
            this.configFileStreams.add(new FileInputStream(xmlFile));
        }
        catch (FileNotFoundException e) {
            throw new InitMapperException("Mapping file not found : " + xmlFile, e);
        }
    }

    public DigesterDescriptorReader(String[] xmlFiles) {
        for (int i = 0; i < xmlFiles.length; ++i) {
            try {
                this.configFileStreams.add(new FileInputStream(xmlFiles[i]));
                continue;
            }
            catch (FileNotFoundException e) {
                throw new InitMapperException("Mapping file not found : " + xmlFiles[i], e);
            }
        }
    }

    public void setValidating(boolean flag) {
        this.validating = flag;
    }

    public void setResolver(URL dtdResolver) {
        this.dtdResolver = dtdResolver;
    }

    public MappingDescriptor loadClassDescriptors() {
        try {
            MappingDescriptor mappingDescriptor = new MappingDescriptor();
            for (InputStream xmlMappingDescriptorFile : this.configFileStreams) {
                Digester digester = new Digester();
                digester.setValidating(this.validating);
                if (null != this.dtdResolver) {
                    digester.register("-//The Apache Software Foundation//DTD Repository//EN", this.dtdResolver.toString());
                }
                digester.setClassLoader(this.getClass().getClassLoader());
                MappingDescriptor currentMappingDescriptor = new MappingDescriptor();
                digester.push((Object)currentMappingDescriptor);
                digester.addObjectCreate("jackrabbit-ocm/class-descriptor", ClassDescriptor.class);
                digester.addSetProperties("jackrabbit-ocm/class-descriptor");
                digester.addSetNext("jackrabbit-ocm/class-descriptor", "addClassDescriptor");
                digester.addObjectCreate("jackrabbit-ocm/class-descriptor/implement-descriptor", ImplementDescriptor.class);
                digester.addSetProperties("jackrabbit-ocm/class-descriptor/implement-descriptor");
                digester.addSetNext("jackrabbit-ocm/class-descriptor/implement-descriptor", "addImplementDescriptor");
                digester.addObjectCreate("jackrabbit-ocm/class-descriptor/field-descriptor", FieldDescriptor.class);
                digester.addSetProperties("jackrabbit-ocm/class-descriptor/field-descriptor");
                digester.addSetNext("jackrabbit-ocm/class-descriptor/field-descriptor", "addFieldDescriptor");
                digester.addObjectCreate("jackrabbit-ocm/class-descriptor/bean-descriptor", BeanDescriptor.class);
                digester.addSetProperties("jackrabbit-ocm/class-descriptor/bean-descriptor");
                digester.addSetNext("jackrabbit-ocm/class-descriptor/bean-descriptor", "addBeanDescriptor");
                digester.addObjectCreate("jackrabbit-ocm/class-descriptor/collection-descriptor", CollectionDescriptor.class);
                digester.addSetProperties("jackrabbit-ocm/class-descriptor/collection-descriptor");
                digester.addSetNext("jackrabbit-ocm/class-descriptor/collection-descriptor", "addCollectionDescriptor");
                currentMappingDescriptor = (MappingDescriptor)digester.parse(xmlMappingDescriptorFile);
                mappingDescriptor.getClassDescriptorsByClassName().putAll(currentMappingDescriptor.getClassDescriptorsByClassName());
                mappingDescriptor.getClassDescriptorsByNodeType().putAll(currentMappingDescriptor.getClassDescriptorsByNodeType());
            }
            return mappingDescriptor;
        }
        catch (Exception e) {
            throw new InitMapperException("Impossible to read the xml mapping descriptor file(s)", e);
        }
    }
}

