/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.ocm.manager.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Workspace;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.version.VersionHistory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.ocm.exception.IllegalUnlockException;
import org.apache.jackrabbit.ocm.exception.IncorrectPersistentClassException;
import org.apache.jackrabbit.ocm.exception.InvalidQueryException;
import org.apache.jackrabbit.ocm.exception.JcrMappingException;
import org.apache.jackrabbit.ocm.exception.LockedException;
import org.apache.jackrabbit.ocm.exception.ObjectContentManagerException;
import org.apache.jackrabbit.ocm.exception.RepositoryException;
import org.apache.jackrabbit.ocm.exception.VersionException;
import org.apache.jackrabbit.ocm.lock.Lock;
import org.apache.jackrabbit.ocm.manager.ObjectContentManager;
import org.apache.jackrabbit.ocm.manager.atomictypeconverter.impl.DefaultAtomicTypeConverterProvider;
import org.apache.jackrabbit.ocm.manager.cache.ObjectCache;
import org.apache.jackrabbit.ocm.manager.cache.impl.RequestObjectCacheImpl;
import org.apache.jackrabbit.ocm.manager.impl.ObjectIterator;
import org.apache.jackrabbit.ocm.manager.objectconverter.ObjectConverter;
import org.apache.jackrabbit.ocm.manager.objectconverter.impl.ObjectConverterImpl;
import org.apache.jackrabbit.ocm.manager.objectconverter.impl.ProxyManagerImpl;
import org.apache.jackrabbit.ocm.mapper.Mapper;
import org.apache.jackrabbit.ocm.mapper.impl.digester.DigesterMapperImpl;
import org.apache.jackrabbit.ocm.mapper.model.ClassDescriptor;
import org.apache.jackrabbit.ocm.query.Filter;
import org.apache.jackrabbit.ocm.query.QueryManager;
import org.apache.jackrabbit.ocm.query.impl.QueryManagerImpl;
import org.apache.jackrabbit.ocm.repository.NodeUtil;
import org.apache.jackrabbit.ocm.version.Version;
import org.apache.jackrabbit.ocm.version.VersionIterator;

public class ObjectContentManagerImpl
implements ObjectContentManager {
    private static final Log log = LogFactory.getLog(ObjectContentManagerImpl.class);
    protected Session session;
    protected Mapper mapper;
    protected QueryManager queryManager;
    protected ObjectConverter objectConverter;
    protected ObjectCache requestObjectCache;

    public ObjectContentManagerImpl(Session session, Mapper mapper) {
        try {
            this.session = session;
            this.mapper = mapper;
            DefaultAtomicTypeConverterProvider converterProvider = new DefaultAtomicTypeConverterProvider();
            Map atomicTypeConverters = converterProvider.getAtomicTypeConverters();
            this.queryManager = new QueryManagerImpl(mapper, atomicTypeConverters, session.getValueFactory());
            this.requestObjectCache = new RequestObjectCacheImpl();
            this.objectConverter = new ObjectConverterImpl(mapper, converterProvider, new ProxyManagerImpl(), this.requestObjectCache);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to instantiate the object content manager", e);
        }
    }

    public ObjectContentManagerImpl(Session session, String[] xmlMappingFiles) {
        try {
            this.session = session;
            this.mapper = new DigesterMapperImpl(xmlMappingFiles);
            DefaultAtomicTypeConverterProvider converterProvider = new DefaultAtomicTypeConverterProvider();
            Map atomicTypeConverters = converterProvider.getAtomicTypeConverters();
            this.queryManager = new QueryManagerImpl(this.mapper, atomicTypeConverters, session.getValueFactory());
            this.requestObjectCache = new RequestObjectCacheImpl();
            this.objectConverter = new ObjectConverterImpl(this.mapper, converterProvider, new ProxyManagerImpl(), this.requestObjectCache);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to instantiate the object content manager", e);
        }
    }

    public ObjectContentManagerImpl(Session session, InputStream[] xmlMappingFiles) {
        try {
            this.session = session;
            this.mapper = new DigesterMapperImpl(xmlMappingFiles);
            DefaultAtomicTypeConverterProvider converterProvider = new DefaultAtomicTypeConverterProvider();
            Map atomicTypeConverters = converterProvider.getAtomicTypeConverters();
            this.queryManager = new QueryManagerImpl(this.mapper, atomicTypeConverters, session.getValueFactory());
            this.requestObjectCache = new RequestObjectCacheImpl();
            this.objectConverter = new ObjectConverterImpl(this.mapper, converterProvider, new ProxyManagerImpl(), this.requestObjectCache);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to instantiate the object content manager", e);
        }
    }

    public ObjectContentManagerImpl(Mapper mapper, ObjectConverter converter, QueryManager queryManager, ObjectCache requestObjectCache, Session session) {
        this.mapper = mapper;
        this.session = session;
        this.objectConverter = converter;
        this.queryManager = queryManager;
        this.requestObjectCache = requestObjectCache;
    }

    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    public void setObjectConverter(ObjectConverter objectConverter) {
        this.objectConverter = objectConverter;
    }

    public void setQueryManager(QueryManager queryManager) {
        this.queryManager = queryManager;
    }

    public void setRequestObjectCache(ObjectCache requestObjectCache) {
        this.requestObjectCache = requestObjectCache;
    }

    public Object getObject(String path) {
        try {
            if (!this.session.itemExists(path)) {
                return null;
            }
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to get the object at " + path, e);
        }
        Object object = this.objectConverter.getObject(this.session, path);
        this.requestObjectCache.clear();
        return object;
    }

    public Object getObjectByUuid(String uuid) {
        try {
            Node node = this.session.getNodeByUUID(uuid);
            Object object = this.objectConverter.getObject(this.session, node.getPath());
            this.requestObjectCache.clear();
            return object;
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to get the object with uuid : " + uuid, e);
        }
    }

    public Object getObject(String path, String versionName) {
        String pathVersion = null;
        try {
            if (!this.session.itemExists(path)) {
                return null;
            }
            Version version = this.getVersion(path, versionName);
            pathVersion = version.getPath() + "/jcr:frozenNode";
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to get the object at " + path + " - version :" + versionName, e);
        }
        Object object = this.objectConverter.getObject(this.session, pathVersion);
        this.requestObjectCache.clear();
        return object;
    }

    public Object getObject(Class objectClass, String path) {
        try {
            if (!this.session.itemExists(path)) {
                return null;
            }
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to get the object at " + path, e);
        }
        Object object = this.objectConverter.getObject(this.session, objectClass, path);
        this.requestObjectCache.clear();
        return object;
    }

    public Object getObject(Class objectClass, String path, String versionName) {
        String pathVersion = null;
        try {
            if (!this.session.itemExists(path)) {
                return null;
            }
            Version version = this.getVersion(path, versionName);
            pathVersion = version.getPath() + "/jcr:frozenNode";
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to get the object at " + path + " - version :" + versionName, e);
        }
        Object object = this.objectConverter.getObject(this.session, objectClass, pathVersion);
        this.requestObjectCache.clear();
        return object;
    }

    public void retrieveAllMappedAttributes(Object object) {
        this.objectConverter.retrieveAllMappedAttributes(this.session, object);
    }

    public void retrieveMappedAttribute(Object object, String attributeName) {
        this.objectConverter.retrieveMappedAttribute(this.session, object, attributeName);
    }

    public void insert(Object object) {
        block4: {
            String path = this.objectConverter.getPath(this.session, object);
            try {
                if (!this.session.itemExists(path)) break block4;
                Item item = this.session.getItem(path);
                if (item.isNode()) {
                    if (!((Node)item).getDefinition().allowsSameNameSiblings()) {
                        throw new ObjectContentManagerException("Path already exists and it is not supporting the same name sibling : " + path);
                    }
                    break block4;
                }
                throw new ObjectContentManagerException("Path already exists and it is a property : " + path);
            }
            catch (javax.jcr.RepositoryException e) {
                throw new RepositoryException("Impossible to insert the object at " + path, e);
            }
        }
        this.objectConverter.insert(this.session, object);
    }

    public void update(Object object) {
        String path = this.objectConverter.getPath(this.session, object);
        try {
            if (!this.session.itemExists(path)) {
                throw new ObjectContentManagerException("Path is not existing : " + path);
            }
            this.checkIfNodeLocked(path);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to update", e);
        }
        this.objectConverter.update(this.session, object);
    }

    public void remove(String path) {
        try {
            if (!this.session.itemExists(path)) {
                throw new ObjectContentManagerException("Path does not exist : " + path);
            }
            this.checkIfNodeLocked(path);
            Item item = this.session.getItem(path);
            item.remove();
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to remove the object at " + path);
        }
    }

    public void remove(Object object) {
        this.remove(this.objectConverter.getPath(this.session, object));
    }

    public void remove(org.apache.jackrabbit.ocm.query.Query query) {
        try {
            String jcrExpression = this.queryManager.buildJCRExpression(query);
            log.debug((Object)("Remove Objects with expression : " + jcrExpression));
            NodeIterator nodeIterator = this.getNodeIterator(jcrExpression, "xpath");
            ArrayList<Node> nodes = new ArrayList<Node>();
            while (nodeIterator.hasNext()) {
                Node node = nodeIterator.nextNode();
                log.debug((Object)("Remove node : " + node.getPath()));
                nodes.add(node);
            }
            for (int i = 0; i < nodes.size(); ++i) {
                Node node = (Node)nodes.get(i);
                this.checkIfNodeLocked(node.getPath());
                try {
                    node.remove();
                    continue;
                }
                catch (javax.jcr.RepositoryException re) {
                    throw new ObjectContentManagerException("Cannot remove node at path " + node.getPath() + " returned from query " + jcrExpression, re);
                }
            }
        }
        catch (javax.jcr.query.InvalidQueryException iqe) {
            throw new RepositoryException("Invalid query expression", iqe);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to get the object collection", e);
        }
    }

    public boolean objectExists(String path) {
        try {
            return this.session.itemExists(path);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to check if the object exist", e);
        }
    }

    public boolean isPersistent(Class clazz) {
        try {
            ClassDescriptor classDescriptor = this.mapper.getClassDescriptorByClass(clazz);
            return classDescriptor != null;
        }
        catch (IncorrectPersistentClassException e) {
            return false;
        }
    }

    public Object getObject(org.apache.jackrabbit.ocm.query.Query query) {
        String jcrExpression = this.queryManager.buildJCRExpression(query);
        Collection result = this.getObjects(jcrExpression, "xpath");
        if (result.size() > 1) {
            throw new ObjectContentManagerException("Impossible to get the object - the query returns more than one object");
        }
        return result.isEmpty() ? null : result.iterator().next();
    }

    public Collection getObjects(org.apache.jackrabbit.ocm.query.Query query) {
        String jcrExpression = this.queryManager.buildJCRExpression(query);
        return this.getObjects(jcrExpression, "xpath");
    }

    public Collection getObjects(Class objectClass, String path) throws ObjectContentManagerException {
        String nodeName;
        try {
            if (!this.session.itemExists(path)) {
                return null;
            }
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to get the objects at " + path, e);
        }
        String parentPath = NodeUtil.getParentPath(path);
        if (!parentPath.equals("/")) {
            parentPath = parentPath + "/";
        }
        if ((nodeName = NodeUtil.getNodeName(path)) == null || nodeName.length() == 0) {
            nodeName = "*";
        }
        Filter filter = this.queryManager.createFilter(objectClass);
        filter.setScope(parentPath);
        filter.setNodeName(nodeName);
        org.apache.jackrabbit.ocm.query.Query query = this.queryManager.createQuery(filter);
        return this.getObjects(query);
    }

    public Iterator getObjectIterator(org.apache.jackrabbit.ocm.query.Query query) {
        String jcrExpression = this.queryManager.buildJCRExpression(query);
        log.debug((Object)("Get Object with expression : " + jcrExpression));
        NodeIterator nodeIterator = this.getNodeIterator(jcrExpression, "xpath");
        return new ObjectIterator(nodeIterator, this.objectConverter, this.session);
    }

    public Iterator getObjectIterator(String query, String language) {
        log.debug((Object)("Get Object with expression : " + query));
        NodeIterator nodeIterator = this.getNodeIterator(query, language);
        return new ObjectIterator(nodeIterator, this.objectConverter, this.session);
    }

    public Collection getObjects(String query, String language) {
        try {
            log.debug((Object)("Get Objects with expression : " + query + " and language " + language));
            NodeIterator nodeIterator = this.getNodeIterator(query, language);
            ArrayList<Object> result = new ArrayList<Object>();
            while (nodeIterator.hasNext()) {
                Node node = nodeIterator.nextNode();
                log.debug((Object)("Node found : " + node.getPath()));
                result.add(this.objectConverter.getObject(this.session, node.getPath()));
            }
            this.requestObjectCache.clear();
            return result;
        }
        catch (javax.jcr.query.InvalidQueryException iqe) {
            throw new RepositoryException("Invalid query expression", iqe);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to get the object collection", e);
        }
    }

    private NodeIterator getNodeIterator(String query, String language) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Get Node Iterator with expression " + query + " and language " + language));
        }
        try {
            Query jcrQuery = this.session.getWorkspace().getQueryManager().createQuery(query, language);
            QueryResult queryResult = jcrQuery.execute();
            NodeIterator nodeIterator = queryResult.getNodes();
            return nodeIterator;
        }
        catch (javax.jcr.query.InvalidQueryException iqe) {
            throw new InvalidQueryException(iqe);
        }
        catch (javax.jcr.RepositoryException re) {
            throw new ObjectContentManagerException(re.getMessage(), re);
        }
    }

    public void checkin(String path) {
        this.checkin(path, null);
    }

    public void checkin(String path, String[] versionLabels) {
        try {
            Node node = (Node)this.session.getItem(path);
            this.checkIfNodeLocked(node.getPath());
            if (!node.isNodeType("mix:versionable")) {
                throw new VersionException("The object " + path + "is not versionable");
            }
            javax.jcr.version.Version newVersion = node.checkin();
            if (versionLabels != null) {
                VersionHistory versionHistory = node.getVersionHistory();
                for (int i = 0; i < versionLabels.length; ++i) {
                    versionHistory.addVersionLabel(newVersion.getName(), versionLabels[i], false);
                }
            }
        }
        catch (ClassCastException cce) {
            throw new ObjectContentManagerException("Cannot retrieve an object from a property path " + path);
        }
        catch (PathNotFoundException pnfe) {
            throw new ObjectContentManagerException("Cannot retrieve an object at path " + path, pnfe);
        }
        catch (InvalidItemStateException iise) {
            throw new ObjectContentManagerException("Cannot checking modified object at path " + path, iise);
        }
        catch (javax.jcr.version.VersionException ve) {
            throw new VersionException("Impossible to checkin the object " + path, ve);
        }
        catch (UnsupportedRepositoryOperationException uroe) {
            throw new VersionException("Cannot checkin unversionable node at path " + path, uroe);
        }
        catch (LockException le) {
            throw new VersionException("Cannot checkin locked node at path " + path, le);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to checkin the object " + path, e);
        }
    }

    public void checkout(String path) {
        Node node = null;
        try {
            node = (Node)this.session.getItem(path);
            if (!node.isNodeType("mix:versionable")) {
                throw new VersionException("The object " + path + "is not versionable");
            }
            node.checkout();
        }
        catch (ClassCastException cce) {
            throw new ObjectContentManagerException("Cannot retrieve an object from a property path " + path);
        }
        catch (PathNotFoundException pnfe) {
            throw new ObjectContentManagerException("Cannot retrieve an object at path " + path, pnfe);
        }
        catch (UnsupportedRepositoryOperationException uroe) {
            throw new VersionException("Cannot checkout unversionable node at path " + path, uroe);
        }
        catch (LockException le) {
            throw new VersionException("Cannot checkout locked node at path " + path, le);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to checkout the object " + path, e);
        }
    }

    public void addVersionLabel(String path, String versionName, String versionLabel) {
        try {
            Node node = (Node)this.session.getItem(path);
            this.checkIfNodeLocked(path);
            if (!node.isNodeType("mix:versionable")) {
                throw new VersionException("The object " + path + "is not versionable");
            }
            VersionHistory history = node.getVersionHistory();
            history.addVersionLabel(versionName, versionLabel, false);
        }
        catch (ClassCastException cce) {
            throw new ObjectContentManagerException("Cannot retrieve an object from a property path " + path);
        }
        catch (PathNotFoundException pnfe) {
            throw new ObjectContentManagerException("Cannot retrieve an object at path " + path, pnfe);
        }
        catch (javax.jcr.version.VersionException ve) {
            throw new VersionException("Impossible to add a new version label to  " + path + " - version name : " + versionName, ve);
        }
        catch (UnsupportedRepositoryOperationException uroe) {
            throw new VersionException("Impossible to add a new version label to  " + path + " - version name : " + versionName, uroe);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e);
        }
    }

    public Version getVersion(String path, String versionName) {
        try {
            Node node = (Node)this.session.getItem(path);
            if (!node.isNodeType("mix:versionable")) {
                throw new VersionException("The object " + path + "is not versionable");
            }
            VersionHistory history = node.getVersionHistory();
            return new Version(history.getVersion(versionName));
        }
        catch (ClassCastException cce) {
            throw new ObjectContentManagerException("Cannot retrieve an object from a property path " + path);
        }
        catch (PathNotFoundException pnfe) {
            throw new ObjectContentManagerException("Cannot retrieve an object at path " + path, pnfe);
        }
        catch (javax.jcr.version.VersionException ve) {
            throw new VersionException("The version name " + versionName + "does not exist", ve);
        }
        catch (UnsupportedRepositoryOperationException uroe) {
            throw new VersionException("Impossible to retrieve versions for path " + path, uroe);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e);
        }
    }

    public String[] getVersionLabels(String path, String versionName) {
        try {
            Node node = (Node)this.session.getItem(path);
            if (!node.isNodeType("mix:versionable")) {
                throw new VersionException("The object " + path + "is not versionable");
            }
            VersionHistory history = node.getVersionHistory();
            javax.jcr.version.Version version = history.getVersion(versionName);
            return history.getVersionLabels(version);
        }
        catch (ClassCastException cce) {
            throw new ObjectContentManagerException("Cannot retrieve an object from a property path " + path);
        }
        catch (PathNotFoundException pnfe) {
            throw new ObjectContentManagerException("Cannot retrieve an object at path " + path, pnfe);
        }
        catch (javax.jcr.version.VersionException ve) {
            throw new VersionException("Impossible to get the version labels : " + path + " - version name : " + versionName, ve);
        }
        catch (UnsupportedRepositoryOperationException uroe) {
            throw new VersionException("Impossible to retrieve versions for path " + path, uroe);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e);
        }
    }

    public String[] getAllVersionLabels(String path) {
        try {
            Node node = (Node)this.session.getItem(path);
            if (!node.isNodeType("mix:versionable")) {
                throw new VersionException("The object " + path + "is not versionable");
            }
            VersionHistory history = node.getVersionHistory();
            return history.getVersionLabels();
        }
        catch (ClassCastException cce) {
            throw new ObjectContentManagerException("Cannot retrieve an object from a property path " + path);
        }
        catch (PathNotFoundException pnfe) {
            throw new ObjectContentManagerException("Cannot retrieve an object at path " + path, pnfe);
        }
        catch (UnsupportedRepositoryOperationException uroe) {
            throw new VersionException("Impossible to retrieve version history for path " + path, uroe);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e);
        }
    }

    public VersionIterator getAllVersions(String path) {
        try {
            Node node = (Node)this.session.getItem(path);
            if (!node.isNodeType("mix:versionable")) {
                throw new VersionException("The object " + path + "is not versionable");
            }
            VersionHistory history = node.getVersionHistory();
            return new VersionIterator(history.getAllVersions());
        }
        catch (ClassCastException cce) {
            throw new ObjectContentManagerException("Cannot retrieve an object from a property path " + path);
        }
        catch (PathNotFoundException pnfe) {
            throw new ObjectContentManagerException("Cannot retrieve an object at path " + path, pnfe);
        }
        catch (UnsupportedRepositoryOperationException uroe) {
            throw new VersionException("Impossible to retrieve version history for path " + path, uroe);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e);
        }
    }

    public Version getRootVersion(String path) {
        try {
            Node node = (Node)this.session.getItem(path);
            if (!node.isNodeType("mix:versionable")) {
                throw new VersionException("The object " + path + "is not versionable");
            }
            VersionHistory history = node.getVersionHistory();
            return new Version(history.getRootVersion());
        }
        catch (ClassCastException cce) {
            throw new ObjectContentManagerException("Cannot retrieve an object from a property path " + path);
        }
        catch (PathNotFoundException pnfe) {
            throw new ObjectContentManagerException("Cannot retrieve an object at path " + path, pnfe);
        }
        catch (UnsupportedRepositoryOperationException uroe) {
            throw new VersionException("Impossible to get the root version  for the object " + path, uroe);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e);
        }
    }

    public Version getBaseVersion(String path) {
        try {
            Node node = (Node)this.session.getItem(path);
            if (!node.isNodeType("mix:versionable")) {
                throw new VersionException("The object " + path + "is not versionable");
            }
            return new Version(node.getBaseVersion());
        }
        catch (ClassCastException cce) {
            throw new ObjectContentManagerException("Cannot retrieve an object from a property path " + path);
        }
        catch (PathNotFoundException pnfe) {
            throw new ObjectContentManagerException("Cannot retrieve an object at path " + path, pnfe);
        }
        catch (UnsupportedRepositoryOperationException uroe) {
            throw new VersionException("Impossible to get the base version for the object " + path, uroe);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e);
        }
    }

    public Lock lock(String absPath, boolean isDeep, boolean isSessionScoped) throws LockedException {
        try {
            this.checkIfNodeLocked(absPath);
            Node node = this.getNode(absPath);
            javax.jcr.lock.Lock lock = node.lock(isDeep, isSessionScoped);
            return new Lock(lock);
        }
        catch (LockException e) {
            throw new RepositoryException("Node of type is not type mix:lockable", e);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
    }

    public void unlock(String absPath, String lockToken) throws IllegalUnlockException {
        String lockOwner = null;
        try {
            this.maybeAddLockToken(lockToken);
            Node node = this.getNode(absPath);
            if (!node.isLocked()) {
                return;
            }
            javax.jcr.lock.Lock lock = node.getLock();
            lockOwner = lock.getLockOwner();
            node.unlock();
        }
        catch (LockException e) {
            log.error((Object)("Cannot unlock path: " + absPath + " Jcr user: " + this.session.getUserID() + " has no lock token to do this. Lock was placed with user: " + lockOwner));
            throw new IllegalUnlockException(lockOwner, absPath);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
    }

    public boolean isLocked(String absPath) {
        try {
            Node node = this.getNode(absPath);
            return node.isLocked();
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("An exception was thrown while checking the lock at path : " + absPath, e);
        }
    }

    public QueryManager getQueryManager() {
        return this.queryManager;
    }

    protected void checkIfNodeLocked(String absPath) throws javax.jcr.RepositoryException, LockedException {
        Node node = this.getNode(absPath);
        if (node.isLocked()) {
            javax.jcr.lock.Lock lock = node.getLock();
            String lockOwner = lock.getLockOwner();
            if (!this.session.getUserID().equals(lockOwner)) {
                String path = lock.getNode().getPath();
                throw new LockedException(lockOwner, path);
            }
        }
    }

    protected void maybeAddLockToken(String lockToken) {
        if (lockToken != null) {
            String[] lockTokens = this.getSession().getLockTokens();
            if (lockTokens != null) {
                for (int i = 0; i < lockTokens.length && !lockTokens[i].equals(lockToken); ++i) {
                }
            } else {
                this.getSession().addLockToken(lockToken);
            }
        }
    }

    protected Node getNode(String absPath) throws PathNotFoundException, javax.jcr.RepositoryException {
        if (!this.getSession().itemExists(absPath)) {
            throw new ObjectContentManagerException("No object stored on path: " + absPath);
        }
        Item item = this.getSession().getItem(absPath);
        if (!item.isNode()) {
            throw new ObjectContentManagerException("No object stored on path: " + absPath + " on absPath is item (leaf)");
        }
        return (Node)item;
    }

    public void logout() {
        try {
            log.debug((Object)"Logout. Persisting current session changes.");
            this.session.save();
            this.session.logout();
            log.debug((Object)"Session closed");
        }
        catch (NoSuchNodeTypeException nsnte) {
            throw new JcrMappingException("Cannot persist current session changes. An unknown node type was used.", nsnte);
        }
        catch (javax.jcr.version.VersionException ve) {
            throw new VersionException("Cannot persist current session changes. Attempt to overwrite checked-in node", ve);
        }
        catch (LockException le) {
            throw new ObjectContentManagerException("Cannot persist current session changes. Violation of a lock detected", le);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new ObjectContentManagerException("Cannot persist current session changes.", e);
        }
    }

    public void save() {
        try {
            this.session.save();
        }
        catch (NoSuchNodeTypeException nsnte) {
            throw new JcrMappingException("Cannot persist current session changes. An unknown node type was used.", nsnte);
        }
        catch (javax.jcr.version.VersionException ve) {
            throw new VersionException("Cannot persist current session changes. Attempt to overwrite checked-in node", ve);
        }
        catch (LockException le) {
            throw new ObjectContentManagerException("Cannot persist current session changes. Violation of a lock detected", le);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new ObjectContentManagerException("Cannot persist current session changes.", e);
        }
    }

    public Session getSession() {
        return this.session;
    }

    public void refresh(boolean keepChanges) {
        try {
            this.session.refresh(keepChanges);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new ObjectContentManagerException("Cannot refresh current session ", e);
        }
    }

    public void move(String srcPath, String destPath) {
        Workspace workspace = this.session.getWorkspace();
        try {
            workspace.move(srcPath, destPath);
        }
        catch (ConstraintViolationException cve) {
            throw new ObjectContentManagerException("Cannot move the object from " + srcPath + " to " + destPath + "." + " Violation of a nodetype or attempt to move under a property detected", cve);
        }
        catch (javax.jcr.version.VersionException ve) {
            throw new VersionException("Cannot move the object from " + srcPath + " to " + destPath + "." + " Parent node of source or destination is versionable and checked in ", ve);
        }
        catch (AccessDeniedException ade) {
            throw new ObjectContentManagerException("Cannot move the object from " + srcPath + " to " + destPath + "." + " Session does not have access permissions", ade);
        }
        catch (PathNotFoundException pnf) {
            throw new ObjectContentManagerException("Cannot move the object from " + srcPath + " to " + destPath + "." + " Node at source or destination does not exist ", pnf);
        }
        catch (ItemExistsException ie) {
            throw new ObjectContentManagerException("Cannot move the object from " + srcPath + " to " + destPath + "." + " It might already exist at destination path.", ie);
        }
        catch (LockException le) {
            throw new ObjectContentManagerException("Cannot move the object from " + srcPath + " to " + destPath + "." + "Violation of a lock detected", le);
        }
        catch (javax.jcr.RepositoryException re) {
            throw new ObjectContentManagerException("Cannot move the object from " + srcPath + " to " + destPath + ".", re);
        }
    }

    public void copy(String srcPath, String destPath) {
        Workspace workspace = this.session.getWorkspace();
        try {
            workspace.copy(srcPath, destPath);
        }
        catch (ConstraintViolationException cve) {
            throw new ObjectContentManagerException("Cannot copy the object from " + srcPath + " to " + destPath + "." + "Violation of a nodetype or attempt to copy under property detected ", cve);
        }
        catch (javax.jcr.version.VersionException ve) {
            throw new VersionException("Cannot copy the object from " + srcPath + " to " + destPath + "." + "Parent node of source or destination is versionable and checked in ", ve);
        }
        catch (AccessDeniedException ade) {
            throw new ObjectContentManagerException("Cannot copy the object from " + srcPath + " to " + destPath + "." + " Session does not have access permissions", ade);
        }
        catch (PathNotFoundException pnf) {
            throw new ObjectContentManagerException("Cannot copy the object from " + srcPath + " to " + destPath + "." + "Node at source or destination does not exist ", pnf);
        }
        catch (ItemExistsException ie) {
            throw new ObjectContentManagerException("Cannot copy the object from " + srcPath + " to " + destPath + "." + "It might already exist at destination path.", ie);
        }
        catch (LockException le) {
            throw new ObjectContentManagerException("Cannot copy the object from " + srcPath + " to " + destPath + "." + "Violation of a lock detected", le);
        }
        catch (javax.jcr.RepositoryException re) {
            throw new ObjectContentManagerException("Cannot copy the node from " + srcPath + " to " + destPath + ".", re);
        }
    }
}

