/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.ocm.manager.collectionconverter.impl;

import java.util.Iterator;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.ocm.exception.JcrMappingException;
import org.apache.jackrabbit.ocm.exception.ObjectContentManagerException;
import org.apache.jackrabbit.ocm.manager.collectionconverter.ManageableCollection;
import org.apache.jackrabbit.ocm.manager.collectionconverter.ManageableObjects;
import org.apache.jackrabbit.ocm.manager.collectionconverter.ManageableObjectsUtil;
import org.apache.jackrabbit.ocm.manager.collectionconverter.impl.AbstractCollectionConverterImpl;
import org.apache.jackrabbit.ocm.manager.objectconverter.ObjectConverter;
import org.apache.jackrabbit.ocm.mapper.Mapper;
import org.apache.jackrabbit.ocm.mapper.model.ClassDescriptor;
import org.apache.jackrabbit.ocm.mapper.model.CollectionDescriptor;
import org.apache.jackrabbit.ocm.mapper.model.FieldDescriptor;
import org.apache.jackrabbit.ocm.reflection.ReflectionUtils;

public class BeanReferenceCollectionConverterImpl
extends AbstractCollectionConverterImpl {
    public BeanReferenceCollectionConverterImpl(Map atomicTypeConverters, ObjectConverter objectConverter, Mapper mapper) {
        super(atomicTypeConverters, objectConverter, mapper);
    }

    protected void doInsertCollection(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, ManageableObjects objects) throws RepositoryException {
        this.addUuidProperties(session, parentNode, collectionDescriptor, objects);
    }

    protected void doUpdateCollection(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, ManageableObjects objects) throws RepositoryException {
        String jcrName = this.getCollectionJcrName(collectionDescriptor);
        if (parentNode.hasProperty(jcrName)) {
            parentNode.setProperty(jcrName, (Value[])null);
        }
        if (objects == null) {
            return;
        }
        this.addUuidProperties(session, parentNode, collectionDescriptor, objects);
    }

    protected ManageableObjects doGetCollection(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, Class collectionFieldClass) throws RepositoryException {
        try {
            String jcrName = this.getCollectionJcrName(collectionDescriptor);
            if (!parentNode.hasProperty(jcrName)) {
                return null;
            }
            Property property = parentNode.getProperty(jcrName);
            Value[] values = property.getValues();
            ManageableObjects objects = ManageableObjectsUtil.getManageableObjects(collectionFieldClass);
            if (!(objects instanceof ManageableCollection)) {
                throw new JcrMappingException("Impossible to retrieve the attribute " + collectionDescriptor.getFieldName() + " in the class " + collectionDescriptor.getClassDescriptor().getClassName() + " because it is not a collection");
            }
            for (int i = 0; i < values.length; ++i) {
                String uuid = values[i].getString();
                String path = session.getNodeByUUID(uuid).getPath();
                Object object = this.objectConverter.getObject(session, path);
                ((ManageableCollection)objects).addObject(object);
            }
            return objects;
        }
        catch (Exception e) {
            throw new ObjectContentManagerException("Cannot get the collection field : " + collectionDescriptor.getFieldName() + "for class " + collectionDescriptor.getClassDescriptor().getClassName(), e);
        }
    }

    protected boolean doIsNull(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, Class collectionFieldClass) throws RepositoryException {
        String jcrName = this.getCollectionJcrName(collectionDescriptor);
        return !parentNode.hasProperty(jcrName);
    }

    private void addUuidProperties(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, ManageableObjects objects) throws UnsupportedRepositoryOperationException, RepositoryException, VersionException, LockException, ConstraintViolationException {
        try {
            if (objects == null) {
                return;
            }
            String jcrName = this.getCollectionJcrName(collectionDescriptor);
            Value[] values = new Value[objects.getSize()];
            ValueFactory valueFactory = session.getValueFactory();
            Iterator collectionIterator = objects.getIterator();
            for (int i = 0; i < objects.getSize(); ++i) {
                Object object = collectionIterator.next();
                if (object == null) continue;
                ClassDescriptor classDescriptor = this.mapper.getClassDescriptorByClass(object.getClass());
                FieldDescriptor fieldDescriptor = classDescriptor.getUuidFieldDescriptor();
                if (fieldDescriptor == null) {
                    throw new JcrMappingException("The bean doesn't have an uuid - classdescriptor : " + classDescriptor.getClassName());
                }
                String uuid = (String)ReflectionUtils.getNestedProperty(object, fieldDescriptor.getFieldName());
                values[i] = valueFactory.createValue(uuid, 9);
            }
            parentNode.setProperty(jcrName, values);
        }
        catch (Exception e) {
            throw new ObjectContentManagerException("Cannot insert collection field : " + collectionDescriptor.getFieldName() + " of class " + collectionDescriptor.getClassDescriptor().getClassName(), e);
        }
    }
}

