/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.ocm.manager.atomictypeconverter.impl;

import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.ocm.exception.IncorrectAtomicTypeException;
import org.apache.jackrabbit.ocm.manager.atomictypeconverter.AtomicTypeConverter;

public class UndefinedTypeConverterImpl
implements AtomicTypeConverter {
    public Value getValue(ValueFactory valueFactory, Object propValue) {
        if (propValue == null) {
            return null;
        }
        if (propValue instanceof String) {
            return valueFactory.createValue((String)propValue);
        }
        if (propValue instanceof InputStream) {
            return valueFactory.createValue((InputStream)propValue);
        }
        if (propValue instanceof Long || propValue instanceof Integer) {
            return valueFactory.createValue(((Number)propValue).longValue());
        }
        if (propValue instanceof Double) {
            return valueFactory.createValue(((Double)propValue).doubleValue());
        }
        if (propValue instanceof Boolean) {
            return valueFactory.createValue(((Boolean)propValue).booleanValue());
        }
        if (propValue instanceof Calendar) {
            return valueFactory.createValue((Calendar)propValue);
        }
        if (propValue instanceof GregorianCalendar) {
            return valueFactory.createValue((Calendar)((GregorianCalendar)propValue));
        }
        if (propValue instanceof Date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)propValue);
            return valueFactory.createValue(calendar);
        }
        throw new IncorrectAtomicTypeException("Impossible to convert the value - property type not found");
    }

    public Object getObject(Value value) {
        try {
            if (value.getType() == 1) {
                return value.getString();
            }
            if (value.getType() == 5) {
                return value.getDate();
            }
            if (value.getType() == 2) {
                return value.getStream();
            }
            if (value.getType() == 4) {
                return new Double(value.getDouble());
            }
            if (value.getType() == 3) {
                return new Long(value.getLong());
            }
            if (value.getType() == 6) {
                return new Boolean(value.getBoolean());
            }
            if (value.getType() == 7) {
                return value.getString();
            }
            if (value.getType() == 8) {
                return value.getString();
            }
            if (value.getType() == 9) {
                return value.getString();
            }
            throw new IncorrectAtomicTypeException("Impossible to create the value object - unsupported class");
        }
        catch (RepositoryException e) {
            throw new IncorrectAtomicTypeException("Impossible to convert the value : " + value.toString(), e);
        }
    }

    public String getXPathQueryValue(ValueFactory valueFactory, Object object) {
        return "'" + object.toString() + "'";
    }
}

