/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.ocm.manager.atomictypeconverter.impl;

import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.ocm.exception.IncorrectAtomicTypeException;
import org.apache.jackrabbit.ocm.manager.atomictypeconverter.AtomicTypeConverter;

public class PathTypeConverterImpl
implements AtomicTypeConverter {
    public Value getValue(ValueFactory valueFactory, Object propValue) {
        try {
            if (propValue == null) {
                return null;
            }
            return valueFactory.createValue((String)propValue, 8);
        }
        catch (RepositoryException e) {
            throw new IncorrectAtomicTypeException("Impossible to convert the value into a path property : " + propValue.toString() + ". Check if it is a valid path.", e);
        }
    }

    public Object getObject(Value value) {
        try {
            return value.getString();
        }
        catch (RepositoryException e) {
            throw new IncorrectAtomicTypeException("Impossible to convert the path into a string", e);
        }
    }

    public String getXPathQueryValue(ValueFactory valueFactory, Object object) {
        return "'" + object.toString() + "'";
    }
}

