/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.ocm.manager.atomictypeconverter.impl;

import java.io.InputStream;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.ocm.manager.atomictypeconverter.impl.AtomicTypeConverterProviderImpl;
import org.apache.jackrabbit.ocm.manager.atomictypeconverter.impl.BinaryTypeConverterImpl;
import org.apache.jackrabbit.ocm.manager.atomictypeconverter.impl.BooleanTypeConverterImpl;
import org.apache.jackrabbit.ocm.manager.atomictypeconverter.impl.ByteArrayTypeConverterImpl;
import org.apache.jackrabbit.ocm.manager.atomictypeconverter.impl.CalendarTypeConverterImpl;
import org.apache.jackrabbit.ocm.manager.atomictypeconverter.impl.DoubleTypeConverterImpl;
import org.apache.jackrabbit.ocm.manager.atomictypeconverter.impl.IntTypeConverterImpl;
import org.apache.jackrabbit.ocm.manager.atomictypeconverter.impl.LongTypeConverterImpl;
import org.apache.jackrabbit.ocm.manager.atomictypeconverter.impl.StringTypeConverterImpl;
import org.apache.jackrabbit.ocm.manager.atomictypeconverter.impl.TimestampTypeConverterImpl;
import org.apache.jackrabbit.ocm.manager.atomictypeconverter.impl.UtilDateTypeConverterImpl;

public class DefaultAtomicTypeConverterProvider
extends AtomicTypeConverterProviderImpl {
    public DefaultAtomicTypeConverterProvider() {
        this.m_converters = this.registerDefaultAtomicTypeConverters();
    }

    public DefaultAtomicTypeConverterProvider(Map converters) {
        this();
        this.m_converters.putAll(converters);
    }

    public void setAtomicTypeConvertors(Map converters) {
        this.m_converters.putAll(converters);
    }

    protected Map registerDefaultAtomicTypeConverters() {
        HashMap<Class, Class> converters = new HashMap<Class, Class>();
        converters.put(String.class, StringTypeConverterImpl.class);
        converters.put(InputStream.class, BinaryTypeConverterImpl.class);
        converters.put(Long.TYPE, LongTypeConverterImpl.class);
        converters.put(Long.class, LongTypeConverterImpl.class);
        converters.put(Integer.TYPE, IntTypeConverterImpl.class);
        converters.put(Integer.class, IntTypeConverterImpl.class);
        converters.put(Double.TYPE, DoubleTypeConverterImpl.class);
        converters.put(Double.class, DoubleTypeConverterImpl.class);
        converters.put(Boolean.TYPE, BooleanTypeConverterImpl.class);
        converters.put(Boolean.class, BooleanTypeConverterImpl.class);
        converters.put(Calendar.class, CalendarTypeConverterImpl.class);
        converters.put(GregorianCalendar.class, CalendarTypeConverterImpl.class);
        converters.put(Date.class, UtilDateTypeConverterImpl.class);
        converters.put(byte[].class, ByteArrayTypeConverterImpl.class);
        converters.put(Timestamp.class, TimestampTypeConverterImpl.class);
        return converters;
    }
}

